<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Pengasuh extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('login/m_account');
        // set title
        // $this->display($data);
    }

	public function index(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // data akun
        $sess = $this->get_user_detail();
        $params = $sess['id'];
        $result = $this->m_account->get_user_detail(array($params));
        // tampilkan notifikasi
        $data['title'] = 'Pengasuh';
        $data['notifikasi'] = $this->lnotifikasi->tampilkan_notifikasi();
        $data['result'] = ($this->lnotifikasi->tampilkan_inputan() == NULL)?$result:$this->lnotifikasi->tampilkan_inputan();
        $data['template'] = 'pengasuh/pengasuh';
		$this->display($data);
	}

    public function edit_result(){
        // notifikasi selection
        $this->lnotifikasi->set_rules('nama', 'Nama Lengkap', 'trim|required|max_length[60]');
        $this->lnotifikasi->set_rules('username', 'Username', 'trim|required|max_length[60]');
        $this->lnotifikasi->set_rules('password', 'Password', 'trim|required|max_length[60]');
        $this->lnotifikasi->set_rules('re-password', 'Ulangi Password', 'trim|required|max_length[60]');
        $this->lnotifikasi->set_rules('alamat', 'Alamat', 'trim|required');
        $this->lnotifikasi->set_rules('email', 'E-mail', 'trim|required|valid_email');
        // selectiion
        if ($this->lnotifikasi->run() !== FALSE){
            $params = array(
                'username' => $this->input->post('username', TRUE),
                'nama' => $this->input->post('nama', TRUE),
                'alamat' => $this->input->post('alamat', TRUE),
                'email' => $this->input->post('email', TRUE)
            );
            $where = array(
                'id' => $this->input->post('id', TRUE)
            );
            // selection jika lolos
            if($this->m_account->update_account($params, $where)){
                $this->lnotifikasi->kirim_notification('success', 'Data berhasil disimpan');
                redirect(base_url().'admin/account');
            }else{
                $this->lnotifikasi->kirim_notification('error', 'Data gagal disimpan');
                redirect(base_url().'admin/account');
            }
        }else{
            $this->lnotifikasi->kirim_notification('error', 'Data gagal disimpan');
            redirect(base_url().'admin/account');
        }
        redirect(base_url().'admin/account');
    }
}