<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoginBase.php' );

class Login extends LoginBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        $this->load->model('login/m_login');
        $this->load->library('form_validation');
        // load codeigniter captcha helper
        $this->load->library('securimage/securimage');
        $this->securimage = new Securimage(); 
    }

	public function index()
	{
        $data['load_style'] = $this->load_style("resource/themes/css/theme-default.css");
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/jquery/jquery.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/jquery/jquery-ui.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // INPUT POST
        if ($this->input->post()) {
            # code...
            // selection
            $username = $this->input->post('username', TRUE);
            $password = md5($this->input->post('password', TRUE));
            $security_code = $this->input->post('security_code', TRUE);
            // selection
            if ($this->securimage->check($this->input->post('security_code')) == TRUE){
                $captcha_check = TRUE;
            }else{
                $captcha_check = FALSE;
            }
            $result = $this->m_login->get_valid_account(array($username, $password));
            if($result && ($captcha_check == TRUE)  && ($result['verified'] == '1')) {
                $this->validate_session($result);
            }elseif(($username == '') OR ($password == '')) {
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Username atau Password belum dimasukkan';
                $this->session->set_userdata('notifikasi',$notifikasi);
            }elseif($security_code == '') {
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Kode Keamanan Belum Diisi';
                $this->session->set_userdata('notifikasi',$notifikasi);
            }elseif($result['verified'] == '0') {
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Akun anda belum diverifikasi!';
                $this->session->set_userdata('notifikasi',$notifikasi);
            }elseif($captcha_check == FALSE) {
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Kode Keamanan Salah';
                $this->session->set_userdata('notifikasi',$notifikasi);
            }else{
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Anda memasukkan Username atau Password yang salah';
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
    	// load into a view
        $data['result'] = @$this->input->post();
		$this->display('login/view_login', $data);
	}

    public function login_result(){
        // load into a view
        $data['load_style'] = $this->load_style("resource/themes/css/theme-default.css");
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/jquery/jquery.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/jquery/jquery-ui.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // selection
        $username = $this->input->post('username', TRUE);
        $password = md5($this->input->post('password', TRUE));
        $security_code = $this->input->post('security_code', TRUE);
        // selection
        $result = $this->m_login->get_valid_account(array($username, $password));
        print_r($result);die();
        if($result && ($this->securimage->check($this->input->post('security_code'))) && ($result['verified'] == '1')) {
            $this->validate_session($result);
        }elseif(($username == '') OR ($password == '')) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Username atau Password belum dimasukkan';
            $this->session->set_userdata('notifikasi',$notifikasi);
        }elseif($security_code == '') {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Kode Keamanan Belum Diisi';
            $this->session->set_userdata('notifikasi',$notifikasi);
        }elseif(!$this->securimage->check($this->input->post('security_code'))) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Kode Keamanan Salah';
            $this->session->set_userdata('notifikasi',$notifikasi);
        }elseif($result['verified'] == '0') {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Akun anda belum diverifikasi!';
            $this->session->set_userdata('notifikasi',$notifikasi);
        }else{
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Anda memasukkan Username atau Password yang salah';
            $this->session->set_userdata('notifikasi',$notifikasi);
        }
        // load into a view
        $this->display('login/view_login', $data);
    }

    public function validate_session($result){
        // assign params for session
        $params = array(
            'id' => $result['id'],
            'username' => $result['username'],
            'nama' => $result['nama'],
            'alamat' => $result['alamat'],
            'email' => $result['email'],
            'hak_akses' => $result['hak_akses'],
            'panti_id' => $result['panti_id'],
            'logged' => TRUE
        );
        // declare the session
        $this->session->set_userdata('mpspwmdiy_system', $params);
        redirect(base_url().'logged/dashboard');
    }

    // sign in
    public function sign_up(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/select2/select2.js");
        // load css
        $data['load_css'] = $this->load_style("resource/themes/js/plugins/select2/select2.css");
        // load codeigniter captcha helper
        $this->load->helper('captcha');
        // list panti asuhan
        $data['rs_panti'] = $this->m_login->get_list_panti();
        // declare variable
        $rand = random_string('numeric', 5);
        $vals = array(
            'word' => $rand,
            'img_path'   => './captcha/',
            'img_url'    => base_url().'captcha/',
            'font_path' => base_url() . 'system/fonts/texb.ttf',
            'img_width'  => '250',
            'img_height' => 40,
            'border' => 0, 
            'expiration' => 7200
        );
        // create captcha image
        $cap = create_captcha($vals);
        // store image html code in a variable
        $data['image'] = $cap['image'];
        // store the captcha word in a session
        $security_code = $this->input->post('security_code', TRUE);
        $this->session->set_userdata('mycaptcha', $cap['word']);
        if ($this->input->post()){
            // validasi
            $this->form_validation->set_rules('nama', 'Nama', 'strip_tags|required');
            $this->form_validation->set_rules('alamat', 'Alamat', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required|max_length[20]');
            $this->form_validation->set_rules('email', 'Email', 'strip_tags|valid_email|callback_check_email_stock|required');
            $this->form_validation->set_rules('username', 'Username', 'strip_tags|required');
            $this->form_validation->set_rules('password', 'Password', 'strip_tags|required');
            $this->form_validation->set_rules('password_repeat', 'Ulangi Password', 'strip_tags|required');
            // selectiion
            if (($this->input->post('password', TRUE)) !== ($this->input->post('password_repeat', TRUE))) {
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Isian Password harus sama dengan Ulangi Password';
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
            if($security_code <> $this->session->userdata('mycaptcha')) {
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Kode Keamanan Salah';
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
            if ($this->form_validation->run() !== FALSE){
                // inser data donatur baru
                // harus kode perkiraan yang berbeda
                $params = array(
                    'nama' => $this->input->post('nama', TRUE),
                    'alamat' => $this->input->post('alamat', TRUE),
                    'panti_id' => $this->input->post('panti_id', TRUE),
                    'email' => $this->input->post('email', TRUE),
                    'username' => $this->input->post('username', TRUE),
                    'password' => md5($this->input->post('password', TRUE)),
                    'hak_akses' => 3
                );
                // selection jika lolos
                if($this->m_login->insert_member($params)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Disimpan, Tunggu verifikasi dari admin';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'login/login');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // load into a view
        $result = $this->input->post();
        $data['result'] = @$result;
        $this->display('login/view_sign_up', $data);       
    }

    // sign in
    public function forget_password(){
        // load into a view
        $data['load_style'] = $this->load_style("resource/themes/css/theme-default.css");
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/jquery/jquery.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/jquery/jquery-ui.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // load css
        if ($this->input->post()){
            // selectiion
            if ($this->input->post('email', TRUE) == null) {
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Anda belum memasukkan email';
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
            // cek email
            $email = $this->input->post('email', TRUE);
            $result = $this->m_login->get_detail_akun_by_email(array($email));
            $message = '
            Klik link berikut untuk melakukan penggantian password : <br>
            '.base_url().'login/change_password/'.en($result['id']);
            // selection jika lolos
            if($result){
                $this->m_login->kirim_pesan($result['email'], $message);
                $notifikasi['notification_header'] = 'success';
                $notifikasi['notification_message'] = 'Data Berhasil Disimpan, Silahkan cek email anda';
                $this->session->set_userdata('notifikasi',$notifikasi);
                redirect(base_url().'login/login');
            } else {
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Data E-mail tidak ditemukan';
                $this->session->set_userdata('notifikasi',$notifikasi);                 
            }
        }

        // load into a view
        $result = $this->input->post();
        $data['result'] = @$result;
        $this->display('login/view_forget_password', $data);       
    }

    // sign in
    public function change_password($param){
        // load into a view
        $data['load_style'] = $this->load_style("resource/themes/css/theme-default.css");
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/jquery/jquery.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/jquery/jquery-ui.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // load css
        if ($this->input->post()){
            // selectiion
            if (($this->input->post('password', TRUE)) !== ($this->input->post('password_repeat', TRUE))) {
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Isian Password harus sama dengan Ulangi Password';
                $this->session->set_userdata('notifikasi',$notifikasi);
            } else {
                $id = de($param);
                // cek email
                $params = array(
                    'password' => md5($this->input->post('password', TRUE))
                );
                $where = array(
                    'id' => $id
                );
                if($this->m_login->update_akun($params, $where)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Password berhasil diubah';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'login/login');
                }else{
                    $notifikasi['notification_header'] = 'error';
                    $notifikasi['notification_message'] = 'Data Password gagal diubah';
                    $this->session->set_userdata('notifikasi',$notifikasi);                   
                }
            }
        }
        // load into a view
        $data['param_id'] = $param;
        $result = $this->input->post();
        $data['result'] = @$result;
        $this->display('login/view_change_password', $data);       
    }

    public function securimage(){
        $this->load->config('csecurimage');
        $active = $this->config->item('si_active');     
        $allsettings = array_merge($this->config->item($active), $this->config->item('si_general'));
        $this->load->library('securimage/securimage');
        $img = new Securimage($allsettings);
        $img->show(APPPATH . 'libraries/securimage/backgrounds/bg4.png');
    }

        // Callback function
    public function check_email_stock(){
        $email = $this->input->post('email');
        $result = $this->m_login->get_detail_akun_by_email(array($email));
        if ($result) {
            $this->form_validation->set_message('check_email_stock', 'Data Email telah terdaftar!');
            return FALSE;
        } else {
            return TRUE;
        }
    }
}