<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Uang_muka extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/transaksi/m_uang_muka');
        // load library
        $this->load->library('pagination');
        $this->load->library('m_pdf');
    }

    function load_js(){
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/select2/select2.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/typeahead/typeahead.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js"); 
        return $data['load_js'];
    }

    function load_css(){
        $data['load_css'] = $this->load_style("resource/themes/js/plugins/select2/select2.css");
        return $data['load_css'];
    }

    public function index(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // search
        $search = $this->session->userdata('search_uang_muka');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        // get nama panti dari detail
        $searched_panti = (empty($search['searched_panti']))? null : $search['searched_panti'];
        $searched_tanggal_pembayaran = (empty($search['searched_tanggal_pembayaran']))? '%%' : $search['searched_tanggal_pembayaran'];
        $searched_post = (empty($search['searched_post']))? '%%' : '%%' . $search['searched_post'] . '%' ;
        // detail panti untuk yg login sebagai panti
        $data['det_panti'] = $this->m_uang_muka->get_detail_panti(array($this->session_detail['panti_id']));
        // list panti
        $data['rs_panti'] = $this->m_uang_muka->get_list_panti();
        // total bantuan berdasarkan pilihan panti
        $data['total_bantuan'] = $this->m_uang_muka->get_total_bantuan(array($searched_panti, $searched_tanggal_pembayaran, $searched_post));
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/transaksi/uang_muka/index/';
        $config['total_rows'] = $this->m_uang_muka->get_total_uang_muka(array($searched_panti, $searched_tanggal_pembayaran, $searched_post));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_uang_muka'] = $this->m_uang_muka->get_list_uang_muka(array($searched_panti, $searched_tanggal_pembayaran, $searched_post, ($start - 1), $config['per_page']));
        // tampilkan notifikasi
        $data['title'] = 'Uang Muka';
        $data['template'] = 'logged/transaksi/uang_muka/view_uang_muka';
        $this->display($data);
    }

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "searched_post" => $this->input->post('searched_post', TRUE),
                "searched_panti" => $this->input->post('searched_panti', TRUE),
                "searched_tanggal_pembayaran" => $this->input->post('searched_tanggal_pembayaran', TRUE)
            );
            // set session
            $this->session->set_userdata("search_uang_muka", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_uang_muka");
        }
        // redirect
        redirect(base_url() . "logged/transaksi/uang_muka");
    }

    public function uang_muka_add(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // list panti
        $data['rs_panti'] = $this->m_uang_muka->get_list_panti();
        // detail panti
        $data['det_panti'] = $this->m_uang_muka->get_detail_panti(array($this->session_detail['panti_id']));
        // list master rekening
        $data['rs_rekening'] = $this->m_uang_muka->get_list_rekening();
        // list pegawai
        $data['rs_pegawai'] = $this->m_uang_muka->get_list_pegawai(array($this->session_detail['panti_id']));
        // result
        $result = ($this->input->post())?$this->input->post():null;
        // submit
        if ($this->input->post()){
            // validasi
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            if ($this->input->post('pegawai', TRUE) == 'lain'){
                $this->form_validation->set_rules('nama_pegawai', 'Pegawai', 'strip_tags|required|max_length[100]');
            }else{
                $this->form_validation->set_rules('pegawai', 'Pegawai', 'strip_tags|required');
            }
            $this->form_validation->set_rules('no_voucher', 'Nomor Voucher', 'strip_tags|required|max_length[30]');
            $this->form_validation->set_rules('tanggal_pembayaran', 'Tanggal Penerimaan', 'strip_tags|required|max_length[20]');
            $this->form_validation->set_rules('rekening_kas_bank_id', 'Sumber Dana', 'strip_tags|required|max_length[10]');
            $this->form_validation->set_rules('jumlah', 'Jumlah', 'strip_tags|required');
            $this->form_validation->set_rules('keterangan', 'Keterangan', 'strip_tags|required');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                // inser data pegawai baru
                if ($this->input->post('pegawai', TRUE) == 'lain') {
                    $params = array(
                        'nama_pegawai' => $this->input->post('nama_pegawai', TRUE),
                        'panti_id' => $this->input->post('panti_id', TRUE)
                    );
                    // selection jika lolos
                    $this->m_uang_muka->insert_pegawai($params);
                    $pegawai_id = $this->db->insert_id();              
                }else{
                    $pegawai_id = $this->input->post('pegawai', TRUE);
                }
                // harus kode perkiraan yang berbeda
                $params = array(
                    'panti_id' => $this->input->post('panti_id', TRUE),
                    'no_voucher' => $this->input->post('no_voucher', TRUE),
                    'tanggal_pembayaran' => $this->input->post('tanggal_pembayaran', TRUE),
                    'rekening_kas_bank_id' => $this->input->post('rekening_kas_bank_id', TRUE),
                    'pegawai_id' => $pegawai_id,
                    'jumlah' => input_uang($this->input->post('jumlah', TRUE)),
                    'keterangan' => $this->input->post('keterangan', TRUE)
                );
                // selection jika lolos
                if($this->m_uang_muka->insert_uang_muka($params)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/transaksi/uang_muka');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }        
        }
        // tampilkan notifikasi
        $data['result'] = $result;
        $data['title'] = 'Tambah Data Bantuan Uang';
        $data['template'] = 'logged/transaksi/uang_muka/view_uang_muka_add';
        $this->display($data);
    }

    public function uang_muka_edit($id = ''){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // list panti
        $data['rs_panti'] = $this->m_uang_muka->get_list_panti();
        // detail panti
        $data['det_panti'] = $this->m_uang_muka->get_detail_panti(array($this->session_detail['panti_id']));
        // list master rekening
        $data['rs_rekening'] = $this->m_uang_muka->get_list_rekening();
        // LOAD DATA
        $param_id = de($id);
        $result = $this->m_uang_muka->get_uang_muka_by_id(array($param_id));
        // list pegawai
        $data['rs_pegawai'] = $this->m_uang_muka->get_list_pegawai(array($result['panti_id']));
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/transaksi/uang_muka');
        }
        // validasi
        if ($this->input->post()){
       // validasi
        $this->form_validation->set_rules('uang_muka_id', 'Bantuan Uang ID', 'strip_tags|required');
        $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
        if ($this->input->post('pegawai', TRUE) == 'lain'){
            $this->form_validation->set_rules('nama_pegawai', 'Pegawai', 'strip_tags|required|max_length[100]');
        }else{
            $this->form_validation->set_rules('pegawai', 'Pegawai', 'strip_tags|required');
        }
        $this->form_validation->set_rules('no_voucher', 'Nomor Voucher', 'strip_tags|required|max_length[30]');
        $this->form_validation->set_rules('tanggal_pembayaran', 'Tanggal Penerimaan', 'strip_tags|required|max_length[20]');
        $this->form_validation->set_rules('rekening_kas_bank_id', 'Sumber Dana', 'strip_tags|required|max_length[10]');
        $this->form_validation->set_rules('jumlah', 'Jumlah', 'strip_tags|required');
        $this->form_validation->set_rules('keterangan', 'Keterangan', 'strip_tags|required');
        // selectiion
        if ($this->form_validation->run() !== FALSE){
            // inser data pegawai baru
            if ($this->input->post('pegawai', TRUE) == 'lain') {
                $params = array(
                    'nama_pegawai' => $this->input->post('nama_pegawai', TRUE),
                    'panti_id' => $this->input->post('panti_id', TRUE)
                );
                // selection jika lolos
                $this->m_uang_muka->insert_pegawai($params);
                $pegawai_id = $this->db->insert_id();              
            }else{
                $pegawai_id = $this->input->post('pegawai', TRUE);
            }
            // harus kode perkiraan yang berbeda
            $params = array(
                'panti_id' => $this->input->post('panti_id', TRUE),
                'no_voucher' => $this->input->post('no_voucher', TRUE),
                'tanggal_pembayaran' => $this->input->post('tanggal_pembayaran', TRUE),
                'rekening_kas_bank_id' => $this->input->post('rekening_kas_bank_id', TRUE),
                'pegawai_id' => $pegawai_id,
                'jumlah' => input_uang($this->input->post('jumlah', TRUE)),
                'keterangan' => $this->input->post('keterangan', TRUE)
            );
            $where = array(
                'uang_muka_id' => $this->input->post('uang_muka_id', TRUE)
            );
            // selection jika lolos
            if($this->m_uang_muka->update_uang_muka($params, $where)){
                $notifikasi['notification_header'] = 'success';
                $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                $this->session->set_userdata('notifikasi',$notifikasi);
                redirect(base_url().'logged/transaksi/uang_muka');
            }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Uang Muka';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'logged/transaksi/uang_muka/view_uang_muka_edit';
        $this->display($data);
    }

    public function uang_muka_edit_process($id = null){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // list panti
        $data['rs_panti'] = $this->m_uang_muka->get_list_panti();
        // detail panti
        $data['det_panti'] = $this->m_uang_muka->get_detail_panti(array($this->session_detail['panti_id']));
        // list master rekening
        $data['rs_rekening'] = $this->m_uang_muka->get_list_rekening();
        // LOAD DATA
        $param_id = de($id);
        $result = $this->input->post()?:$this->m_uang_muka->get_uang_muka_by_id(array($param_id));
        // list pegawai
        $data['rs_pegawai'] = $this->m_uang_muka->get_list_pegawai(array($result['panti_id']));
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/transaksi/uang_muka');
        }
 
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Bantuan Uang';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'logged/transaksi/uang_muka/view_uang_muka_edit';
        $this->display($data);
    }

    public function ajax_uang_muka_delete($id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/transaksi/uang_muka/uang_muka_delete_process/' . $id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function uang_muka_delete_process($id){
        // declare params
        $where = array(
            'uang_muka_id' => de($id)
        );
        if ($this->m_uang_muka->delete_uang_muka($where)){
            $notifikasi['notification_header'] = 'success';
            $notifikasi['notification_message'] = 'Data Berhasil Dihapus';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/transaksi/uang_muka');           
        }
    }

    // cetak
    public function uang_muka_cetak($id){
        // LOAD DATA
        $param_id = de($id);
        $data['result'] = $this->m_uang_muka->get_uang_muka_by_id_for_print(array($param_id));
        if (!$data) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/transaksi/uang_muka');
        }
        $this->load->view('logged/transaksi/uang_muka/cetak_uang_muka', $data);
        $sumber = $this->load->view('logged/transaksi/uang_muka/cetak_uang_muka', $data, TRUE);
        $html = $sumber;
        $pdfFilePath = "cetak_uang_muka.pdf";
        $pdf = $this->m_pdf->load();
        $pdf->AddPage('L');
        $pdf->WriteHTML($html);
        $pdf->Output($pdfFilePath, "D");
        exit();
    }

// getter

    public function get_list_pegawai($panti_id = null){
        $params = array($panti_id);
        $result = $this->m_uang_muka->get_list_pegawai($params);
        $data .= '<option value="">-- PILIH DONATUR --</option>';
        foreach ($result as $pegawai) {
            $data .= '<option value="'.$pegawai['pegawai_id'].'">'.$pegawai['nama_pegawai'].'</option>';
        }
        $data .= '<option value="lain">DONATUR LAIN</option>';
        echo $data;
    }
}