<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Pertanggungjawaban_uang_muka extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/transaksi/m_pertanggungjawaban_uang_muka');
        // load library
        $this->load->library('pagination');
    }

    function load_js(){
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/select2/select2.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js"); 
        return $data['load_js'];
    }

    function load_css(){
        $data['load_css'] = $this->load_style("resource/themes/js/plugins/select2/select2.css");
        return $data['load_css'];
    }

    public function index(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // search
        $search = $this->session->userdata('search_pertanggungjawaban_uang_muka');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        // get nama panti dari detail
        $searched_post = (empty($search['searched_post']))? '%%' : '%' . $search['searched_post'] . '%' ;
        $searched_panti = (empty($search['searched_panti']))? null : $search['searched_panti'];
        $searched_pegawai = (empty($search['searched_pegawai']))? null : $search['searched_pegawai'];
        // detail panti untuk yg login sebagai panti
        $data['det_panti'] = $this->m_pertanggungjawaban_uang_muka->get_detail_panti(array($this->session_detail['panti_id']));
        // list panti
        $data['rs_panti'] = $this->m_pertanggungjawaban_uang_muka->get_list_panti();
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/transaksi/pertanggungjawaban_uang_muka/index/';
        $config['total_rows'] = $this->m_pertanggungjawaban_uang_muka->get_total_pertanggungjawaban_uang_muka(array($searched_panti, $searched_pegawai, $searched_post));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_pertanggungjawaban_uang_muka'] = $this->m_pertanggungjawaban_uang_muka->get_list_pertanggungjawaban_uang_muka(array($searched_panti, $searched_pegawai, $searched_post, ($start - 1), $config['per_page']));
        // tampilkan notifikasi
        $data['title'] = 'Uang Muka';
        $data['template'] = 'logged/transaksi/pertanggungjawaban_uang_muka/view_pertanggungjawaban_uang_muka';
        $this->display($data);
    }

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "searched_post" => $this->input->post('searched_post', TRUE),
                "searched_panti" => $this->input->post('searched_panti', TRUE),
                "searched_pegawai" => $this->input->post('searched_pegawai', TRUE)
            );
            // set session
            $this->session->set_userdata("search_pertanggungjawaban_uang_muka", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_pertanggungjawaban_uang_muka");
        }
        // redirect
        redirect(base_url() . "logged/transaksi/pertanggungjawaban_uang_muka");
    }

    public function pertanggungjawaban_uang_muka_add(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // rekening kas bank
        $data['rs_rekening_kas_bank'] = $this->m_pertanggungjawaban_uang_muka->get_list_rekening_kas_bank();
        // list panti
        $data['rs_panti'] = $this->m_pertanggungjawaban_uang_muka->get_list_panti();
        // detail panti
        $data['det_panti'] = $this->m_pertanggungjawaban_uang_muka->get_detail_panti(array($this->session_detail['panti_id']));
        // tampilkan notifikasi
        $data['result'] = @$this->input->post();
        if ($this->input->post()){
            // validasi
            $this->form_validation->set_rules('no_voucher', 'Nomor Voucher', 'strip_tags|required|max_length[20]');
            $this->form_validation->set_rules('tanggal_transaksi', 'Tanggal Transaksi', 'strip_tags|required');
            $this->form_validation->set_rules('rekening_kas_bank_id', 'Kode Rekening', 'strip_tags|required');
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('pegawai_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('keterangan', 'Keterangan', 'strip_tags|required');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'no_voucher' => $this->input->post('no_voucher', TRUE),
                    'tanggal_transaksi' => $this->input->post('tanggal_transaksi', TRUE),
                    'rekening_kas_bank_id' => $this->input->post('rekening_kas_bank_id', TRUE),
                    'keterangan' => $this->input->post('keterangan', TRUE),
                    'pegawai_id' => $this->input->post('pegawai_id', TRUE),
                    'panti_id' => $this->input->post('panti_id', TRUE)
                );
                // selection jika lolos
                if($this->m_pertanggungjawaban_uang_muka->insert_pertanggungjawaban_uang_muka($params)){
                    $pertanggungjawaban_uang_muka_id = $this->db->insert_id();
                    $count = count($this->input->post('tanggal_uang_muka_key', TRUE));
                    for ($i=0; $i < $count; $i++) { 
                        $params = array(
                            'pertanggungjawaban_uang_muka_id' => $pertanggungjawaban_uang_muka_id,
                            'uang_muka_id' => $this->input->post('uang_muka_id_key', TRUE)[$i],
                            'tanggal_uang_muka' => $this->input->post('tanggal_uang_muka_key', TRUE)[$i],
                            'jumlah_uang_muka' => input_uang($this->input->post('jumlah_uang_muka_key', TRUE)[$i]),
                            'jumlah_spj' => input_uang($this->input->post('jumlah_spj_key', TRUE)[$i])
                        );
                        $this->m_pertanggungjawaban_uang_muka->insert_persekot($params);  
                    }
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/transaksi/pertanggungjawaban_uang_muka');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }     
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Pertanggungjawaban Uang Muka';
        $data['result'] = $result;
        $data['template'] = 'logged/transaksi/pertanggungjawaban_uang_muka/view_pertanggungjawaban_uang_muka_add';
        $this->display($data);
    }

    public function pertanggungjawaban_uang_muka_edit($id = ''){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // LOAD DATA
        $param_id = de($id);
        $result = ($this->input->post())?$this->input->post():$this->m_pertanggungjawaban_uang_muka->get_pertanggungjawaban_uang_muka_by_id(array($param_id));
        // rekening kas bank
        $data['rs_rekening_kas_bank'] = $this->m_pertanggungjawaban_uang_muka->get_list_rekening_kas_bank();
        // list panti
        $data['rs_panti'] = $this->m_pertanggungjawaban_uang_muka->get_list_panti();
        // detail panti
        $data['det_panti'] = $this->m_pertanggungjawaban_uang_muka->get_detail_panti(array($this->session_detail['panti_id']));
        // rs persekot
        $data['rs_persekot'] = $this->m_pertanggungjawaban_uang_muka->get_list_persekot_by_pertanggungjawaban_uang_muka_id(array($param_id));
        // list pegawai
        $data['rs_pegawai'] = $this->m_pertanggungjawaban_uang_muka->get_list_pegawai(array($result['panti_id']));
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/transaksi/pertanggungjawaban_uang_muka');
        }
        // submit
        if ($this->input->post()){
            // validasi
            $this->form_validation->set_rules('pertanggungjawaban_uang_muka_id', 'Pertanggungjawaban Uang Muka', 'strip_tags|required');
            $this->form_validation->set_rules('no_voucher', 'Nomor Voucher', 'strip_tags|required|max_length[20]');
            $this->form_validation->set_rules('tanggal_transaksi', 'Tanggal Transaksi', 'strip_tags|required');
            $this->form_validation->set_rules('rekening_kas_bank_id', 'Kode Rekening', 'strip_tags|required');
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('pegawai_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('keterangan', 'Keterangan', 'strip_tags|required');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'no_voucher' => $this->input->post('no_voucher', TRUE),
                    'tanggal_transaksi' => $this->input->post('tanggal_transaksi', TRUE),
                    'rekening_kas_bank_id' => $this->input->post('rekening_kas_bank_id', TRUE),
                    'keterangan' => $this->input->post('keterangan', TRUE),
                    'pegawai_id' => $this->input->post('pegawai_id', TRUE)
                );
                $where = array(
                    'pertanggungjawaban_uang_muka_id' => $this->input->post('pertanggungjawaban_uang_muka_id', TRUE)
                );
                // selection jika lolos
                if($this->m_pertanggungjawaban_uang_muka->update_pertanggungjawaban_uang_muka($params, $where)){
                    $pertanggungjawaban_uang_muka_id = $this->input->post('pertanggungjawaban_uang_muka_id', TRUE);
                    $count = count($this->input->post('persekot_id_key', TRUE));
                    for ($i=0; $i < $count; $i++) { 
                        $params = array(
                            'tanggal_uang_muka' => $this->input->post('tanggal_uang_muka_key', TRUE)[$i],
                            'jumlah_uang_muka' => input_uang($this->input->post('jumlah_uang_muka_key', TRUE)[$i]),
                            'jumlah_spj' => input_uang($this->input->post('jumlah_spj_key', TRUE)[$i])
                        );
                        $where = array(
                            'pertanggungjawaban_uang_muka_id' => $pertanggungjawaban_uang_muka_id,
                            'persekot_id' => $this->input->post('persekot_id_key', TRUE)[$i]
                        );
                        $this->m_pertanggungjawaban_uang_muka->update_persekot($params, $where);  
                    }
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/transaksi/pertanggungjawaban_uang_muka');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }     
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Uang Muka';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'logged/transaksi/pertanggungjawaban_uang_muka/view_pertanggungjawaban_uang_muka_edit';
        $this->display($data);
    }

    public function ajax_pertanggungjawaban_uang_muka_delete($id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/transaksi/pertanggungjawaban_uang_muka/pertanggungjawaban_uang_muka_delete_process/' . $id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function pertanggungjawaban_uang_muka_delete_process($id){
        // declare params
        $where = array(
            'pertanggungjawaban_uang_muka_id' => de($id)
        );
        if ($this->m_pertanggungjawaban_uang_muka->delete_pertanggungjawaban_uang_muka($where)){
            $notifikasi['notification_header'] = 'success';
            $notifikasi['notification_message'] = 'Data Berhasil Dihapus';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/transaksi/pertanggungjawaban_uang_muka');           
        }
    }

// --GETTER
    public function get_list_uang_muka_by_pegawai($id){
        $pegawai_id = $id;
        $rs_uang_muka = $this->m_pertanggungjawaban_uang_muka->get_list_uang_muka_by_pegawai_id(array($pegawai_id));
        if ($rs_uang_muka){
            $no = 1;
            $list_uang_muka = '';
            foreach($rs_uang_muka as $result) {
                $list_uang_muka .= '
                    <tr class="class-item">
                        <td class="text-center">'.$no.'</td>
                        <td>
                            <input type="hidden" class="form-control" name="pertanggungjawaban_uang_muka_id_key[]" value="'.$result['pertanggungjawaban_uang_muka_id'].'">
                            <input type="hidden" class="form-control" name="uang_muka_id_key[]" value="'.$result['uang_muka_id'].'">
                            '.$result['no_voucher'].'
                        </td>
                        <td>
                            '.$result['keterangan'].'
                        </td>
                        <td>
                            <input type="text" class="form-control datepicker" data-date-format="yyyy-mm-dd" name="tanggal_uang_muka_key[]">
                        </td>
                        <td>
                            <input type="text" class="form-control" onkeyup="return formatNumber(this)" name="jumlah_uang_muka_key[]">
                        </td>
                        <td>
                        <input type="text" class="form-control" onkeyup="return formatNumber(this)" name="jumlah_spj_key[]">
                        </td>
                    </tr>
                ';
            }
        }else{
            $list_uang_muka = '
                <tr><td colspan="6">Data Tidak Ditemukan</td></tr>
            ';
        }
        echo json_encode($list_uang_muka);
    }

    public function ajax_get_list_pegawai($id){
        $panti_id = $id;
        $rs_pegawai = $this->m_pertanggungjawaban_uang_muka->get_list_pegawai(array($panti_id));
        if ($rs_pegawai){
            $list_pegawai = '<option value="">-- PILIH PEGAWAI --</option>';
            foreach($rs_pegawai as $result) {
                $list_pegawai .= '
                    <option value="'.$result['pegawai_id'].'">'.$result['nama_pegawai'].'</option>
                ';
            }
        }else{
            $list_pegawai = '
                <tr><td colspan="5">Data Tidak Ditemukan</td></tr>
            ';
        }
        echo json_encode($list_pegawai);
    }
}