<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Penerimaan extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/transaksi/m_penerimaan');
        // load library
        $this->load->library('pagination');
    }

    function load_js(){
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/select2/select2.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js"); 
        return $data['load_js'];
    }

    function load_css(){
        $data['load_css'] = $this->load_style("resource/themes/js/plugins/select2/select2.css");
        return $data['load_css'];
    }

    public function index(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // search
        $search = $this->session->userdata('search_penerimaan');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        // get nama panti dari detail
        $searched_post = (empty($search['searched_post']))? '%' : '%' . $search['searched_post'] . '%' ;
        $searched_rekening_kas_bank_id = (empty($search['searched_rekening_kas_bank_id']))? '%' : '%' . $search['searched_rekening_kas_bank_id'] . '%' ;
        $searched_tanggal_transaksi = (empty($search['searched_tanggal_transaksi']))? '%' : '%' . $search['searched_tanggal_transaksi'] . '%' ;
        // tampilkan list kode perkiraan
        $data['rs_rekening_kas_bank'] = $this->m_penerimaan->get_list_rekening_kas_bank();
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/transaksi/penerimaan/penerimaan/index/';
        $config['total_rows'] = $this->m_penerimaan->get_total_penerimaan(array($searched_post, $searched_post, $searched_rekening_kas_bank_id, $searched_tanggal_transaksi));
        $config['uri_segment'] = 5;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_penerimaan'] = $this->m_penerimaan->get_list_penerimaan(array($searched_post, $searched_post, $searched_rekening_kas_bank_id, $searched_tanggal_transaksi, ($start - 1), $config['per_page']));
        // tampilkan notifikasi
        $data['title'] = 'Rekening Kas Bank';
        $data['template'] = 'logged/transaksi/penerimaan/view_penerimaan';
        $this->display($data);
    }

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "searched_post" => $this->input->post('searched_post', TRUE),
                "searched_rekening_kas_bank_id" => $this->input->post('searched_rekening_kas_bank_id', TRUE),
                "searched_tanggal_transaksi" => $this->input->post('searched_tanggal_transaksi', TRUE)
            );
            // set session
            $this->session->set_userdata("search_penerimaan", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_penerimaan");
        }
        // redirect
        redirect(base_url() . "logged/transaksi/penerimaan");
    }

    public function penerimaan_add(){
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // tampilkan rekening kas bank
        $data['rs_rekening_kas_bank'] = $this->m_penerimaan->get_list_rekening_kas_bank();
        // tampilkan pola jurnal
        $data['rs_pola_jurnal'] = $this->m_penerimaan->get_list_pola_jurnal();
        $data['result'] = @$this->input->post();
        if ($this->input->post()){
            // validasi
            $this->form_validation->set_rules('no_voucher', 'Nomor Voucher', 'strip_tags|required|max_length[20]');
            $this->form_validation->set_rules('tanggal_transaksi', 'Tanggal Transaksi', 'strip_tags|required');
            $this->form_validation->set_rules('rekening_kas_bank_id', 'Kode Rekening', 'strip_tags|required');
            $this->form_validation->set_rules('keterangan', 'Keterangan', 'strip_tags|required');
            $this->form_validation->set_rules('pola_jurnal_id', 'Pola Jurnal', 'strip_tags|required');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'no_voucher' => $this->input->post('no_voucher', TRUE),
                    'tanggal_transaksi' => $this->input->post('tanggal_transaksi', TRUE),
                    'rekening_kas_bank_id' => $this->input->post('rekening_kas_bank_id', TRUE),
                    'keterangan' => $this->input->post('keterangan', TRUE),
                    'pola_jurnal_id' => $this->input->post('pola_jurnal_id', TRUE)
                );
                // selection jika lolos
                if($this->m_penerimaan->insert_penerimaan($params)){
                    $penerimaan_id = $this->db->insert_id();
                    $count = count($this->input->post('pola_jurnal_id_key', TRUE));
                    for ($i=0; $i < $count; $i++) { 
                        $params = array(
                            'penerimaan_id' => $penerimaan_id,
                            'pola_jurnal_id' => $this->input->post('pola_jurnal_id', TRUE),
                            'keterangan' => $this->input->post('keterangan_key', TRUE)[$i],
                            'jumlah' => $this->input->post('jumlah_key', TRUE)[$i]
                        );
                        $this->m_penerimaan->insert_perkiraan_penerimaan($params);  
                    }
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/transaksi/penerimaan/penerimaan');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }     
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data penerimaan';
        $data['template'] = 'logged/transaksi/penerimaan/view_penerimaan_add';
        $this->display($data);
    }

    public function penerimaan_edit($id = ''){
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        $param_id = de($id);
        // tampilkan rekening kas bank
        $data['rs_rekening_kas_bank'] = $this->m_penerimaan->get_list_rekening_kas_bank();
        // tampilkan pola jurnal
        $data['rs_pola_jurnal'] = $this->m_penerimaan->get_list_pola_jurnal();
        $result = @$this->input->post()?:$this->m_penerimaan->get_penerimaan_by_id(array($param_id));
        $data['result'] = @$result;
        $data['data'] = @$result;
        // list perkiraan penerimaan
        $params = array($result['penerimaan_id'], $result['pola_jurnal_id']);
        $data['rs_perkiraan_penerimaan'] = $this->m_penerimaan->get_list_perkiraan_penerimaan_by_params($params);
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/transaksi/penerimaan');
        }
        // submit
        if ($this->input->post()){
            // validasi
            $this->form_validation->set_rules('penerimaan_id', 'Penerimaan', 'strip_tags|required');
            $this->form_validation->set_rules('no_voucher', 'Nomor Voucher', 'strip_tags|required|max_length[20]');
            $this->form_validation->set_rules('tanggal_transaksi', 'Tanggal Transaksi', 'strip_tags|required');
            $this->form_validation->set_rules('rekening_kas_bank_id', 'Kode Rekening', 'strip_tags|required');
            $this->form_validation->set_rules('keterangan', 'Keterangan', 'strip_tags|required');
            $this->form_validation->set_rules('pola_jurnal_id', 'Pola Jurnal', 'strip_tags|required');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'no_voucher' => $this->input->post('no_voucher', TRUE),
                    'tanggal_transaksi' => $this->input->post('tanggal_transaksi', TRUE),
                    'rekening_kas_bank_id' => $this->input->post('rekening_kas_bank_id', TRUE),
                    'keterangan' => $this->input->post('keterangan', TRUE),
                    'pola_jurnal_id' => $this->input->post('pola_jurnal_id', TRUE)
                );
                $where = array(
                    'penerimaan_id' => $this->input->post('penerimaan_id', TRUE)
                );
                // selection jika lolos
                if($this->m_penerimaan->update_penerimaan($params, $where)){
                    $penerimaan_id = $this->input->post('penerimaan_id', TRUE);
                    $count = count($this->input->post('pola_jurnal_id_key', TRUE));
                    for ($i=0; $i < $count; $i++) { 
                        $params = array(
                            'keterangan' => $this->input->post('keterangan_key', TRUE)[$i],
                            'jumlah' => $this->input->post('jumlah_key', TRUE)[$i]
                        );
                        $where = array(
                            'penerimaan_id' => $penerimaan_id,
                            'pola_jurnal_id' => $this->input->post('pola_jurnal_id', TRUE)
                        );
                        $this->m_penerimaan->update_perkiraan_penerimaan($params, $where);  
                    }
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/transaksi/penerimaan/penerimaan');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }     
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Penerimaan';
        $data['template'] = 'logged/transaksi/penerimaan/view_penerimaan_edit';
        $this->display($data);
    }

    public function ajax_penerimaan_delete($id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/transaksi/penerimaan/penerimaan_delete_process/' . $id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function penerimaan_delete_process($id){
        // declare params
        $where = array(
            'penerimaan_id' => de($id)
        );
        if ($this->m_penerimaan->delete_penerimaan($where)){
            $notifikasi['notification_header'] = 'success';
            $notifikasi['notification_message'] = 'Data Berhasil Dihapus';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/transaksi/penerimaan');           
        }
    }

    public function get_list_perkiraan($id){
        $pola_jurnal_id = $id;
        $rs_pola_jurnal = $this->m_penerimaan->get_list_perkiraan_by_id(array($pola_jurnal_id));
        if ($rs_pola_jurnal){
            $no = 1;
            $list_perkiraan = '';
            foreach($rs_pola_jurnal as $result) {
                $list_perkiraan .= '
                    <tr class="class-item"><td class="text-center">'.$no.'</td><td><input type="hidden" class="form-control" name="pola_jurnal_id_key[]" value="'.$result['pola_jurnal_id'].'"><input type="hidden" class="form-control" name="penerimaan_id[]" value="'.$result['perkiraan_jurnal_id'].'">'.$result['kode_perkiraan'].' -- '.$result['nama_perkiraan'].'</td><td><input type="text" class="form-control" name="jumlah_key[]"></td><td><input type="text" class="form-control" name="keterangan_key[]"></td></tr>
                ';
            }
        }else{
            $list_perkiraan = '
                <tr><td colspan="4">Data Tidak Ditemukan</td></tr>
            ';
        }
        echo $list_perkiraan;
    }
}