<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Aktiva_transaksi extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/transaksi/m_aktiva_transaksi');
        // load library
        $this->load->library('pagination');
    }

    function load_js(){
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/select2/select2.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js"); 
        return $data['load_js'];
    }

    function load_css(){
        $data['load_css'] = $this->load_style("resource/themes/js/plugins/select2/select2.css");
        return $data['load_css'];
    }

    public function index(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // search
        $search = $this->session->userdata('search_aktiva_transaksi');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        // get nama panti dari detail
        $searched_post = (empty($search['searched_post']))? '%%' : '%' . $search['searched_post'] . '%' ;
        $searched_panti = (empty($search['searched_panti']))? null : $search['searched_panti'];
        $searched_tanggal_perolehan = (empty($search['searched_tanggal_perolehan']))? '%%' : $search['searched_tanggal_perolehan'];
        $searched_aktiva_habis = (empty($search['searched_aktiva_habis']))? '%%' : $search['searched_aktiva_habis'];
        // detail panti untuk yg login sebagai panti
        $data['det_panti'] = $this->m_aktiva_transaksi->get_detail_panti(array($this->session_detail['panti_id']));
        // list panti
        $data['rs_panti'] = $this->m_aktiva_transaksi->get_list_panti();
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/transaksi/aktiva_transaksi/index/';
        $config['total_rows'] = $this->m_aktiva_transaksi->get_total_aktiva_transaksi(array($searched_panti, $searched_post, $searched_tanggal_perolehan, $searched_aktiva_habis));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_aktiva_transaksi'] = $this->m_aktiva_transaksi->get_list_aktiva_transaksi(array($searched_panti, $searched_post, $searched_tanggal_perolehan, $searched_aktiva_habis, ($start - 1), $config['per_page']));
        // tampilkan notifikasi
        $data['title'] = 'Master - Donatur';
        $data['template'] = 'logged/transaksi/aktiva_transaksi/view_aktiva_transaksi';
        $this->display($data);
    }

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "searched_post" => $this->input->post('searched_post', TRUE),
                "searched_panti" => $this->input->post('searched_panti', TRUE),
                "searched_tanggal_perolehan" => $this->input->post('searched_tanggal_perolehan', TRUE),
                "searched_aktiva_habis" => $this->input->post('searched_aktiva_habis', TRUE)
            );
            // set session
            $this->session->set_userdata("search_aktiva_transaksi", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_aktiva_transaksi");
        }
        // redirect
        redirect(base_url() . "logged/transaksi/aktiva_transaksi");
    }

    public function aktiva_transaksi_add(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // list panti
        $data['rs_panti'] = $this->m_aktiva_transaksi->get_list_panti();
        // detail panti
        $data['det_panti'] = $this->m_aktiva_transaksi->get_detail_panti(array($this->session_detail['panti_id']));
        // list aktiva
        $data['rs_aktiva'] = $this->m_aktiva_transaksi->get_list_aktiva();
        // list akumulasi penyusutan
        $data['rs_akumulasi_penyusutan'] = $this->m_aktiva_transaksi->get_list_akumulasi_penyusutan();
        // list biaya penyusutan
        $data['rs_biaya_penyusutan'] = $this->m_aktiva_transaksi->get_list_biaya_penyusutan();
        // result
        $result = $this->input->post()?:null;
        if ($this->input->post()){
            // validasi
            $this->form_validation->set_rules('aktiva_id', 'Akun Aktiva', 'strip_tags|required');
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('nama_aktiva_transaksi', 'Nama Aktiva Transaksi', 'strip_tags|required|max_length[255]');
            $this->form_validation->set_rules('akumulasi_penyusutan_id', 'Akun Akumulasi Penyusutan', 'strip_tags|required');
            $this->form_validation->set_rules('biaya_penyusutan_id', 'Akun Biaya Penyusutan', 'strip_tags|required');
            $this->form_validation->set_rules('masa', 'Masa', 'strip_tags|required');
            $this->form_validation->set_rules('tanggal_perolehan', 'Tanggal Perolehan', 'strip_tags|required');
            $this->form_validation->set_rules('aktiva_habis', 'Aktiva Habis', 'strip_tags|required');
            $this->form_validation->set_rules('harga_perolehan', 'Harga Perolehan', 'strip_tags|required');
            $this->form_validation->set_rules('sisa', 'Akun Aktiva', 'strip_tags|required');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                // harus kode perkiraan yang berbeda
                    $params = array(
                        'panti_id' => $this->input->post('panti_id', TRUE),
                        'aktiva_id' => $this->input->post('aktiva_id', TRUE),
                        'nama_aktiva_transaksi' => $this->input->post('nama_aktiva_transaksi', TRUE),
                        'akumulasi_penyusutan_id' => $this->input->post('akumulasi_penyusutan_id', TRUE),
                        'biaya_penyusutan_id' => $this->input->post('biaya_penyusutan_id', TRUE),
                        'masa' => $this->input->post('masa', TRUE),
                        'tanggal_perolehan' => $this->input->post('tanggal_perolehan', TRUE),
                        'aktiva_habis' => $this->input->post('aktiva_habis', TRUE),
                        'harga_perolehan' => input_uang($this->input->post('harga_perolehan', TRUE)),
                        'sisa' => $this->input->post('sisa', TRUE)
                    );
                    // selection jika lolos
                    if($this->m_aktiva_transaksi->insert_aktiva_transaksi($params)){
                        $notifikasi['notification_header'] = 'success';
                        $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                        $this->session->set_userdata('notifikasi',$notifikasi);
                        redirect(base_url().'logged/transaksi/aktiva_transaksi');
                    }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }     
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Aktiva Transaksi';
        $data['result'] = $result;
        $data['template'] = 'logged/transaksi/aktiva_transaksi/view_aktiva_transaksi_add';
        $this->display($data);
    }


    public function aktiva_transaksi_edit($id = ''){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // list panti
        $data['rs_panti'] = $this->m_aktiva_transaksi->get_list_panti();
        // detail panti
        $data['det_panti'] = $this->m_aktiva_transaksi->get_detail_panti(array($this->session_detail['panti_id']));
        // list aktiva
        $data['rs_aktiva'] = $this->m_aktiva_transaksi->get_list_aktiva();
        // list akumulasi penyusutan
        $data['rs_akumulasi_penyusutan'] = $this->m_aktiva_transaksi->get_list_akumulasi_penyusutan();
        // list biaya penyusutan
        $data['rs_biaya_penyusutan'] = $this->m_aktiva_transaksi->get_list_biaya_penyusutan();
        // LOAD DATA
        $param_id = de($id);
        $result = $this->input->post()?:$this->m_aktiva_transaksi->get_aktiva_transaksi_by_id(array($param_id));
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/transaksi/aktiva_transaksi');
        }
        if ($this->input->post()){
            // validasi
            $this->form_validation->set_rules('aktiva_transaksi_id', 'Aktiva Transaksi ID', 'strip_tags|required');
            $this->form_validation->set_rules('aktiva_id', 'Akun Aktiva', 'strip_tags|required');
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('nama_aktiva_transaksi', 'Nama Aktiva Transaksi', 'strip_tags|required|max_length[255]');
            $this->form_validation->set_rules('akumulasi_penyusutan_id', 'Akun Akumulasi Penyusutan', 'strip_tags|required');
            $this->form_validation->set_rules('biaya_penyusutan_id', 'Akun Biaya Penyusutan', 'strip_tags|required');
            $this->form_validation->set_rules('masa', 'Masa', 'strip_tags|required');
            $this->form_validation->set_rules('tanggal_perolehan', 'Tanggal Perolehan', 'strip_tags|required');
            $this->form_validation->set_rules('aktiva_habis', 'Aktiva Habis', 'strip_tags|required');
            $this->form_validation->set_rules('harga_perolehan', 'Harga Perolehan', 'strip_tags|required');
            $this->form_validation->set_rules('sisa', 'Akun Aktiva', 'strip_tags|required');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                // harus kode perkiraan yang berbeda
                    $params = array(
                        'panti_id' => $this->input->post('panti_id', TRUE),
                        'aktiva_id' => $this->input->post('aktiva_id', TRUE),
                        'nama_aktiva_transaksi' => $this->input->post('nama_aktiva_transaksi', TRUE),
                        'akumulasi_penyusutan_id' => $this->input->post('akumulasi_penyusutan_id', TRUE),
                        'biaya_penyusutan_id' => $this->input->post('biaya_penyusutan_id', TRUE),
                        'masa' => $this->input->post('masa', TRUE),
                        'tanggal_perolehan' => $this->input->post('tanggal_perolehan', TRUE),
                        'aktiva_habis' => $this->input->post('aktiva_habis', TRUE),
                        'harga_perolehan' => input_uang($this->input->post('harga_perolehan', TRUE)),
                        'sisa' => $this->input->post('sisa', TRUE)
                    );
                    $where = array(
                        'aktiva_transaksi_id' => $this->input->post('aktiva_transaksi_id', TRUE)
                    );
                    // selection jika lolos
                    if($this->m_aktiva_transaksi->update_aktiva_transaksi($params, $where)){
                        $notifikasi['notification_header'] = 'success';
                        $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                        $this->session->set_userdata('notifikasi',$notifikasi);
                        redirect(base_url().'logged/transaksi/aktiva_transaksi');
                    }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }     
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Aktiva Transaksi';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'logged/transaksi/aktiva_transaksi/view_aktiva_transaksi_edit';
        $this->display($data);
    }

    public function aktiva_transaksi_edit_process($id = null){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // list panti
        $data['rs_panti'] = $this->m_aktiva_transaksi->get_list_panti();
        // detail panti
        $data['det_panti'] = $this->m_aktiva_transaksi->get_detail_panti(array($this->session_detail['panti_id']));
        $param_id = de($id);
        $result = $this->m_aktiva_transaksi->get_aktiva_transaksi_by_id(array($param_id));
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/transaksi/aktiva_transaksi');
        }
        // notifikasi selection
        $this->form_validation->set_rules('aktiva_transaksi_id', 'Donatur', 'strip_tags|required');
        $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
        $this->form_validation->set_rules('nama_aktiva_transaksi', 'Nama Donatur', 'strip_tags|required|max_length[100]');
        $this->form_validation->set_rules('alamat', 'Alamat', 'strip_tags|required');
        $this->form_validation->set_rules('telepon', 'Telepon', 'strip_tags|required|max_length[20]');
        $this->form_validation->set_rules('keterangan', 'Keterangan', 'strip_tags|required');
        // selectiion
        if ($this->form_validation->run() !== FALSE){
            $aktiva_transaksi_id = de($this->input->post('aktiva_transaksi_id', TRUE));
            $params = array(
                'panti_id' => $this->input->post('panti_id', TRUE),
                'nama_aktiva_transaksi' => $this->input->post('nama_aktiva_transaksi', TRUE),
                'alamat' => $this->input->post('alamat', TRUE),
                'telepon' => $this->input->post('telepon', TRUE),
                'keterangan' => $this->input->post('keterangan', TRUE)
            );
            $where = array(
                'aktiva_transaksi_id' => $this->input->post('aktiva_transaksi_id', TRUE)
            );
            // selection jika lolos
            if($this->m_aktiva_transaksi->update_aktiva_transaksi($params, $where)){
                $notifikasi['notification_header'] = 'success';
                $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                $this->session->set_userdata('notifikasi',$notifikasi);
                redirect(base_url().'logged/transaksi/aktiva_transaksi');
            }
        }else{
            // validasi error
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_error'] = validation_errors();
            $this->session->set_userdata('notifikasi',$notifikasi);
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Donatur';
        $data['result'] = $this->input->post();
        $data['data'] = $result;
        $data['template'] = 'logged/transaksi/aktiva_transaksi/view_aktiva_transaksi_edit';
        $this->display($data);
    }

    public function ajax_aktiva_transaksi_delete($id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/transaksi/aktiva_transaksi/aktiva_transaksi_delete_process/' . $id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function aktiva_transaksi_delete_process($id){
        // declare params
        $where = array(
            'aktiva_transaksi_id' => de($id)
        );
        if ($this->m_aktiva_transaksi->delete_aktiva_transaksi($where)){
            $notifikasi['notification_header'] = 'success';
            $notifikasi['notification_message'] = 'Data Berhasil Dihapus';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/transaksi/aktiva_transaksi');           
        }
    }
}