<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Tanah extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/m_tanah');
        // load library
        $this->load->library('pagination');
    }

    function load_js(){
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/select2/select2.js");
        return $data['load_js'];
    }

    function load_css(){
        $this->load_style("resource/themes/js/plugins/select2/select2.css");
        return $data['load_css'];
    }

    public function index(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // search
        $search = $this->session->userdata('search_tanah');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        $data['panti'] = $this->m_tanah->get_detail_panti_by_id(array($session['panti_id']));
        // get nama panti dari detail
        $searched_panti = (empty($search['searched_panti']))? '%%' : $search['searched_panti'] ;
        $searched_nomor_sertifikat = (empty($search['searched_nomor_sertifikat']))? '%%' : '%' . $search['searched_nomor_sertifikat'] . '%' ;
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/tanah/index/';
        $config['total_rows'] = $this->m_tanah->get_total_tanah(array($searched_panti, $searched_nomor_sertifikat));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_tanah'] = $this->m_tanah->get_list_tanah(array($searched_panti, $searched_nomor_sertifikat, ($start - 1), $config['per_page']));
        $data['rs_panti'] = $this->m_tanah->get_list_panti();
        // tampilkan notifikasi
        $data['title'] = 'Tanah';
        $data['template'] = 'tanah/view_tanah';
        $this->display($data);
    }

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "searched_panti" => $this->input->post('searched_panti', TRUE),
                "searched_nomor_sertifikat" => $this->input->post('searched_nomor_sertifikat', TRUE)
            );
            // set session
            $this->session->set_userdata("search_tanah", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_tanah");
        }
        // redirect
        redirect(base_url() . "logged/tanah");
    }

    public function tanah_add(){
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // source
        $data['rs_jenis_sertifikat'] = $this->m_tanah->get_jenis_sertifikat();
        $data['rs_tanah_status'] = $this->m_tanah->get_tanah_status();
        $data['rs_panti'] = $this->m_tanah->get_list_panti();
        $data['rs_tanah_perolehan'] = $this->m_tanah->get_tanah_perolehan();
        $data['rs_kategori'] = $this->m_tanah->get_tanah_kategori();
        // validasi
        if ($this->input->post()) {
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('nomor_sertifikat', 'Nomor Sertifikat', 'strip_tags|required|max_length[50]|callback_check_nomor_tanah');
            $this->form_validation->set_rules('is_fasum', 'Fasilitas Umum', 'strip_tags|max_length[2]');
            $this->form_validation->set_rules('is_muhammadiyah', 'Aset Muhammadiyah', 'strip_tags|max_length[2]');
            $this->form_validation->set_rules('is_produktif', 'Aset Produktif', 'strip_tags|max_length[2]');
            $this->form_validation->set_rules('is_sengketa', 'Aset Sengketa', 'strip_tags|max_length[2]');
            $this->form_validation->set_rules('nib', 'NIB', 'strip_tags');
            $this->form_validation->set_rules('jenis_sertifikat_id', 'Jenis Sertifikat', 'strip_tags|max_length[2]');
            $this->form_validation->set_rules('status_tanah_id', 'Status Tanah', 'strip_tags|max_length[2]');
            $this->form_validation->set_rules('alamat', 'Alamat', 'strip_tags');
            $this->form_validation->set_rules('luas', 'Luas', 'strip_tags|numeric');
            $this->form_validation->set_rules('tanah_perolehan_id', 'Perolehan', 'strip_tags');
            $this->form_validation->set_rules('tanggal_tempo', 'Tanggal Tempo', 'strip_tags');
            $this->form_validation->set_rules('harga_beli', 'Harga Beli', 'strip_tags|numeric');
            $this->form_validation->set_rules('taksir_harga', 'Taksir Harga', 'strip_tags|numeric');
            $this->form_validation->set_rules('taksir_tahun', 'Taksir Tahun', 'strip_tags|max_length[4]');
            $this->form_validation->set_rules('taksir_njop_harga', 'Taksir NJOP Harga', 'strip_tags|numeric');
            $this->form_validation->set_rules('taksir_njop_tahun', 'Taksir NJOP Tahun', 'strip_tags|max_length[4]');
            $this->form_validation->set_rules('penggunaan', 'Penggunaan', 'strip_tags');
            $this->form_validation->set_rules('kategori_id', 'Kategori', 'strip_tags|max_length[2]');
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'panti_id' => ($this->input->post('panti_id', TRUE) != null)?$this->input->post('panti_id', TRUE):null,
                    'nomor_sertifikat' => ($this->input->post('nomor_sertifikat', TRUE) != null)?$this->input->post('nomor_sertifikat', TRUE):null,
                    'is_fasum' => ($this->input->post('is_fasum', TRUE) != null)?$this->input->post('is_fasum', TRUE):null,
                    'is_muhammadiyah' => ($this->input->post('is_muhammadiyah', TRUE) != null)?$this->input->post('is_muhammadiyah', TRUE):null,
                    'is_produktif' => ($this->input->post('is_produktif', TRUE) != null)?$this->input->post('is_produktif', TRUE):null,
                    'is_sengketa' => ($this->input->post('is_sengketa', TRUE) != null)?$this->input->post('is_sengketa', TRUE):null,
                    'nib' => $this->input->post('nib', TRUE),
                    'jenis_sertifikat_id' => ($this->input->post('jenis_sertifikat_id', TRUE) != null)?$this->input->post('jenis_sertifikat_id', TRUE):null,
                    'status_tanah_id' => ($this->input->post('status_tanah_id', TRUE) != null)?$this->input->post('status_tanah_id', TRUE):null,
                    'alamat' => ($this->input->post('alamat', TRUE) != null)?$this->input->post('alamat', TRUE):null,
                    'luas' => ($this->input->post('luas', TRUE) != null)?$this->input->post('luas', TRUE):null,
                    'perolehan_id' => ($this->input->post('tanah_perolehan_id', TRUE) != null)?$this->input->post('tanah_perolehan_id', TRUE):null,
                    'tanggal_tempo' => ($this->input->post('tanggal_tempo', TRUE) != null)?$this->input->post('tanggal_tempo', TRUE):null,
                    'beli_harga' => ($this->input->post('harga_beli', TRUE) != null)?$this->input->post('harga_beli', TRUE):null,
                    'taksir_harga' => ($this->input->post('taksir_harga', TRUE) != null)?$this->input->post('taksir_harga', TRUE):null,
                    'taksir_tahun' => ($this->input->post('taksir_tahun', TRUE) != null)?$this->input->post('taksir_tahun', TRUE):null,
                    'taksir_njop_harga' => ($this->input->post('taksir_njop_harga', TRUE) != null)?$this->input->post('taksir_njop_harga', TRUE):null,
                    'taksir_njop_tahun' => ($this->input->post('taksir_njop_tahun', TRUE) != null)?$this->input->post('taksir_njop_tahun', TRUE):null,
                    'penggunaan' => ($this->input->post('penggunaan', TRUE) != null)?$this->input->post('penggunaan', TRUE):null,
                    'kategori_id' => $this->input->post('kategori_id', TRUE)?$this->input->post('kategori_id', TRUE):null
                );
                // selection jika lolos
                if($this->m_tanah->insert_tanah($params)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/tanah');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Tanah';
        $data['result'] = $this->input->post();
        $data['template'] = 'tanah/view_tanah_add';
        $this->display($data);
    }

    public function tanah_edit($params_id = ''){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // source
        $data['rs_jenis_sertifikat'] = $this->m_tanah->get_jenis_sertifikat();
        $data['rs_tanah_status'] = $this->m_tanah->get_tanah_status();
        $data['rs_panti'] = $this->m_tanah->get_list_panti();
        $data['rs_tanah_perolehan'] = $this->m_tanah->get_tanah_perolehan();
        $data['rs_kategori'] = $this->m_tanah->get_tanah_kategori();
        // LOAD DATA
        $data['params_id'] = de($params_id);
        $result = ($this->input->post())?$this->input->post():$this->m_tanah->get_tanah_by_id(array($data['params_id']));
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/tanah');
        }
        if ($this->input->post()) {
            // notifikasi selection
            $this->form_validation->set_rules('tanah_id', 'ID', 'trim|required|max_length[100]');
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('nomor_sertifikat', 'Nomor Sertifikat', 'strip_tags|required|max_length[50]|callback_check_nomor_tanah');
            $this->form_validation->set_rules('is_fasum', 'Fasilitas Umum', 'strip_tags|max_length[2]');
            $this->form_validation->set_rules('is_muhammadiyah', 'Aset Muhammadiyah', 'strip_tags|max_length[2]');
            $this->form_validation->set_rules('is_produktif', 'Aset Produktif', 'strip_tags|max_length[2]');
            $this->form_validation->set_rules('is_sengketa', 'Aset Sengketa', 'strip_tags|max_length[2]');
            $this->form_validation->set_rules('nib', 'NIB', 'strip_tags');
            $this->form_validation->set_rules('jenis_sertifikat_id', 'Jenis Sertifikat', 'strip_tags|max_length[2]');
            $this->form_validation->set_rules('status_tanah_id', 'Status Tanah', 'strip_tags|max_length[2]');
            $this->form_validation->set_rules('alamat', 'Alamat', 'strip_tags');
            $this->form_validation->set_rules('luas', 'Luas', 'strip_tags|numeric');
            $this->form_validation->set_rules('tanah_perolehan_id', 'Perolehan', 'strip_tags');
            $this->form_validation->set_rules('tanggal_tempo', 'Tanggal Tempo', 'strip_tags');
            $this->form_validation->set_rules('harga_beli', 'Harga Beli', 'strip_tags|numeric');
            $this->form_validation->set_rules('taksir_harga', 'Taksir Harga', 'strip_tags|numeric');
            $this->form_validation->set_rules('taksir_tahun', 'Taksir Tahun', 'strip_tags|max_length[4]');
            $this->form_validation->set_rules('taksir_njop_harga', 'Taksir NJOP Harga', 'strip_tags|numeric');
            $this->form_validation->set_rules('taksir_njop_tahun', 'Taksir NJOP Tahun', 'strip_tags|max_length[4]');
            $this->form_validation->set_rules('penggunaan', 'Penggunaan', 'strip_tags');
            $this->form_validation->set_rules('kategori_id', 'Kategori', 'strip_tags|max_length[2]');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $tanah_id = de($this->input->post('tanah_id', TRUE));
                $params = array(
                    'panti_id' => ($this->input->post('panti_id', TRUE) != null)?$this->input->post('panti_id', TRUE):null,
                    'nomor_sertifikat' => ($this->input->post('nomor_sertifikat', TRUE) != null)?$this->input->post('nomor_sertifikat', TRUE):null,
                    'is_fasum' => ($this->input->post('is_fasum', TRUE) != null)?$this->input->post('is_fasum', TRUE):null,
                    'is_muhammadiyah' => ($this->input->post('is_muhammadiyah', TRUE) != null)?$this->input->post('is_muhammadiyah', TRUE):null,
                    'is_produktif' => ($this->input->post('is_produktif', TRUE) != null)?$this->input->post('is_produktif', TRUE):null,
                    'is_sengketa' => ($this->input->post('is_sengketa', TRUE) != null)?$this->input->post('is_sengketa', TRUE):null,
                    'nib' => $this->input->post('nib', TRUE),
                    'jenis_sertifikat_id' => ($this->input->post('jenis_sertifikat_id', TRUE) != null)?$this->input->post('jenis_sertifikat_id', TRUE):null,
                    'status_tanah_id' => ($this->input->post('status_tanah_id', TRUE) != null)?$this->input->post('status_tanah_id', TRUE):null,
                    'alamat' => ($this->input->post('alamat', TRUE) != null)?$this->input->post('alamat', TRUE):null,
                    'luas' => ($this->input->post('luas', TRUE) != null)?$this->input->post('luas', TRUE):null,
                    'perolehan_id' => ($this->input->post('tanah_perolehan_id', TRUE) != null)?$this->input->post('tanah_perolehan_id', TRUE):null,
                    'tanggal_tempo' => ($this->input->post('tanggal_tempo', TRUE) != null)?$this->input->post('tanggal_tempo', TRUE):null,
                    'beli_harga' => ($this->input->post('harga_beli', TRUE) != null)?$this->input->post('harga_beli', TRUE):null,
                    'taksir_harga' => ($this->input->post('taksir_harga', TRUE) != null)?$this->input->post('taksir_harga', TRUE):null,
                    'taksir_tahun' => ($this->input->post('taksir_tahun', TRUE) != null)?$this->input->post('taksir_tahun', TRUE):null,
                    'taksir_njop_harga' => ($this->input->post('taksir_njop_harga', TRUE) != null)?$this->input->post('taksir_njop_harga', TRUE):null,
                    'taksir_njop_tahun' => ($this->input->post('taksir_njop_tahun', TRUE) != null)?$this->input->post('taksir_njop_tahun', TRUE):null,
                    'penggunaan' => ($this->input->post('penggunaan', TRUE) != null)?$this->input->post('penggunaan', TRUE):null,
                    'kategori_id' => $this->input->post('kategori_id', TRUE)?$this->input->post('kategori_id', TRUE):null
                );
                $where = array(
                    'tanah_id' => $tanah_id
                );
                // selection jika lolos
                if($this->m_tanah->update_tanah($params, $where)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/tanah');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Tanah';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'tanah/view_tanah_edit';
        $this->display($data);
    }

    public function ajax_tanah_delete($id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/tanah/tanah_delete_process/' . $id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function tanah_delete_process($id){
        // declare params
        $where = array(
            'tanah_id' => de($id)
        );
        if ($this->m_tanah->delete_tanah($where)){
            $this->lnotifikasi->kirim_notification('success', 'Data berhasil dihapus');
            redirect(base_url().'logged/tanah');           
        }
    }

    //-- check
    public function check_nomor_tanah(){$nomor_tanah = $this->input->post('nomor_sertifikat', TRUE);
        $data = $this->m_tanah->get_existing_nomor_tanah(array($nomor_tanah));
        if (($data)){
            $this->form_validation->set_message('check_nomor_tanah', 'Sertifikat telah tersedia!');
            return FALSE;
        }else{
            return TRUE;
        }
    }

    public function check_nomor_tanah_edit(){
        $tanah_id = $this->input->post('tanah_id', TRUE);
        $nomor_tanah = $this->input->post('nomor_tanah', TRUE);
        $data = $this->m_tanah->get_existing_nomor_tanah(array($nomor_tanah));
        $nomor = $this->m_tanah->get_tanah_by_id(array(de($tanah_id)));
         if (($data) AND ($data['nomor_tanah'] != $nomor['nomor_tanah'])){
            $this->form_validation->set_message('check_nomor_tanah_edit', 'Data Tanah telah tersedia!');
            return FALSE;
        }else{
            return TRUE;
        }
    }
}