<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Ruang extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/m_ruang');
        // load library
        $this->load->library('pagination');
    }

    function load_js(){
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/select2/select2.js");
        return $data['load_js'];
    }

    function load_css(){
        $this->load_style("resource/themes/js/plugins/select2/select2.css");
        return $data['load_css'];
    }

    public function index(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // search
        $search = $this->session->userdata('search_ruang');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        $data['panti'] = $this->m_ruang->get_detail_panti_by_id(array($session['panti_id']));
        // get nama panti dari detail
        $searched_panti = (empty($search['searched_panti']))? '%%' : $search['searched_panti'] ;
        $searched_nama_ruang = (empty($search['searched_nama_ruang']))? '%%' : '%' . $search['searched_nama_ruang'] . '%' ;
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/ruang/index/';
        $config['total_rows'] = $this->m_ruang->get_total_ruang(array($searched_panti, $searched_nama_ruang));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_ruang'] = $this->m_ruang->get_list_ruang(array($searched_panti, $searched_nama_ruang, ($start - 1), $config['per_page']));
        $data['rs_panti'] = $this->m_ruang->get_list_panti();
        // tampilkan notifikasi
        $data['title'] = 'Ruang';
        $data['template'] = 'ruang/view_ruang';
        $this->display($data);
    }

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "searched_panti" => $this->input->post('searched_panti', TRUE),
                "searched_nama_ruang" => $this->input->post('searched_nama_ruang', TRUE)
            );
            // set session
            $this->session->set_userdata("search_ruang", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_ruang");
        }
        // redirect
        redirect(base_url() . "logged/ruang");
    }

    public function ruang_add(){
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // source
        $data['rs_panti'] = $this->m_ruang->get_list_panti();
        // validasi
        if ($this->input->post()) {
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('bangunan_id', 'Bangunan', 'strip_tags|required');
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'panti_id' => ($this->input->post('panti_id', TRUE) != null)?$this->input->post('panti_id', TRUE):null,
                    'bangunan_id' => ($this->input->post('bangunan_id', TRUE) != null)?$this->input->post('bangunan_id', TRUE):null,
                    'kode' => ($this->input->post('kode', TRUE) != null)?$this->input->post('kode', TRUE):null,
                    'nama' => ($this->input->post('nama', TRUE) != null)?$this->input->post('nama', TRUE):null,
                    'keterangan' => ($this->input->post('keterangan', TRUE) != null)?$this->input->post('keterangan', TRUE):null
                );
                // selection jika lolos
                if($this->m_ruang->insert_ruang($params)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/ruang');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Ruang';
        $data['result'] = $this->input->post();
        $data['template'] = 'ruang/view_ruang_add';
        $this->display($data);
    }

    public function ruang_edit($params_id = ''){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // source
        // $data['rs_jenis_sertifikat'] = $this->m_ruang->get_jenis_sertifikat();
        // $data['rs_ruang_status'] = $this->m_ruang->get_ruang_status();
        $data['rs_panti'] = $this->m_ruang->get_list_panti();
        // $data['rs_ruang_perolehan'] = $this->m_ruang->get_ruang_perolehan();
        // $data['rs_kategori'] = $this->m_ruang->get_ruang_kategori();
        // LOAD DATA
        $data['params_id'] = de($params_id);
        $result = ($this->input->post())?$this->input->post():$this->m_ruang->get_ruang_by_id(array($data['params_id']));
        $data['rs_bangunan'] = $this->m_ruang->get_list_bangunan_by_panti($result['panti_id']);
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/ruang');
        }
        if ($this->input->post()) {
            // notifikasi selection
            $this->form_validation->set_rules('ruang_id', 'ID', 'trim|required|max_length[100]');
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('bangunan_id', 'Bangunan', 'strip_tags|required');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $ruang_id = de($this->input->post('ruang_id', TRUE));
                $params = array(
                    'panti_id' => ($this->input->post('panti_id', TRUE) != null)?$this->input->post('panti_id', TRUE):null,
                    'bangunan_id' => ($this->input->post('bangunan_id', TRUE) != null)?$this->input->post('bangunan_id', TRUE):null,
                    'kode' => ($this->input->post('kode', TRUE) != null)?$this->input->post('kode', TRUE):null,
                    'nama' => ($this->input->post('nama', TRUE) != null)?$this->input->post('nama', TRUE):null,
                    'keterangan' => ($this->input->post('keterangan', TRUE) != null)?$this->input->post('keterangan', TRUE):null
                );
                $where = array(
                    'ruang_id' => $ruang_id
                );
                // selection jika lolos
                if($this->m_ruang->update_ruang($params, $where)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/ruang');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Ruang';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'ruang/view_ruang_edit';
        $this->display($data);
    }

    public function ajax_ruang_delete($id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/ruang/ruang_delete_process/' . $id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function ruang_delete_process($id){
        // declare params
        $where = array(
            'ruang_id' => de($id)
        );
        if ($this->m_ruang->delete_ruang($where)){
            $this->lnotifikasi->kirim_notification('success', 'Data berhasil dihapus');
            redirect(base_url().'logged/ruang');           
        }
    }

    public function get_bangunan_by_panti($panti_id){
        $rs_bangunan = $this->m_ruang->get_list_bangunan_by_panti($panti_id);

        $html ='';
        $html .='<option value="">-- PILIH --</option>';
        foreach ($rs_bangunan as $key => $value) {
          $html .='<option value="'.$value['bangunan_id'].'">'.$value['bangunan_id'].' - '.$value['nama'].'</option>';
        }

        echo $html;
    }
}