<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Pengasuh extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/m_pengasuh');
        // load library
        $this->load->library('pagination');
    }

	public function index(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // search
        $search = $this->session->userdata('search_pengasuh');
        $data['search'] = $search;
        // search khusus hak akses panti
        $session = $this->get_user_detail();
        $data['panti'] = $this->m_pengasuh->get_detail_panti_by_id(array($session['panti_id']));
        $nama_pengasuh = (empty($search['nama_pengasuh']))? '%' : '%' . $search['nama_pengasuh'] . '%' ;
        if (($session['hak_akses'] == 1) OR ($session['hak_akses'] == 2)){
            $panti_id = (empty($search['panti_id']))? '%' : $search['panti_id'];
        }else{
            $panti_id = $session['panti_id'];
        }
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/pengasuh/index/';
        $config['total_rows'] = $this->m_pengasuh->get_total_pengasuh(array($nama_pengasuh, $panti_id));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_pengasuh'] = $this->m_pengasuh->get_all_pengasuh(array($nama_pengasuh, $panti_id, ($start - 1), $config['per_page']));
        // list all kabupaten
        $data['rs_panti'] = $this->m_pengasuh->get_list_panti();
        // tampilkan notifikasi
        $data['title'] = 'Pengasuh';
        $data['template'] = 'pengasuh/view_pengasuh';
		$this->display($data);
	}

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "nama_pengasuh" => $this->input->post('nama_pengasuh', TRUE),
                "panti_id" => $this->input->post('panti_id', TRUE)
            );
            // set session
            $this->session->set_userdata("search_pengasuh", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_pengasuh");
        }
        // redirect
        redirect(base_url() . "logged/pengasuh");
    }

    public function pengasuh_add(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // status kepegawaian
        $data['rs_status_kepegawaian'] = $this->m_pengasuh->get_list_status_kepegawaian();
        // validasi
        if ($this->input->post()) {
            // notifikasi selection
            $this->form_validation->set_rules('nik', 'NIK', 'strip_tags|required|max_length[20]');
            $this->form_validation->set_rules('nama_pengasuh', 'Nama Pengasuh', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('jenis_kelamin', 'Jenis Kelamin', 'strip_tags|required');
            $this->form_validation->set_rules('tempat_lahir', 'Tempat Lahir', 'strip_tags|required');
            $this->form_validation->set_rules('tanggal_lahir', 'Tanggal Lahir', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('mulai_bekerja_di_panti', 'Tahun Mulai Bekerja Di Panti', 'strip_tags|required|max_length[4]');
            $this->form_validation->set_rules('jabatan', 'Jabatan', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('status_kepegawaian_id', 'Status Kepegawaian', 'strip_tags|required');
            $this->form_validation->set_rules('jenjang_pendidikan', 'Jenjang Pendidikan', 'strip_tags|required');
            $this->form_validation->set_rules('sekolah_universitas', 'Sekolah/Universitas', 'strip_tags|required|max_length[70]');
            $this->form_validation->set_rules('alamat_pengasuh', 'Alamat Pengasuh', 'strip_tags|required');
            $this->form_validation->set_rules('email_pengasuh', 'E-mail Pengasuh', 'strip_tags|valid_email');
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('no_telepon_pengasuh', 'Nomor Telepon Pengasuh', 'strip_tags|required|max_length[20]');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'nama_pengasuh' => $this->input->post('nama_pengasuh', TRUE),
                    'jenis_kelamin' => $this->input->post('jenis_kelamin', TRUE),
                    'tempat_lahir' => $this->input->post('tempat_lahir', TRUE),
                    'tanggal_lahir' => $this->input->post('tanggal_lahir', TRUE),
                    'jenjang_pendidikan' => $this->input->post('jenjang_pendidikan', TRUE),
                    'sekolah_universitas' => $this->input->post('sekolah_universitas', TRUE),
                    'alamat_pengasuh' => $this->input->post('alamat_pengasuh', TRUE),
                    'panti_id' => $this->input->post('panti_id', TRUE),
                    'email_pengasuh' => $this->input->post('email_pengasuh', TRUE),
                    'no_telepon_pengasuh' => $this->input->post('no_telepon_pengasuh', TRUE),
                    'nik' => $this->input->post('nik', TRUE),
                    'mulai_bekerja_di_panti' => $this->input->post('mulai_bekerja_di_panti', TRUE),
                    'jabatan' => $this->input->post('jabatan', TRUE),
                    'status_kepegawaian_id' => $this->input->post('status_kepegawaian_id', TRUE)
                );
                // selection jika lolos
                if($this->m_pengasuh->insert_pengasuh($params)){
                    $panti_id = (empty($session['panti_id']))? $this->input->post('panti_id', TRUE) :$session['panti_id'];
                    // update tabel panti
                    $params2 = array(
                        'aktivitas_terakhir' => 'Menambah data pengasuh',
                        'waktu_eksekusi' => date("Y-m-d H:i:s"),
                        'edited_by' => $this->session_detail['username']
                    );
                    $where2 = array(
                        'panti_id' => $panti_id
                    );
                    $this->m_pengasuh->update_modifikasi($params2, $where2);
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasi Disimpan'; 
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/pengasuh');
                }
            }else{
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // LOAD DATA
        $data['rs_panti'] = $this->m_pengasuh->get_list_panti();
        $session = $this->get_user_detail();
        $data['panti'] = $this->m_pengasuh->get_detail_panti_by_id(array($session['panti_id']));
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Pengasuh';
        $data['result'] = @$this->input->post();
        $data['template'] = 'pengasuh/view_pengasuh_add';
        $this->display($data);
    }

    public function pengasuh_edit($params_id = ''){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // LOAD DATA
        $result = ($this->input->post())?$this->input->post():$this->m_pengasuh->get_pengasuh_by_id(array(de($params_id)));
        $session = $this->get_user_detail();
        $data['panti'] = $this->m_pengasuh->get_detail_panti_by_id(array($session['panti_id']));
        $data['rs_panti'] = $this->m_pengasuh->get_list_panti();
        $data['params_id'] = de($params_id);
        // status kepegawaian
        $data['rs_status_kepegawaian'] = $this->m_pengasuh->get_list_status_kepegawaian();
        // validasi 
        if ($this->input->post()) {
                    // notifikasi selection
            $this->form_validation->set_rules('pengasuh_id', 'Pengasuh ID', 'strip_tags|required');
            $this->form_validation->set_rules('nik', 'NIK', 'strip_tags|required|max_length[20]');
            $this->form_validation->set_rules('nama_pengasuh', 'Nama Pengasuh', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('jenis_kelamin', 'Jenis Kelamin', 'strip_tags|required');
            $this->form_validation->set_rules('tempat_lahir', 'Tempat Lahir', 'strip_tags|required');
            $this->form_validation->set_rules('tanggal_lahir', 'Tanggal Lahir', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('mulai_bekerja_di_panti', 'Tahun Mulai Bekerja Di Panti', 'strip_tags|required|max_length[4]');
            $this->form_validation->set_rules('jabatan', 'Jabatan', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('status_kepegawaian_id', 'Status Kepegawaian', 'strip_tags|required');
            $this->form_validation->set_rules('jenjang_pendidikan', 'Jenjang Pendidikan', 'strip_tags|required');
            $this->form_validation->set_rules('sekolah_universitas', 'Sekolah/Universitas', 'strip_tags|required|max_length[70]');
            $this->form_validation->set_rules('alamat_pengasuh', 'Alamat Pengasuh', 'strip_tags|required');
            $this->form_validation->set_rules('email_pengasuh', 'E-mail Pengasuh', 'strip_tags|valid_email');
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('no_telepon_pengasuh', 'Nomor Telepon Pengasuh', 'strip_tags|required|max_length[20]');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'nama_pengasuh' => $this->input->post('nama_pengasuh', TRUE),
                    'jenis_kelamin' => $this->input->post('jenis_kelamin', TRUE),
                    'tempat_lahir' => $this->input->post('tempat_lahir', TRUE),
                    'tanggal_lahir' => $this->input->post('tanggal_lahir', TRUE),
                    'jenjang_pendidikan' => $this->input->post('jenjang_pendidikan', TRUE),
                    'sekolah_universitas' => $this->input->post('sekolah_universitas', TRUE),
                    'alamat_pengasuh' => $this->input->post('alamat_pengasuh', TRUE),
                    'panti_id' => $this->input->post('panti_id', TRUE),
                    'email_pengasuh' => $this->input->post('email_pengasuh', TRUE),
                    'no_telepon_pengasuh' => $this->input->post('no_telepon_pengasuh', TRUE),
                    'nik' => $this->input->post('nik', TRUE),
                    'mulai_bekerja_di_panti' => $this->input->post('mulai_bekerja_di_panti', TRUE),
                    'jabatan' => $this->input->post('jabatan', TRUE),
                    'status_kepegawaian_id' => $this->input->post('status_kepegawaian_id', TRUE)
                );
                $where = array(
                    'pengasuh_id' => de($this->input->post('pengasuh_id', TRUE))
                );
                // selection jika lolos
                if($this->m_pengasuh->update_pengasuh($params, $where)){
                    $panti_id = (empty($session['panti_id']))? $this->input->post('panti_id', TRUE) :$session['panti_id'];
                    // update tabel panti
                    $params2 = array(
                        'aktivitas_terakhir' => 'Mengubah data pengasuh',
                        'waktu_eksekusi' => date("Y-m-d H:i:s"),
                        'edited_by' => $this->session_detail['username']
                    );
                    $where2 = array(
                        'panti_id' => $panti_id
                    );
                    $this->m_pengasuh->update_modifikasi($params2, $where2);
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasi Disimpan'; 
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/pengasuh');
                }
            }else{
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Pengasuh';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'pengasuh/view_pengasuh_edit';
        $this->display($data);
    }

    public function ajax_pengasuh_delete($pengasuh_id = '', $panti_id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/pengasuh/pengasuh_delete_process/' . $pengasuh_id . '/'.$panti_id.'" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function pengasuh_delete_process($pengasuh_id = '', $panti_id = ''){
        // declare params
        $where = array(
            'pengasuh_id' => $pengasuh_id
        );
        if ($this->m_pengasuh->delete_pengasuh($where)){
            $panti_id = (empty($session['panti_id']))? $panti_id :$session['panti_id'];
            // update tabel panti
            $params2 = array(
                'aktivitas_terakhir' => 'Menghapus data pengasuh',
                'waktu_eksekusi' => date("Y-m-d H:i:s"),
                'edited_by' => $this->session_detail['username']
            );
            $where2 = array(
                'panti_id' => $panti_id
            );
            $this->m_pengasuh->update_modifikasi($params2, $where2);
            $notifikasi['notification_header'] = 'success';
            $notifikasi['notification_message'] = 'Data Berhasil Dihapus';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/pengasuh');           
        }
    }

// PELATIHAN
    public function pelatihan($id){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // pagination
        $pengasuh_id = de($id);
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/pengasuh/index/' . $id;
        $config['total_rows'] = $this->m_pengasuh->get_total_pelatihan_pengasuh(array($pengasuh_id));
        $config['uri_segment'] = 5;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(5, 0) + 1;
        $end = $this->uri->segment(5, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data
        $data['data'] = $this->m_pengasuh->get_pengasuh_by_id(array($pengasuh_id));
        // data list panti
        $data['rs_pengasuh'] = $this->m_pengasuh->get_all_pelatihan_pengasuh(array($pengasuh_id, ($start - 1), $config['per_page']));
        // tampilkan notifikasi
        $data['title'] = 'Pelatihan Pengasuh';
        $data['notifikasi'] = $this->lnotifikasi->tampilkan_notifikasi();
        $data['template'] = 'pengasuh/view_pelatihan_pengasuh';
        $this->display($data);
    }

    // add pelatihan pengasuh
    public function pelatihan_pengasuh_add($id){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // validasi
        if ($this->input->post()) {
            // notifikasi selection
            $this->form_validation->set_rules('pengasuh_id', 'ID Pengasuh', 'strip_tags|required|max_length[100]');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                foreach($this->input->post('deskripsi_pelatihan', TRUE) as $result){
                    if ($result <> NULL){
                        $params = array(
                            'pengasuh_id' => de($this->input->post('pengasuh_id', TRUE)),
                            'deskripsi_pelatihan' => $result
                        );
                        $this->m_pengasuh->insert_pelatihan_pengasuh($params);
                    }
                }
                // selection jika lolos
                $notifikasi['notification_header'] = 'success';
                $notifikasi['notification_message'] = 'Data Berhasi Disimpan'; 
                $this->session->set_userdata('notifikasi',$notifikasi);
                redirect(base_url().'logged/pengasuh/pelatihan/' . $this->input->post('pengasuh_id', TRUE));
            }else{
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors(); 
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // detail data
        $pengasuh_id = de($id);
        $data['data'] = $this->m_pengasuh->get_pengasuh_by_id(array($pengasuh_id));
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Pelatihan Pengasuh';
        $data['template'] = 'pengasuh/view_pelatihan_pengasuh_add';
        $this->display($data);
    }

    // edit data pelatihan pengasuh
    public function pelatihan_pengasuh_edit($pengasuh_id = '', $pelatihan_pengasuh_id = ''){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // validasi
        if ($this->input->post()) {
            $this->form_validation->set_rules('pengasuh_id', 'Pengasuh ID', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('pelatihan_pengasuh_id', 'Pelatihan Pengasuh ID', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('deskripsi_pelatihan', 'Deskripsi Pelatihan', 'strip_tags|required|max_length[100]');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $pelatihan_pengasuh_id = de($this->input->post('pelatihan_pengasuh_id', TRUE));
                $params = array(
                    'deskripsi_pelatihan' => $this->input->post('deskripsi_pelatihan', TRUE)
                );
                $where = array(
                    'pelatihan_pengasuh_id' => $pelatihan_pengasuh_id
                );
                // selection jika lolos
                if($this->m_pengasuh->update_pelatihan_pengasuh($params, $where)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasi Disimpan'; 
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/pengasuh/pelatihan/' . $this->input->post('pengasuh_id', TRUE));
                }
            }else{
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = validation_errors(); 
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // LOAD DATA
        $data['pengasuh_id'] = de($pengasuh_id);
        $data['pelatihan_pengasuh_id'] = de($pelatihan_pengasuh_id);
        $result = ($this->input->post())?$this->input->post():$this->m_pengasuh->get_pelatihan_pengasuh_by_id(array($data['pelatihan_pengasuh_id']));
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Pelatihan Pengasuhs';
        $data['result'] = $result;
        $data['data'] = $this->m_pengasuh->get_pelatihan_pengasuh_by_id(array($data['pelatihan_pengasuh_id']));
        $data['template'] = 'pengasuh/view_pelatihan_pengasuh_edit';
        $this->display($data);
    }

    // delete [engasuh]
    public function ajax_pelatihan_pengasuh_delete($pengasuh_id = '', $pelatihan_pengasuh_id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/pengasuh/pelatihan_pengasuh_delete_process/' . $pengasuh_id . '/' . $pelatihan_pengasuh_id .'" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function pelatihan_pengasuh_delete_process($pengasuh_id, $pelatihan_pengasuh_id){
        // declare params
        $where = array(
            'pelatihan_pengasuh_id' => de($pelatihan_pengasuh_id)
        );
        if ($this->m_pengasuh->delete_pelatihan_pengasuh($where)){
            $notifikasi['notification_header'] = 'success';
            $notifikasi['notification_message'] = 'Data Berhasi Dihapus'; 
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/pengasuh/pelatihan/' . $pengasuh_id);           
        }
    }
}