<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Panti extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        $this->sesi = $this->get_user_detail(); 
        // load library
        $this->load->model('logged/m_panti');
        // load library
        $this->load->library('pagination');
        $this->load->library('datemanipulation');
    }

	public function index(){
        // cek dulu siapa yang mengakses berdasarkan hak akses
        $session =$this->get_user_detail(); 
        if (($session['hak_akses'] == 3) OR ($session['hak_akses'] == 4)){
            redirect(base_url().'logged/panti/panti_edit');
        }
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // search
        $search = $this->session->userdata('search_panti');
        $data['search'] = $search;
        $nama_panti = (empty($search['nama_panti']))? '%' : '%' . $search['nama_panti'] . '%' ;
        $kabupaten_id = (empty($search['kabupaten_id']))? '%' : $search['kabupaten_id'];
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/panti/index/';
        $config['total_rows'] = $this->m_panti->get_total_panti(array($nama_panti, $kabupaten_id));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_panti'] = $this->m_panti->get_all_panti_limit(array($nama_panti, $kabupaten_id, ($start - 1), $config['per_page']));
        // list all kabupaten
        $data['rs_kab_kota'] = $this->m_panti->get_all_kabupaten();
        // tampilkan notifikasi
        $data['title'] = 'Panti';
        $data['template'] = 'logged/panti/view_panti';
		$this->display($data);
	}

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "nama_panti" => $this->input->post('nama_panti', TRUE),
                "kabupaten_id" => $this->input->post('kabupaten_id', TRUE)
            );
            // set session
            $this->session->set_userdata("search_panti", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_panti");
        }
        // redirect
        redirect(base_url() . "logged/panti");
    }

    public function panti_add(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // LOAD DATA
        $data['rs_kab_kota'] = $this->m_panti->get_all_kabupaten();
        // validasi
        if ($this->input->post()) {
            // notifikasi selection
            $this->form_validation->set_rules('nama_panti', 'Nama Panti', 'strip_tags|required|max_length[255]');
            $this->form_validation->set_rules('kabupaten_id', 'Kabupaten', 'trim');
            $this->form_validation->set_rules('desa_kelurahan', 'Desa/Kelurahan', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('kecamatan', 'Kecamatan', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('alamat_panti', 'Alamat Panti', 'strip_tags|required');
            $this->form_validation->set_rules('no_telepon_panti', 'No. Telp. Panti', 'strip_tags|max_length[255]');
            $this->form_validation->set_rules('akta_notaris', 'Akta Notaris', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('izin_operasional', 'Izin Operasional', 'strip_tags|max_length[40]');
            $this->form_validation->set_rules('npwp', 'NPWP', 'strip_tags|max_length[100]');
            $this->form_validation->set_rules('ad_art', 'AD/ART', 'strip_tags|max_length[100]');
            $this->form_validation->set_rules('nama_bank', 'Nama Bank', 'strip_tags|max_length[100]');
            $this->form_validation->set_rules('nomor_rekening', 'Nomor Rekening', 'strip_tags|max_length[100]');
            $this->form_validation->set_rules('atas_nama_dalam_rekening', 'Atas Nama Dalam Rekening', 'strip_tags|max_length[100]');
            $this->form_validation->set_rules('email_panti', 'E-mail Panti', 'strip_tags|valid_email');
            $this->form_validation->set_rules('facebook', 'Facebook', 'strip_tags|max_length[255]');
            $this->form_validation->set_rules('twitter', 'Twitter', 'strip_tags|max_length[255]');
            $this->form_validation->set_rules('website', 'Website', 'strip_tags|max_length[255]');
            $this->form_validation->set_rules('nama_admin', 'Nama Pimpinan Panti', 'strip_tags|required|max_length[255]');
            $this->form_validation->set_rules('alamat_admin', 'Alamat Pimpinan Panti', 'strip_tags|required');
            $this->form_validation->set_rules('kontak_person_admin', 'No. Telp. Pimpinan Panti', 'strip_tags|required|max_length[255]');
            $this->form_validation->set_rules('facebook_admin', 'Facebook Pimpinan Panti', 'strip_tags|max_length[255]');
            $this->form_validation->set_rules('twitter_admin', 'Twitter Pimpinan Panti', 'strip_tags|max_length[255]');
            $this->form_validation->set_rules('email_admin', 'E-mail Pimpinan Panti', 'strip_tags|valid_email');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'nama_panti' => $this->input->post('nama_panti', TRUE),
                    'kabupaten_id' => $this->input->post('kabupaten_id', TRUE),
                    'desa_kelurahan' => $this->input->post('desa_kelurahan', TRUE),
                    'kecamatan' => $this->input->post('kecamatan', TRUE),
                    'alamat_panti' => $this->input->post('alamat_panti', TRUE),
                    'no_telepon_panti' => $this->input->post('no_telepon_panti', TRUE),
                    'akta_notaris' => $this->input->post('akta_notaris', TRUE),
                    'izin_operasional' => $this->input->post('izin_operasional', TRUE),
                    'npwp' => $this->input->post('npwp', TRUE),
                    'ad_art' => $this->input->post('ad_art', TRUE),
                    'nama_bank' => $this->input->post('nama_bank', TRUE),
                    'nomor_rekening' => $this->input->post('nomor_rekening', TRUE),
                    'atas_nama_dalam_rekening' => $this->input->post('atas_nama_dalam_rekening', TRUE),
                    'email_panti' => $this->input->post('email_panti', TRUE),
                    'facebook' => $this->input->post('facebook', TRUE),
                    'twitter' => $this->input->post('twitter', TRUE),
                    'website' => $this->input->post('website', TRUE),
                    'nama_admin' => $this->input->post('nama_admin', TRUE),
                    'kontak_person_admin' => $this->input->post('kontak_person_admin', TRUE),
                    'alamat_panti' => $this->input->post('alamat_panti', TRUE),
                    'facebook_admin' => $this->input->post('facebook_admin', TRUE),
                    'email_admin' => $this->input->post('email_admin', TRUE),
                    'twitter_admin' => $this->input->post('twitter_admin', TRUE)
                );
                // selection jika lolos
                if($this->m_panti->insert_panti($params)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasi Disimpan'; 
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/panti');
                }
            }else{
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Panti';
        $data['result'] = @$this->input->post();
        $data['template'] = 'logged/panti/view_panti_add';
        $this->display($data);
    }

    public function panti_edit($params_id = ''){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // declare panti info
        $session =$this->get_user_detail();
        $data['dtm'] = $this->datemanipulation;
        $data['params_id'] = (empty($session['panti_id']))? de($params_id) :$session['panti_id'];
        // LOAD DATA
        $result = ($this->input->post())?$this->input->post():$this->m_panti->get_panti_by_id(array($data['params_id']));
        $data['rs_kab_kota'] = $this->m_panti->get_all_kabupaten();
        // calidasi
        if ($this->input->post()) {
            $this->form_validation->set_rules('panti_id', 'Panti ID', 'strip_tags|required');
            $this->form_validation->set_rules('nama_panti', 'Nama Panti', 'strip_tags|required|max_length[255]');
            $this->form_validation->set_rules('kabupaten_id', 'Kabupaten', 'trim');
            $this->form_validation->set_rules('desa_kelurahan', 'Desa/Kelurahan', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('kecamatan', 'Kecamatan', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('alamat_panti', 'Alamat Panti', 'strip_tags|required');
            $this->form_validation->set_rules('no_telepon_panti', 'No. Telp. Panti', 'strip_tags|max_length[255]');
            $this->form_validation->set_rules('akta_notaris', 'Akta Notaris', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('izin_operasional', 'Izin Operasional', 'strip_tags|max_length[40]');
            $this->form_validation->set_rules('npwp', 'NPWP', 'strip_tags|max_length[100]');
            $this->form_validation->set_rules('ad_art', 'AD/ART', 'strip_tags|max_length[100]');
            $this->form_validation->set_rules('nama_bank', 'Nama Bank', 'strip_tags|max_length[100]');
            $this->form_validation->set_rules('nomor_rekening', 'Nomor Rekening', 'strip_tags|max_length[100]');
            $this->form_validation->set_rules('atas_nama_dalam_rekening', 'Atas Nama Dalam Rekening', 'strip_tags|max_length[100]');
            $this->form_validation->set_rules('email_panti', 'E-mail Panti', 'strip_tags|valid_email');
            $this->form_validation->set_rules('facebook', 'Facebook', 'strip_tags|max_length[255]');
            $this->form_validation->set_rules('twitter', 'Twitter', 'strip_tags|max_length[255]');
            $this->form_validation->set_rules('website', 'Website', 'strip_tags|max_length[255]');
            $this->form_validation->set_rules('nama_admin', 'Nama Pimpinan Panti', 'strip_tags|required|max_length[255]');
            $this->form_validation->set_rules('alamat_admin', 'Alamat Pimpinan Panti', 'strip_tags|required');
            $this->form_validation->set_rules('kontak_person_admin', 'No. Telp. Pimpinan Panti', 'strip_tags|required|max_length[255]');
            $this->form_validation->set_rules('facebook_admin', 'Facebook Pimpinan Panti', 'strip_tags|max_length[255]');
            $this->form_validation->set_rules('twitter_admin', 'Twitter Pimpinan Panti', 'strip_tags|max_length[255]');
            $this->form_validation->set_rules('email_admin', 'E-mail Pimpinan Panti', 'strip_tags|valid_email');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'nama_panti' => $this->input->post('nama_panti', TRUE),
                    'kabupaten_id' => $this->input->post('kabupaten_id', TRUE),
                    'desa_kelurahan' => $this->input->post('desa_kelurahan', TRUE),
                    'kecamatan' => $this->input->post('kecamatan', TRUE),
                    'alamat_panti' => $this->input->post('alamat_panti', TRUE),
                    'no_telepon_panti' => $this->input->post('no_telepon_panti', TRUE),
                    'akta_notaris' => $this->input->post('akta_notaris', TRUE),
                    'izin_operasional' => $this->input->post('izin_operasional', TRUE),
                    'npwp' => $this->input->post('npwp', TRUE),
                    'ad_art' => $this->input->post('ad_art', TRUE),
                    'nama_bank' => $this->input->post('nama_bank', TRUE),
                    'nomor_rekening' => $this->input->post('nomor_rekening', TRUE),
                    'atas_nama_dalam_rekening' => $this->input->post('atas_nama_dalam_rekening', TRUE),
                    'email_panti' => $this->input->post('email_panti', TRUE),
                    'facebook' => $this->input->post('facebook', TRUE),
                    'twitter' => $this->input->post('twitter', TRUE),
                    'website' => $this->input->post('website', TRUE),
                    'nama_admin' => $this->input->post('nama_admin', TRUE),
                    'kontak_person_admin' => $this->input->post('kontak_person_admin', TRUE),
                    'alamat_panti' => $this->input->post('alamat_panti', TRUE),
                    'facebook_admin' => $this->input->post('facebook_admin', TRUE),
                    'email_admin' => $this->input->post('email_admin', TRUE),
                    'twitter_admin' => $this->input->post('twitter_admin', TRUE)
                );
                $where = array(
                    'panti_id' => $data['params_id']
                );
                // selection jika lolos
                if($this->m_panti->update_panti($params, $where)){
                    // update tabel panti
                    $params2 = array(
                        'aktivitas_terakhir' => 'Mengubah data panti',
                        'waktu_eksekusi' => date("Y-m-d H:i:s"),
                        'edited_by' => $this->sesi['username']
                    );
                    $where2 = array(
                        'panti_id' => $data['params_id']
                    );
                    $this->m_panti->update_modifikasi($params2, $where2);
                    // update notif
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasi Disimpan';
                    $this->session->set_userdata('notifikasi',$notifikasi); 
                    redirect(base_url().'logged/panti');
                }
            }else{
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Panti';
        $data['data'] = $result;
        $data['result'] = $result;
        $data['template'] = 'logged/panti/view_panti_edit';
        $this->display($data);
    }

    public function ajax_panti_delete($panti_id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/panti/panti_delete_process/' . $panti_id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function ajax_data_panti($panti_id = ''){
        // header
        header('Content-Type: application/json');
        // get data panti
        $result = $this->m_panti->get_panti_by_id(array($panti_id));
        // memasukkan elemen ke dalam modal
        $nama_panti = $result['nama_panti'];
        $list_status = array('yes' => 'Yes', 'no' => 'No');
        foreach ($list_status as $key => $data) {
            if ($result['verifikasi_status'] == $key) {
                $selected = 'checked="checked"';
            }else{
                $selected = NULL;
            }
            $verifikasi_status .= '<label class="check radio"><input type="radio" class="iradio" name="verifikasi_status" value="' . $key . '" ' . $selected . ' required /> <b>' . $data . '</b></label>';
        }
        $data = array(
            'panti_id' => $result['panti_id'],
            'nama_panti' => $nama_panti,
            'verifikasi_status' => $verifikasi_status
        );
        $return = json_encode($data);
        echo $return;
    }

    // process data valudasi
    public function ajax_verifikasi_panti_process(){
        // 
        $panti_id = $this->input->post('panti_id', TRUE);
        // update
        $params = array(
            'verifikasi_status' => $this->input->post('verifikasi_status', TRUE)
        );
        $where = array(
            'panti_id' => $panti_id
        );
        // return
        if ($this->m_panti->update_panti($params, $where)){
            $status = 'success';
            $value = array(
                'status' => $status,
                'panti_id' => $panti_id,
                'verifikasi_status' => $this->input->post('verifikasi_status', TRUE)
            );
        }
        echo json_encode($value);
        exit();
    }

    public function panti_delete_process($panti_id){
        // declare params
        $where = array(
            'panti_id' => $panti_id
        );
        if ($this->m_panti->delete_panti($where)){
            $notifikasi['notification_header'] = 'success';
            $notifikasi['notification_message'] = 'Data Berhasi Dihapus'; 
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/panti');           
        }
    }

    public function panti_verifikasi($panti_id){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // List data panti
        $result = $this->m_panti->get_panti_by_id(array($panti_id));
        // tampilkan notifikasi
        $data['title'] = 'Verifikasi Data Panti';
        $data['notifikasi'] = $this->lnotifikasi->tampilkan_notifikasi();
        $data['result'] = ($this->lnotifikasi->tampilkan_inputan() == NULL)? $result : $this->lnotifikasi->tampilkan_inputan();
        $data['data'] = $result;
        $data['template'] = 'logged/panti/view_verifikasi_panti';
        $this->display($data);        
    }

    public function verifikasi_process(){
        // notifikasi selection
        $this->lnotifikasi->set_rules('panti_id', 'Panti ID', 'strip_tags|required|max_length[10]');
        $this->lnotifikasi->set_rules('verifikasi_status', 'Verifikasi', 'strip_tags|required');
        // selectiion
        if ($this->lnotifikasi->run() !== FALSE){
            $params = array(
                'verifikasi_status' => $this->input->post('verifikasi_status', TRUE)
            );
            $where = array(
                'panti_id' => $this->input->post('panti_id', TRUE)
            );
            // selection jika lolos
            if($this->m_panti->update_panti($params, $where)){
                $this->lnotifikasi->kirim_notification('success', 'Data panti berhasil diverifikasi');
                redirect(base_url().'logged/panti/panti_verifikasi/' . $this->input->post('panti_id', TRUE));
            }else{
                $this->lnotifikasi->kirim_notification('error', 'Data gagal diverifikasi');
                redirect(base_url().'logged/panti/panti_verifikasi/' . $this->input->post('panti_id', TRUE));
            }
        }else{
            $this->lnotifikasi->kirim_notification('error', 'Data gagal diverifikasi');
            redirect(base_url().'logged/panti/panti_verifikasi/' . $this->input->post('panti_id', TRUE));
        }
        redirect(base_url().'logged/panti/panti_edit/' . $this->input->post('panti_id', TRUE));
    }
}