<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Saldo_awal_rekening extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/master/m_master');
        // load library
        $this->load->library('pagination');
    }

    function load_js(){
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        return $data['load_js'];
    }

    public function index(){
        // load js
        $data['load_js'] = $this->load_js();
        // search
        $search = $this->session->userdata('search_saldo_awal_rekening');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        // get nama panti dari detail
        $searched_post = (empty($search['searched_post']))? '%' : '%' . $search['searched_post'] . '%' ;
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/master/saldo_awal_rekening/index/';
        $config['total_rows'] = $this->m_master->get_total_saldo_awal_rekening(array($searched_post, $searched_post, $searched_post));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_saldo_awal_rekening'] = $this->m_master->get_list_saldo_awal_rekening(array($searched_post, $searched_post, $searched_post, ($start - 1), $config['per_page']));
        // tampilkan notifikasi
        $data['title'] = 'Master - Saldo Awal Rekening';
        $data['template'] = 'logged/master/view_saldo_awal_rekening';
        $this->display($data);
    }

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "searched_post" => $this->input->post('searched_post', TRUE)
            );
            // set session
            $this->session->set_userdata("search_saldo_awal_rekening", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_saldo_awal_rekening");
        }
        // redirect
        redirect(base_url() . "logged/master/saldo_awal_rekening");
    }

    public function saldo_awal_rekening_add(){
        $data['load_js'] = $this->load_js();
        // validasi
        if ($this->input->post()) {
            $this->form_validation->set_rules('kode_perkiraan', 'Kode Perkiraan', 'strip_tags|required|max_length[20]|callback_check_kode_perkiraan');
            $this->form_validation->set_rules('nama_perkiraan', 'Nama Perkiraan', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('saldo_awal', 'Saldo Awal Rekening', 'strip_tags|required|max_length[30]');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                // harus kode perkiraan yang berbeda
                if ($this->m_master->get_kode_perkiraan(array($this->input->post('kode_perkiraan', TRUE))) == TRUE){
                    $notifikasi['notification_header'] = 'error';
                    $notifikasi['notification_message'] = 'Data Kode Perkiraan Telah Tersedia!';
                    $this->session->set_userdata('notifikasi',$notifikasi);  
                }else{
                    $params = array(
                        'kode_perkiraan' => $this->input->post('kode_perkiraan', TRUE),
                        'nama_perkiraan' => $this->input->post('nama_perkiraan', TRUE),
                        'saldo_awal' => input_uang($this->input->post('saldo_awal', TRUE))
                    );
                    // selection jika lolos
                    if($this->m_master->insert_saldo_awal_rekening($params)){
                        $notifikasi['notification_header'] = 'success';
                        $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                        $this->session->set_userdata('notifikasi',$notifikasi);
                        redirect(base_url().'logged/master/saldo_awal_rekening');
                    }
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Saldo Awal Rekening';
        $data['result'] = @$this->input->post();
        $data['template'] = 'logged/master/view_saldo_awal_rekening_add';
        $this->display($data);
    }

    public function saldo_awal_rekening_add_process(){
        $data['load_js'] = $this->load_js();
        // validasi

        // tampilkan notifikasi
        $data['title'] = 'Tambah Data saldo_awal_rekening';
        $data['result'] = $this->input->post();
        $data['template'] = 'logged/master/view_saldo_awal_rekening_add';
        $this->display($data);
    }

    public function saldo_awal_rekening_edit($id = ''){
        // load js
        $data['load_js'] = $this->load_js();
        // LOAD DATA
        $param_id = de($id);
        $result = $this->m_master->get_saldo_awal_rekening_by_id(array($param_id));
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/master/saldo_awal_rekening');
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Saldo Awal Rekening';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'logged/master/view_saldo_awal_rekening_edit';
        $this->display($data);
    }

    public function saldo_awal_rekening_edit_process(){
        // load js
        $data['load_js'] = $this->load_js();
        // notifikasi selection
        $this->form_validation->set_rules('saldo_awal_rekening_id', 'saldo_awal_rekening_id', 'strip_tags|required');
        $this->form_validation->set_rules('kode_perkiraan', 'Kode Perkiraan', 'strip_tags|required|max_length[20]');
        $this->form_validation->set_rules('nama_perkiraan', 'Nama Perkiraan', 'strip_tags|required|max_length[100]');
        $this->form_validation->set_rules('saldo_awal', 'Saldo Awal Rekening', 'strip_tags|required|max_length[30]');
        // selectiion
        if ($this->form_validation->run() !== FALSE){
            $saldo_awal_rekening_id = de($this->input->post('saldo_awal_rekening_id', TRUE));
            $params = array(
                'kode_perkiraan' => $this->input->post('kode_perkiraan', TRUE),
                'nama_perkiraan' => $this->input->post('nama_perkiraan', TRUE),
                'saldo_awal' => input_uang($this->input->post('saldo_awal', TRUE))
            );
            $where = array(
                'saldo_awal_rekening_id' => $saldo_awal_rekening_id
            );
            // selection jika lolos
            if($this->m_master->update_saldo_awal_rekening($params, $where)){
                $notifikasi['notification_header'] = 'success';
                $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                $this->session->set_userdata('notifikasi',$notifikasi);
                redirect(base_url().'logged/master/saldo_awal_rekening');
            }
        }else{
            // validasi error
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_error'] = validation_errors();
            $this->session->set_userdata('notifikasi',$notifikasi);
        }
        $alasan_id = de($id);
        $result = $this->m_master->get_saldo_awal_rekening_by_id(array($alasan_id));
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/master/saldo_awal_rekening');
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Anak Asuh Tinggal';
        $data['result'] = $this->input->post();
        $data['data'] = $result;
        $data['template'] = 'logged/master/view_saldo_awal_rekening_edit';
        $this->display($data);
    }

    public function ajax_saldo_awal_rekening_delete($id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/master/saldo_awal_rekening/saldo_awal_rekening_delete_process/' . $id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function saldo_awal_rekening_delete_process($id){
        // declare params
        $where = array(
            'saldo_awal_rekening_id' => de($id)
        );
        if ($this->m_master->delete_saldo_awal_rekening($where)){
            $notifikasi['notification_header'] = 'success';
            $notifikasi['notification_message'] = 'Data Berhasil Dihapus';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/master/saldo_awal_rekening');           
        }
    }

    // Callback function
    public function check_kode_perkiraan(){
        $kode_perkiraan = $this->input->post('kode_perkiraan');
        $result = $this->m_master->get_saldo_awal_rekening_by_kode_perkiraan(array($kode_perkiraan));
        if ($result) {
            $this->form_validation->set_message('check_kode_perkiraan', 'Data Kode Perkiraan telah terdaftar!');
            return FALSE;
        } else {
            return TRUE;
        }
    }
}