<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Rekening_kas_bank extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/master/m_rekening_kas_bank');
        // load library
        $this->load->library('pagination');
    }

    function load_js(){
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/select2/select2.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js"); 
        return $data['load_js'];
    }

    function load_css(){
        $data['load_css'] = $this->load_style("resource/themes/js/plugins/select2/select2.css");
        return $data['load_css'];
    }

    public function index(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // search
        $search = $this->session->userdata('search_rekening_kas_bank');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        // get nama panti dari detail
        $searched_post = (empty($search['searched_post']))? '%' : '%' . $search['searched_post'] . '%' ;
        $searched_saldo_awal_rekening_id = (empty($search['searched_saldo_awal_rekening_id']))? '%' : '%' . $search['searched_saldo_awal_rekening_id'] . '%' ;
        $searched_jenis_rekening = (empty($search['searched_jenis_rekening']))? '%' : '%' . $search['searched_jenis_rekening'] . '%' ;
        // tampilkan list kode perkiraan
        $data['rs_saldo_awal_rekening'] = $this->m_rekening_kas_bank->get_list_saldo_awal_rekening();
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/master/rekening_kas_bank/index/';
        $config['total_rows'] = $this->m_rekening_kas_bank->get_total_rekening_kas_bank(array($searched_post, $searched_post, $searched_saldo_awal_rekening_id, $searched_jenis_rekening));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_rekening_kas_bank'] = $this->m_rekening_kas_bank->get_list_rekening_kas_bank(array($searched_post, $searched_post, $searched_saldo_awal_rekening_id, $searched_jenis_rekening, ($start - 1), $config['per_page']));
        // tampilkan notifikasi
        $data['title'] = 'Master - Rekening Kas Bank';
        $data['template'] = 'logged/master/view_rekening_kas_bank';
        $this->display($data);
    }

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "searched_post" => $this->input->post('searched_post', TRUE),
                "searched_saldo_awal_rekening_id" => $this->input->post('searched_saldo_awal_rekening_id', TRUE),
                "searched_jenis_rekening" => $this->input->post('searched_jenis_rekening', TRUE)
            );
            // set session
            $this->session->set_userdata("search_rekening_kas_bank", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_rekening_kas_bank");
        }
        // redirect
        redirect(base_url() . "logged/master/rekening_kas_bank");
    }

    public function rekening_kas_bank_add(){
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // tampilkan list kode perkiraan
        $data['rs_saldo_awal_rekening'] = $this->m_rekening_kas_bank->get_list_saldo_awal_rekening();
        // validasi
        if ($this->input->post()){
            // validasi
            $this->form_validation->set_rules('kode_rekening', 'Kode Perkiraan', 'strip_tags|required|max_length[20]|callback_check_kode_rekening');
            $this->form_validation->set_rules('nama_rekening', 'Nama Perkiraan', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('saldo_awal_rekening_id', 'Kode Rekening', 'strip_tags|required');
            $this->form_validation->set_rules('jenis_rekening', 'Jenis Rekening', 'strip_tags|required|max_length[10]');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                // harus kode perkiraan yang berbeda
                if ($this->m_rekening_kas_bank->get_kode_rekening(array($this->input->post('kode_rekening', TRUE))) == TRUE){
                    $notifikasi['notification_header'] = 'error';
                    $notifikasi['notification_message'] = 'Data Kode Rekening Telah Tersedia!';
                    $this->session->set_userdata('notifikasi',$notifikasi);  
                }else{
                    $params = array(
                        'kode_rekening' => $this->input->post('kode_rekening', TRUE),
                        'nama_rekening' => $this->input->post('nama_rekening', TRUE),
                        'saldo_awal_rekening_id' => $this->input->post('saldo_awal_rekening_id', TRUE),
                        'jenis_rekening' => $this->input->post('jenis_rekening', TRUE)
                    );
                    // selection jika lolos
                    if($this->m_rekening_kas_bank->insert_rekening_kas_bank($params)){
                        $notifikasi['notification_header'] = 'success';
                        $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                        $this->session->set_userdata('notifikasi',$notifikasi);
                        redirect(base_url().'logged/master/rekening_kas_bank');
                    }
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Rekening Kas Bank';
        $data['result'] = @$this->input->post();
        $data['template'] = 'logged/master/view_rekening_kas_bank_add';
        $this->display($data);
    }

    public function rekening_kas_bank_edit($params_id = ''){
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // tampilkan list kode perkiraan
        $data['rs_saldo_awal_rekening'] = $this->m_rekening_kas_bank->get_list_saldo_awal_rekening();
        // LOAD DATA
        $data['params_id'] = de($params_id);
        $result = ($this->input->post())?$this->input->post():$this->m_rekening_kas_bank->get_rekening_kas_bank_by_id(array($data['params_id']));
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/master/rekening_kas_bank');
        }
        // validasi
        if ($this->input->post()){
            // notifikasi selection
            $this->form_validation->set_rules('rekening_kas_bank_id', 'rekening_kas_bank_id', 'strip_tags|required');
            $this->form_validation->set_rules('kode_rekening', 'Kode Perkiraan', 'strip_tags|required|max_length[20]|callback_check_kode_rekening_edit');
            $this->form_validation->set_rules('nama_rekening', 'Nama Perkiraan', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('saldo_awal_rekening_id', 'Kode Rekening', 'strip_tags|required');
            $this->form_validation->set_rules('jenis_rekening', 'Jenis Rekening', 'strip_tags|required|max_length[10]');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $rekening_kas_bank_id = de($this->input->post('rekening_kas_bank_id', TRUE));
                $params = array(
                    'kode_rekening' => $this->input->post('kode_rekening', TRUE),
                    'nama_rekening' => $this->input->post('nama_rekening', TRUE),
                    'saldo_awal_rekening_id' => $this->input->post('saldo_awal_rekening_id', TRUE),
                    'jenis_rekening' => $this->input->post('jenis_rekening', TRUE)
                );
                $where = array(
                    'rekening_kas_bank_id' => $rekening_kas_bank_id
                );
                // selection jika lolos
                if($this->m_rekening_kas_bank->update_rekening_kas_bank($params, $where)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/master/rekening_kas_bank');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Rekening Kas Bank';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'logged/master/view_rekening_kas_bank_edit';
        $this->display($data);
    }

    public function ajax_rekening_kas_bank_delete($id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/master/rekening_kas_bank/rekening_kas_bank_delete_process/' . $id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function rekening_kas_bank_delete_process($id){
        // declare params
        $where = array(
            'rekening_kas_bank_id' => de($id)
        );
        if ($this->m_rekening_kas_bank->delete_rekening_kas_bank($where)){
            $notifikasi['notification_header'] = 'success';
            $notifikasi['notification_message'] = 'Data Berhasil Dihapus';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/master/rekening_kas_bank');           
        }
    }

    public function check_kode_rekening(){
        $kode_rekening = $this->input->post('kode_rekening');
        $result = $this->m_rekening_kas_bank->get_rekening_kas_bank_by_kode_rekening(array($kode_rekening));
        if ($result) {
            $this->form_validation->set_message('check_kode_rekening', 'Data Kode Rekening telah terdaftar!');
            return FALSE;
        }else{
            return TRUE;
        }
    }

    public function check_kode_rekening_edit(){
        $kode_rekening = $this->input->post('kode_rekening');
        $rekening_kas_bank_id = $this->input->post('rekening_kas_bank_id');
        $result = $this->m_rekening_kas_bank->get_rekening_kas_bank_by_kode_rekening(array($kode_rekening));
        $res_kas_bank = $this->m_rekening_kas_bank->get_rekening_kas_bank_by_id(array($rekening_kas_bank_id));
        if (($result) && ($result['kode_rekening'] != $res_kas_bank['kode_rekening'])) {
            $this->form_validation->set_message('check_kode_rekening_edit', 'Data Kode Rekening telah terdaftar!');
            return FALSE;
        }else{
            return TRUE;
        }
    }
}