<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Pola_jurnal extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/master/m_pola_jurnal');
        // load library
        $this->load->library('pagination');
    }

    function load_js(){
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/select2/select2.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js"); 
        return $data['load_js'];
    }

    function load_css(){
        $data['load_css'] = $this->load_style("resource/themes/js/plugins/select2/select2.css");
        return $data['load_css'];
    }

    public function index(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // search
        $search = $this->session->userdata('search_pola_jurnal');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        // get nama panti dari detail
        $searched_post = (empty($search['searched_post']))? '%' : '%' . $search['searched_post'] . '%' ;
        $searched_transaksi = (empty($search['searched_transaksi']))? '%' : '%' . $search['searched_transaksi'] . '%' ;
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/master/pola_jurnal/index/';
        $config['total_rows'] = $this->m_pola_jurnal->get_total_pola_jurnal(array($searched_post, $searched_post, $searched_post, $searched_transaksi));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_pola_jurnal'] = $this->m_pola_jurnal->get_list_pola_jurnal(array($searched_post, $searched_post, $searched_post, $searched_transaksi, ($start - 1), $config['per_page']));
        // tampilkan notifikasi
        $data['title'] = 'Master - Pola Jurnal';
        $data['template'] = 'logged/master/view_pola_jurnal';
        $this->display($data);
    }

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "searched_post" => $this->input->post('searched_post', TRUE),
                "searched_transaksi" => $this->input->post('searched_transaksi', TRUE)
            );
            // set session
            $this->session->set_userdata("search_pola_jurnal", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_pola_jurnal");
        }
        // redirect
        redirect(base_url() . "logged/master/pola_jurnal");
    }

    public function pola_jurnal_add(){
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // tampilkan list kode perkiraan
        $data['rs_saldo_awal_rekening'] = $this->m_pola_jurnal->get_list_saldo_awal_rekening();
        if ($this->input->post()) {
            // validasi
            $this->form_validation->set_rules('kode_pola_jurnal', 'Kode Pola Jurnal', 'strip_tags|required|max_length[20]|callback_check_pola_jurnal');
            $this->form_validation->set_rules('transaksi', 'Transaksi', 'strip_tags|required');
            $this->form_validation->set_rules('keterangan', 'Keterangan', 'strip_tags|required|max_length[100]');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                // harus kode pola jurnal yang berbeda
                $params = array(
                    'kode_pola_jurnal' => $this->input->post('kode_pola_jurnal', TRUE),
                    'transaksi' => $this->input->post('transaksi', TRUE),
                    'keterangan' => $this->input->post('keterangan', TRUE)
                );
                // selection jika lolos
                if($this->m_pola_jurnal->insert_pola_jurnal($params)){
                    // get inserted id
                    $insert_id = $this->db->insert_id();
                    // lakukan pemasukan
                    foreach ($this->input->post('kode_perkiraan') as $key => $result) {
                        $param = array($result, $insert_id);
                        if ($result != NULL){
                            if ((!$this->m_pola_jurnal->cek_perkiraan_id_by_pola($param))) {
                                $params = array(
                                    'pola_jurnal_id' => $insert_id,
                                    'saldo_awal_rekening_id' => $result
                                );
                                $this->m_pola_jurnal->insert_perkiraan_jurnal($params);   
                            }
                        }
                    }
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/master/pola_jurnal');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Pola Jurnal';
        $data['result'] = @$this->input->post();
        $data['template'] = 'logged/master/view_pola_jurnal_add';
        $this->display($data);
    }

    public function pola_jurnal_edit($params_id = ''){
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // tampilkan list kode perkiraan
        $data['rs_saldo_awal_rekening'] = $this->m_pola_jurnal->get_list_saldo_awal_rekening();
        // detail pola jurnal yang dipilih
        $result = ($this->input->post())?$this->input->post():$this->m_pola_jurnal->get_pola_jurnal_by_id(array(de($params_id)));
        // get list perkiraan by id
        $data['rs_perkiraan'] = $this->m_pola_jurnal->get_list_perkiraan_by_id(array(de($params_id)));
        // data id pola jurnal
        $data['pola_jurnal_id'] = $params_id;
        // process
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/master/pola_jurnal');
        }
        if ($this->input->post()){
            // notifikasi selection
            $this->form_validation->set_rules('pola_jurnal_id', 'pola_jurnal_id', 'strip_tags|required');
            $this->form_validation->set_rules('kode_pola_jurnal', 'Kode Pola Jurnal', 'strip_tags|required|max_length[20]|callback_check_pola_jurnal_edit');
            $this->form_validation->set_rules('transaksi', 'Transaksi', 'strip_tags|required');
            $this->form_validation->set_rules('keterangan', 'Keterangan', 'strip_tags|required|max_length[100]');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $pola_jurnal_id = de($this->input->post('pola_jurnal_id', TRUE));
                $params = array(
                    'kode_pola_jurnal' => $this->input->post('kode_pola_jurnal', TRUE),
                    'transaksi' => $this->input->post('transaksi', TRUE),
                    'keterangan' => $this->input->post('keterangan', TRUE)
                );
                $where = array(
                    'pola_jurnal_id' => $pola_jurnal_id
                );
                // selection jika lolos
                if($this->m_pola_jurnal->update_pola_jurnal($params, $where)){
                    // delete all data kode perkiraan in db
                    $params = array(
                        'pola_jurnal_id' => de($id)
                    );
                    $this->m_pola_jurnal->delete_perkiraan_jurnal_by_params($params);
                    foreach($this->input->post('kode_perkiraan', TRUE) as $result){
                        if ($result != null){
                            $cek = $this->m_pola_jurnal->cek_perkiraan_id_by_pola(array($result, de($id)));
                            if ($cek == FALSE){
                                $params = array(
                                    'pola_jurnal_id' => de($id),
                                    'saldo_awal_rekening_id' => $result
                                );
                                $this->m_pola_jurnal->insert_perkiraan_jurnal($params);  
                            } 
                        }
                    }
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/master/pola_jurnal');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Rekening Kas Bank';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'logged/master/view_pola_jurnal_edit';
        $this->display($data);
    }

    public function ajax_pola_jurnal_delete($id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/master/pola_jurnal/pola_jurnal_delete_process/' . $id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function pola_jurnal_delete_process($id){
        // declare params
        $where = array(
            'pola_jurnal_id' => de($id)
        );
        if ($this->m_pola_jurnal->delete_pola_jurnal($where)){
            $notifikasi['notification_header'] = 'success';
            $notifikasi['notification_message'] = 'Data Berhasil Dihapus';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/master/pola_jurnal');           
        }
    }

    public function check_pola_jurnal(){
        if ($this->m_pola_jurnal->get_kode_pola_jurnal_id(array($this->input->post('kode_pola_jurnal'))) == TRUE){
            $this->form_validation->set_message('check_pola_jurnal', 'Data Kode Pola Jurnal telah terdaftar!');
            return FALSE;
        } else {
            return TRUE;
        }       
    }

    public function check_pola_jurnal_edit(){
        $res_pola_jurnal = $this->m_pola_jurnal->get_pola_jurnal_by_id(array(de($this->input->post('pola_jurnal_id'))));
        if (($this->m_pola_jurnal->get_kode_pola_jurnal_id(array($this->input->post('kode_pola_jurnal'))) == TRUE) && ($this->input->post('kode_pola_jurnal') != $res_pola_jurnal['kode_pola_jurnal'])){
            $this->form_validation->set_message('check_pola_jurnal_edit', 'Data Kode Pola Jurnal telah terdaftar!');
            return FALSE;
        } else {
            return TRUE;
        }       
    }
}