<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Deskripsi_akta extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/master/m_master');
        // load library
        $this->load->library('pagination');
    }

    function load_js(){
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        return $data['load_js'];
    }

    public function index(){
        // load js
        $data['load_js'] = $this->load_js();
        // search
        $search = $this->session->userdata('search_deskripsi_akta');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        // get nama panti dari detail
        $searched_post = (empty($search['searched_post']))? '%' : '%' . $search['searched_post'] . '%' ;
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/master/deskripsi_akta/index/';
        $config['total_rows'] = $this->m_master->get_total_deskripsi_akta(array($searched_post));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_deskripsi_akta'] = $this->m_master->get_list_deskripsi_akta(array($searched_post, ($start - 1), $config['per_page']));
        // tampilkan notifikasi
        $data['title'] = 'Master - Deskripsi Akta';
        $data['template'] = 'logged/master/view_deskripsi_akta';
        $this->display($data);
    }

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "searched_post" => $this->input->post('searched_post', TRUE)
            );
            // set session
            $this->session->set_userdata("search_deskripsi_akta", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_deskripsi_akta");
        }
        // redirect
        redirect(base_url() . "logged/master/deskripsi_akta");
    }

    public function deskripsi_akta_add(){
        // load js
        $data['load_js'] = $this->load_js();
        // post 
        if ($this->input->post()){
            // validasi
            $this->form_validation->set_rules('nomor_deskripsi_akta', 'Nomor Deskripsi Akta', 'trim|required|max_length[2]|callback_check_nomor_deskripsi_akta');
            $this->form_validation->set_rules('deskripsi_akta', 'Deskripsi Akta', 'trim|required|max_length[100]');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'nomor_deskripsi_akta' => $this->input->post('nomor_deskripsi_akta', TRUE),
                    'deskripsi_akta' => $this->input->post('deskripsi_akta', TRUE)
                );
                // selection jika lolos
                if($this->m_master->insert_deskripsi_akta($params)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/master/deskripsi_akta');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Deskripsi Akta';
        $data['result'] = $this->input->post();
        $data['template'] = 'logged/master/view_deskripsi_akta_add';
        $this->display($data);
    }

    public function deskripsi_akta_edit($params_id = ''){
        // load js
        $data['load_js'] = $this->load_js();
        // LOAD DATA
        $data['params_id'] = de($params_id);
        $result = ($this->input->post())?$this->input->post():$this->m_master->get_deskripsi_akta_by_id(array($data['params_id']));
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/master/deskripsi_akta');
        }
        // validation
        if($this->input->post()){
            // notifikasi selection
            $this->form_validation->set_rules('deskripsi_akta_id', 'ID', 'trim|required|max_length[100]');
            $this->form_validation->set_rules('nomor_deskripsi_akta', 'Nomor Deskripsi Akta', 'trim|required|max_length[2]|callback_check_nomor_deskripsi_akta_edit');
            $this->form_validation->set_rules('deskripsi_akta', 'Deskripsi Akta', 'trim|required|max_length[100]');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $deskripsi_akta_id = de($this->input->post('deskripsi_akta_id', TRUE));
                $params = array(
                    'nomor_deskripsi_akta' => $this->input->post('nomor_deskripsi_akta', TRUE),
                    'deskripsi_akta' => $this->input->post('deskripsi_akta', TRUE)
                );
                $where = array(
                    'deskripsi_akta_id' => $deskripsi_akta_id
                );
                // selection jika lolos
                if($this->m_master->update_deskripsi_akta($params, $where)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/master/deskripsi_akta');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Deskripsi Akta';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'logged/master/view_deskripsi_akta_edit';
        $this->display($data);
    }

    public function ajax_deskripsi_akta_delete($id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/master/deskripsi_akta/deskripsi_akta_delete_process/' . $id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function deskripsi_akta_delete_process($id){
        // declare params
        $where = array(
            'deskripsi_akta_id' => de($id)
        );
        if ($this->m_master->delete_deskripsi_akta($where)){
            $this->lnotifikasi->kirim_notification('success', 'Data berhasil dihapus');
            redirect(base_url().'logged/master/deskripsi_akta');           
        }
    }

        //-- check
    public function check_nomor_deskripsi_akta(){$nomor_deskripsi_akta = $this->input->post('nomor_deskripsi_akta', TRUE);
        $data = $this->m_master->get_existing_nomor_deskripsi_akta(array($nomor_deskripsi_akta));
        if (($data) AND ($data['nomor_deskripsi_akta'] != $this->user_detail['nomor_deskripsi_akta'])){
            $this->form_validation->set_message('check_nomor_deskripsi_akta', 'Data Nomor Deskripsi Akta telah tersedia!');
            return FALSE;
        }else{
            return TRUE;
        }
    }

    public function check_nomor_deskripsi_akta_edit(){
        $deskripsi_akta_id = $this->input->post('deskripsi_akta_id', TRUE);
        $nomor_deskripsi_akta = $this->input->post('nomor_deskripsi_akta', TRUE);
        $data = $this->m_master->get_existing_nomor_deskripsi_akta(array($nomor_deskripsi_akta));
        $nomor = $this->m_master->get_deskripsi_akta_by_id(array(de($deskripsi_akta_id)));
         if (($data) AND ($data['nomor_deskripsi_akta'] != $nomor['nomor_deskripsi_akta'])){
            $this->form_validation->set_message('check_nomor_deskripsi_akta_edit', 'Data Nomor Deskripsi Akta telah tersedia!');
            return FALSE;
        }else{
            return TRUE;
        }
    }
}