<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Aktiva extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/master/m_master');
        // load library
        $this->load->library('pagination');
    }

    function load_js(){
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        return $data['load_js'];
    }

    public function index(){
        // load js
        $data['load_js'] = $this->load_js();
        // search
        $search = $this->session->userdata('search_aktiva');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        // get nama panti dari detail
        $searched_post = (empty($search['searched_post']))? '%' : '%' . $search['searched_post'] . '%' ;
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/master/aktiva/index/';
        $config['total_rows'] = $this->m_master->get_total_aktiva(array($searched_post));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_aktiva'] = $this->m_master->get_list_aktiva(array($searched_post, ($start - 1), $config['per_page']));
        // tampilkan notifikasi
        $data['title'] = 'Master - Aktiva';
        $data['template'] = 'logged/master/view_aktiva';
        $this->display($data);
    }

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "searched_post" => $this->input->post('searched_post', TRUE)
            );
            // set session
            $this->session->set_userdata("search_aktiva", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_aktiva");
        }
        // redirect
        redirect(base_url() . "logged/master/aktiva");
    }

    public function aktiva_add(){
        // load js
        $data['load_js'] = $this->load_js();
        // validasi
        if ($this->input->post()) {
            // validasi
            $this->form_validation->set_rules('deskripsi_aktiva', 'Aktiva', 'strip_tags|required|max_length[100]|xss_clean');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'deskripsi_aktiva' => $this->input->post('deskripsi_aktiva', TRUE)
                );
                // selection jika lolos
                if($this->m_master->insert_aktiva($params)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/master/aktiva');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Aktiva';
        $data['result'] = @$this->input->post();
        $data['template'] = 'logged/master/view_aktiva_add';
        $this->display($data);
    }

    public function aktiva_edit($params_id = ''){
        // load js
        $data['load_js'] = $this->load_js();
        // LOAD DATA
        $data['params_id'] = de($params_id);
        $result = ($this->input->post())?$this->input->post():$this->m_master->get_aktiva_by_id(array($data['params_id']));
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/master/aktiva');
        }
        // validasi
        if ($this->input->post()) {
            // notifikasi selection
            $this->form_validation->set_rules('aktiva_id', 'ID', 'strip_tags|required');
            $this->form_validation->set_rules('deskripsi_aktiva', 'Aktiva', 'strip_tags|required|max_length[100]');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $aktiva_id = de($this->input->post('aktiva_id', TRUE));
                $params = array(
                    'deskripsi_aktiva' => $this->input->post('deskripsi_aktiva', TRUE)
                );
                $where = array(
                    'aktiva_id' => $aktiva_id
                );
                // selection jika lolos
                if($this->m_master->update_aktiva($params, $where)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/master/aktiva');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Anak Asuh Tinggal';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'logged/master/view_aktiva_edit';
        $this->display($data);
    }

    public function ajax_aktiva_delete($id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/master/aktiva/aktiva_delete_process/' . $id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function aktiva_delete_process($id){
        // declare params
        $where = array(
            'aktiva_id' => de($id)
        );
        if ($this->m_master->delete_aktiva($where)){
            $this->lnotifikasi->kirim_notification('success', 'Data berhasil dihapus');
            redirect(base_url().'logged/master/aktiva');           
        }
    }
}