<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Manage_account extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // seleksi dulu berdasarkan hak akses, hanya hak akses 1 dan 2
        if (($this->user_detail['hak_akses'] == 3) xor ($this->user_detail['hak_akses'] == 4)) {
            $this->lnotifikasi->kirim_notification('error', 'Maaf, anda tidak diperkenankan mengakses Menu Manage Account');
            redirect(base_url().'logged/dashboard');
        }
        $this->access_right(array(1,2));
        // load library
        $this->load->model('logged/m_manage_account');
        // load library
        $this->load->library('pagination');
        $this->load->library('send_mail');
    }

	public function index(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // search
        $search = $this->session->userdata('search_manage_account');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        // get nama panti dari detail
        $user_nama = (empty($search['user_nama']))? '%' : '%' . $search['user_nama'] . '%' ;
        $hak_akses = (empty($search['hak_akses']))? '%' : $search['hak_akses'];
        $panti_id = (empty($search['panti_id']))? '%' : $search['panti_id'];
        // pagination
        $config['base_url'] = base_url().'logged/manage_account/index/';
        if ($this->user_detail['hak_akses'] == 1){
            $total_account = $this->m_manage_account->get_total_super_account(array($user_nama, $hak_akses));
        }elseif ($this->user_detail['hak_akses'] == 2){
            $total_account = $this->m_manage_account->get_total_admin_account(array($user_nama, $hak_akses));
        }
        $config['total_rows'] = $total_account;
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        if ($this->user_detail['hak_akses'] == 1){
            $rs_account = $this->m_manage_account->get_all_account_super_limit(array($user_nama, $hak_akses, ($start - 1), $config['per_page']));
        }elseif ($this->user_detail['hak_akses'] == 2){
            $rs_account = $this->m_manage_account->get_all_account_admin_limit(array($user_nama, $hak_akses, ($start - 1), $config['per_page']));
        }
        $data['rs_account'] = $rs_account;
        // tampilkan notifikasi
        $data['title'] = 'Manage Account';
        $data['template'] = 'logged/manage_account/view_manage_account';
		$this->display($data);
	}

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "user_nama" => $this->input->post('user_nama', TRUE),
                "hak_akses" => $this->input->post('hak_akses', TRUE)
            );
            // set session
            $this->session->set_userdata("search_manage_account", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_manage_account");
        }
        // redirect
        redirect(base_url() . "logged/manage_account");
    }

    public function manage_account_add(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // LOAD DATA
        $data['rs_panti'] = $this->m_manage_account->get_list_panti();
        if ($this->input->post()){
            // notifikasi selection
            $this->form_validation->set_rules('nama', 'Nama Lengkap', 'strip_tags|required|max_length[60]');
            $this->form_validation->set_rules('username', 'Username', 'strip_tags|required|max_length[60]|callback_check_existing_username');
            $this->form_validation->set_rules('password', 'Password', 'strip_tags|required|max_length[60]|callback_check_password');
            $this->form_validation->set_rules('re_password', 'Ulangi Password', 'strip_tags|required|max_length[60]');
            $this->form_validation->set_rules('hak_akses', 'Hak Akses', 'strip_tags|required');
            $this->form_validation->set_rules('alamat', 'Alamat', 'strip_tags|required');
            $this->form_validation->set_rules('email', 'E-mail', 'strip_tags|required|valid_email');
            $hak_akses = $this->input->post('hak_akses', TRUE);
            if (($hak_akses == 3) OR ($hak_akses == 4)){
                $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            }
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'nama' => $this->input->post('nama', TRUE),
                    'username' => $this->input->post('username', TRUE),
                    'password' => md5($this->input->post('password', TRUE)),
                    'hak_akses' => $this->input->post('hak_akses', TRUE),
                    'panti_id' => $this->input->post('panti_id', TRUE),
                    'alamat' => $this->input->post('alamat', TRUE),
                    'email' => $this->input->post('email', TRUE)
                );
                // selection jika lolos
                if($this->m_manage_account->insert_akun($params)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Disimpan!';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/manage_account');
                }
            }else{
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }      
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Akun';
        $data['result'] = @$this->input->post();
        $data['template'] = 'logged/manage_account/view_manage_account_add';
        $this->display($data);
    }

    public function manage_account_edit($params_id = ''){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // data akun
        $data['rs_panti'] = $this->m_manage_account->get_list_panti();
        $result = ($this->input->post() == TRUE)?$this->input->post():$this->m_manage_account->get_detail_akun_by_id(array(de($params_id)));
        $data['id'] = de($params_id);
        if ($this->input->post()){
                   // notifikasi selection
        $this->form_validation->set_rules('id', 'ID', 'strip_tags|required|max_length[60]');
        $this->form_validation->set_rules('nama', 'Nama Lengkap', 'strip_tags|required|max_length[60]');
        $this->form_validation->set_rules('username', 'Username', 'strip_tags|required|max_length[60]|callback_check_existing_username_edit');
        $this->form_validation->set_rules('password', 'Password', 'strip_tags|required|max_length[60]|callback_check_password');
        $this->form_validation->set_rules('re_password', 'Ulangi Password', 'strip_tags|required|max_length[60]');
        $this->form_validation->set_rules('hak_akses', 'Hak Akses', 'strip_tags|required');
        $this->form_validation->set_rules('alamat', 'Alamat', 'strip_tags|required');
        $this->form_validation->set_rules('email', 'E-mail', 'strip_tags|required|valid_email');
        // deklarasi password utk ubah password dan username
        $hak_akses = $this->input->post('hak_akses', TRUE);
        if (($hak_akses == 3) OR ($hak_akses == 4)){
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
        }
        // selectiion
        if ($this->form_validation->run() !== FALSE){
            $params = array(
                'nama' => $this->input->post('nama', TRUE),
                'username' => $this->input->post('username', TRUE),
                'password' => md5($this->input->post('password', TRUE)),
                'hak_akses' => $this->input->post('hak_akses', TRUE),
                'panti_id' => $this->input->post('panti_id', TRUE),
                'alamat' => $this->input->post('alamat', TRUE),
                'email' => $this->input->post('email', TRUE)
            );
            $where = array(
                'id' => de($this->input->post('id', TRUE))
            );
            // selection jika lolos
            if($this->m_manage_account->update_akun($params, $where)){
                $notifikasi['notification_header'] = 'success';
                $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                $this->session->set_userdata('notifikasi',$notifikasi);
                redirect(base_url().'logged/manage_account');
            }
        }else{
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_error'] = validation_errors();
            $this->session->set_userdata('notifikasi',$notifikasi);
        }
        }
        // tampilkan notifikasi
        $data['result'] = $result;
        $data['data'] = $result;
        $data['title'] = 'Ubah Data Akun';
        $data['template'] = 'logged/manage_account/view_manage_account_edit';
        $this->display($data);
    }

    public function ajax_manage_account_delete($manage_account_id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/manage_account/manage_account_delete_process/' . $manage_account_id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    // ajax untuk menaruh tombol delete
    public function manage_account_delete_process($id){
        // declare params
        $where = array(
            'id' => $id
        );
        if ($this->m_manage_account->delete_akun($where)){
            $this->lnotifikasi->kirim_notification('success', 'Data berhasil dihapus');
            redirect(base_url().'logged/manage_account');           
        }
    }

    public function manage_account_verify($id = ''){
        // declare params
        $params = array(
            'verified' => 1
        );
        $where = array(
            'id' => de($id)
        );
        if ($this->m_manage_account->update_akun($params, $where)){
            // cari alamat email
            $result = $this->m_manage_account->get_detail_akun_by_id(array(de($id)));
            // kirim notifikasi e-mail ke akun pendaftar
            $message = '
            Selamat, akun anda telah terdaftar, anda dapat mengakses aplikasi Sistem Informasi Panti.
            ';
            // $this->m_manage_account->kirim_pesan($result['email'], $message);
            $this->lnotifikasi->kirim_notification('success', 'Data akun berhasil berubah menjadi terferifikasi');
            redirect(base_url().'logged/manage_account');           
        }
    }

    public function manage_account_unverify($id = ''){
        // declare params
        $params = array(
            'verified' => 0
        );
        $where = array(
            'id' => de($id)
        );
        if ($this->m_manage_account->update_akun($params, $where)){
            // cari alamat email
            $result = $this->m_manage_account->get_detail_akun_by_id(array(de($id)));
            // kirim notifikasi e-mail ke akun pendaftar
            $message = '
            Mohon Maaf, akun anda telah dinonaktifkan oleh admin, anda tidak dapat mengakses aplikasi Sistem Informasi Panti.
            ';
            $this->m_manage_account->kirim_pesan($result['email'], $message);
            $this->lnotifikasi->kirim_notification('success', 'Data akun berhasil berubah menjadi terferifikasi');
            redirect(base_url().'logged/manage_account');           
        }
    }

    // for form validation
    public function check_existing_username(){
        $username = $this->input->post('username', TRUE);
        $data = $this->m_manage_account->get_existing_username_by_input(array($username));
        if (($data) AND ($data['username'] != $this->user_detail['username'])){
            $this->form_validation->set_message('check_existing_username', 'Data Username telah terdaftar!');
            return FALSE;
        }else{
            return TRUE;
        }
    }

    public function check_existing_username_edit(){
        $id = $this->input->post('id', TRUE);
        $username = $this->input->post('username', TRUE);
        $data = $this->m_manage_account->get_existing_username_by_input(array($username));
        $account = $this->m_manage_account->get_manage_account_by_id(array(de($id)));
        if (($data) AND ($data['username'] != $account['username'])){
            $this->form_validation->set_message('check_existing_username_edit', 'Data Username telah terdaftar!');
            return FALSE;
        }else{
            return TRUE;
        }
    }

    public function check_password(){
        if(($this->input->post('password') != $this->input->post('re_password'))){
            $this->form_validation->set_message('check_password', 'Isian Password dan Ulangi Password harus diisi dengan isian yang sama!');
            return FALSE;
        }else{
            return TRUE;
        }
    }
}