<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class stat_panti extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        $this->load->model('logged/m_stat_panti');
    }

	public function index(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        $data['load_js'] = $this->load_javascript("resource/js/highchart/js/highcharts.js");
        $data['load_js'] = $this->load_javascript("resource/js/highchart/js/highcharts-more.js");
        // get detail panti
        $panti_id = $this->get_user_detail();
        $data['data_panti'] = $this->m_stat_panti->get_detail_panti_by_id(array($panti_id['panti_id']));
        // list kabupaten
        $data['rs_pengasuh'] = $this->m_stat_panti->get_number_pengasuh_by_panti(array($panti_id['panti_id']));
        $data['rs_anak_asuh'] = $this->m_stat_panti->get_number_anak_asuh_by_panti(array($panti_id['panti_id']));
        // tampilkan data by pendidikan
        $data['list_pendidikan_pengasuh'] = $this->m_stat_panti->get_list_pendidikan_pengasuh_by_panti(array($panti_id['panti_id']));
        $data['list_pendidikan_anak_asuh'] = $this->m_stat_panti->get_list_pendidikan_anak_asuh_by_panti(array($panti_id['panti_id']));
        // menentukan width untuk tabel
        $total_pendidikan_pengasuh = $this->m_stat_panti->get_jumlah_pendidikan_pengasuh();
        $total_pendidikan_anak_asuh = $this->m_stat_panti->get_jumlah_pendidikan_anak_asuh();
        $data['jumlah_kolom_pengasuh'] = ($total_pendidikan_pengasuh * 2) + 2;
        $data['width_pengasuh'] = (100 / $data['jumlah_kolom_pengasuh']);
        $data['jumlah_kolom_anak_asuh'] = ($total_pendidikan_anak_asuh * 2) + 2;
        $data['width_anak_asuh'] = (100 / $data['jumlah_kolom_anak_asuh']);
        // tampilkan notifikasi
        $data['title'] = 'Statistik Panti';
        $data['notifikasi'] = $this->lnotifikasi->tampilkan_notifikasi();
        $data['template'] = 'logged/kab_stat/stat_panti/view_stat_panti';
        $this->display($data);
	}
}