<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Kab_stat_panti extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        $this->load->model('logged/m_kab_stat_panti');
    }

	public function index($kabupaten_id = ""){
        if ($kabupaten_id <> NULL) {
            $this->panti_kabupaten($kabupaten_id);
        }else{
            $this->panti_diy();
        }
	}

    // Proses untuk se-DIY
    public function panti_diy(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        $data['load_js'] = $this->load_javascript("resource/js/highchart/js/highcharts.js");
        $data['load_js'] = $this->load_javascript("resource/js/highchart/js/highcharts-more.js");
        // list kabupaten
        $data['rs_kabupaten'] = $this->m_kab_stat_panti->get_list_kabupaten();
        $data['rs_pengasuh'] = $this->m_kab_stat_panti->get_pengasuh_by_jenis_kelamin();
        $data['rs_anak_asuh'] = $this->m_kab_stat_panti->get_anak_asuh_by_jenis_kelamin();
        // tampilkan data by pendidikan
        $data['rs_pendidikan_pengasuh'] = $this->m_kab_stat_panti->get_pengasuh_by_pendidikan();
        $data['rs_pendidikan_anak_asuh'] = $this->m_kab_stat_panti->get_anak_asuh_by_pendidikan();
        $data['list_pendidikan_pengasuh'] = $this->m_kab_stat_panti->get_list_pendidikan_pengasuh();
        $data['list_pendidikan_anak_asuh'] = $this->m_kab_stat_panti->get_list_pendidikan_anak_asuh();
        // menentukan width untuk tabel
        $total_pendidikan_pengasuh = $this->m_kab_stat_panti->get_jumlah_pendidikan_pengasuh();
        $total_pendidikan_anak_asuh = $this->m_kab_stat_panti->get_jumlah_pendidikan_anak_asuh();
        $data['jumlah_kolom_pengasuh'] = ($total_pendidikan_pengasuh * 2) + 2;
        $data['width_pengasuh'] = (80 / $data['jumlah_kolom_pengasuh']);
        $data['jumlah_kolom_anak_asuh'] = ($total_pendidikan_anak_asuh * 2) + 2;
        $data['width_anak_asuh'] = (80 / $data['jumlah_kolom_anak_asuh']);
        // tampilkan notifikasi
        $data['title'] = 'Panti Kabupaten';
        $data['notifikasi'] = $this->lnotifikasi->tampilkan_notifikasi();
        $data['template'] = 'logged/kab_stat/kab_stat_panti/view_kab_stat_panti';
        $this->display($data);
    }

    // Proses untuk se-kabupaten
    public function panti_kabupaten($kabupaten_id){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        $data['load_js'] = $this->load_javascript("resource/js/highchart/js/highcharts.js");
        $data['load_js'] = $this->load_javascript("resource/js/highchart/js/highcharts-more.js");
        // identifikasi apakah ada kabupaten yang dipilih
        if (!($this->m_kab_stat_panti->get_detail_kabupaten_by_id(array($kabupaten_id)))){
            redirect(base_url().'logged/kab_stat/kab_stat_panti');
        }
        // list kabupaten
        $data['kabupaten'] = $this->m_kab_stat_panti->get_detail_kabupaten_by_id(array($kabupaten_id));
        $data['rs_kabupaten'] = $this->m_kab_stat_panti->get_list_kabupaten();
        $data['rs_panti'] = $this->m_kab_stat_panti->get_list_panti_by_kabupaten(array($kabupaten_id));
        // tampilkan data by jenis kelamin
        $data['rs_pengasuh'] = $this->m_kab_stat_panti->get_pengasuh_jenis_kelamin_by_kabupaten(array($kabupaten_id));
        $data['rs_anak_asuh'] = $this->m_kab_stat_panti->get_anak_asuh_jenis_kelamin_by_kabupaten(array($kabupaten_id));
        // tampilkan data by pendidikan
        $data['rs_pendidikan_pengasuh'] = $this->m_kab_stat_panti->get_pengasuh_pendidikan_by_kabupaten(array($kabupaten_id));
        $data['rs_pendidikan_anak_asuh'] = $this->m_kab_stat_panti->get_anak_asuh_pendidikan_by_kabupaten(array($kabupaten_id));
        $data['list_pendidikan_pengasuh'] = $this->m_kab_stat_panti->get_list_pendidikan_pengasuh_by_kabupaten(array($kabupaten_id));
        $data['list_pendidikan_anak_asuh'] = $this->m_kab_stat_panti->get_list_pendidikan_anak_asuh_by_kabupaten(array($kabupaten_id));
        // menentukan width untuk tabel
        $total_pendidikan_pengasuh = $this->m_kab_stat_panti->get_jumlah_pendidikan_pengasuh_by_kabupaten(array($kabupaten_id));
        $total_pendidikan_anak_asuh = $this->m_kab_stat_panti->get_jumlah_pendidikan_anak_asuh_by_kabupaten(array($kabupaten_id));
        $data['jumlah_kolom_pengasuh'] = ($total_pendidikan_pengasuh * 2) + 2;
        $data['width_pengasuh'] = (80 / $data['jumlah_kolom_pengasuh']);
        $data['jumlah_kolom_anak_asuh'] = ($total_pendidikan_anak_asuh * 2) + 2;
        $data['width_anak_asuh'] = (80 / $data['jumlah_kolom_anak_asuh']);
        // tampilkan notifikasi
        $data['title'] = 'Panti Kabupaten';
        $data['notifikasi'] = $this->lnotifikasi->tampilkan_notifikasi();
        $data['template'] = 'logged/kab_stat/kab_stat_panti/view_kab_stat_panti_kabupaten';
        $this->display($data);
    }

    // data statistik jumlah anak asuh panti untuk tiap kabupaten
    public function get_data_statistik_anak_asuh_pengasuh() {
        // List Kabupaten
        $rs_kabupaten = $this->m_kab_stat_panti->get_list_kabupaten();
        $category = array();
        foreach ($rs_kabupaten as $data) {
            $category[] = $data['nama_kabupaten'];
        }
        $series1 = array();
        $series1['name'] = 'Jumlah Pengasuh';
        $series2 = array();
        $series2['name'] = 'Jumlah Anak Asuh';
        foreach ($rs_kabupaten as $data) {
            // mau diganti
            $total_pengasuh = $this->m_kab_stat_panti->get_total_pengasuh();
            $total_anak_asuh = $this->m_kab_stat_panti->get_total_anak_asuh();
            $result = $this->m_kab_stat_panti->get_jumlah_pengasuh_dan_anak_asuh_by_kabupaten(array($data['kabupaten_id']));
            $series1['data'][] = is_null($total_pengasuh['data'][$data['kabupaten_id']]['total_pengasuh'])? 0 : $total_pengasuh['data'][$data['kabupaten_id']]['total_pengasuh'];
            $series2['data'][] = is_null($total_anak_asuh['data'][$data['kabupaten_id']]['total_anak_asuh'])? 0 : $total_anak_asuh['data'][$data['kabupaten_id']]['total_anak_asuh'];
        }
        $result = array();
        array_push($result,$category);
        array_push($result,$series1);
        array_push($result,$series2);
        echo json_encode($result, JSON_NUMERIC_CHECK);
    }

    // data statistik jumlah anak asuh panti untuk tiap kabupaten
    public function get_data_statistik_anak_asuh_pengasuh_by_kabupaten($kabupaten_id) {
        // List Kabupaten
        $rs_panti = $this->m_kab_stat_panti->get_list_panti_by_kabupaten(array($kabupaten_id));
        $category = array();
        foreach ($rs_panti as $data) {
            $category[] = $data['nama_panti'];
        }
        $series1 = array();
        $series1['name'] = 'Jumlah Pengasuh';
        $series2 = array();
        $series2['name'] = 'Jumlah Anak Asuh';
        foreach ($rs_panti as $data) {
            $total_pengasuh = $this->m_kab_stat_panti->get_total_pengasuh_by_panti(array($data['panti_id']));
            $total_anak_asuh = $this->m_kab_stat_panti->get_total_anak_asuh_by_panti(array($data['panti_id']));
            $series1['data'][] = is_null($total_pengasuh)? 0 : $total_pengasuh;
            $series2['data'][] = is_null($total_anak_asuh)? 0 : $total_anak_asuh;
        }
        $result = array();
        array_push($result,$category);
        array_push($result,$series1);
        array_push($result,$series2);
        echo json_encode($result, JSON_NUMERIC_CHECK);
    }
}