<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Kab_stat_anak_asuh extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        $this->load->model('logged/m_kab_stat_anak_asuh');
    }

	public function index($kabupaten_id = ""){
        if ($kabupaten_id <> NULL) {
            $this->anak_asuh_kabupaten($kabupaten_id);
        }else{
            $this->anak_asuh_diy();
        }
	}

    // Proses untuk se-DIY
    public function anak_asuh_diy(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        $data['load_js'] = $this->load_javascript("resource/js/highchart/js/highcharts.js");
        $data['load_js'] = $this->load_javascript("resource/js/highchart/js/highcharts-more.js");
        // list kabupaten
        $data['rs_kabupaten'] = $this->m_kab_stat_anak_asuh->get_list_kabupaten();
        $data['rs_anak_asuh'] = $this->m_kab_stat_anak_asuh->get_anak_asuh_by_jenis_kelamin();
        // tampilkan data by pendidikan
        $data['rs_pendidikan_anak_asuh'] = $this->m_kab_stat_anak_asuh->get_anak_asuh_by_pendidikan();
        $data['list_pendidikan_anak_asuh'] = $this->m_kab_stat_anak_asuh->get_list_pendidikan_anak_asuh();
        // menentukan width untuk tabel
        $total_pendidikan_anak_asuh = $this->m_kab_stat_anak_asuh->get_jumlah_pendidikan_anak_asuh();
        $data['jumlah_kolom_anak_asuh'] = ($total_pendidikan_anak_asuh * 2) + 2;
        $data['width_anak_asuh'] = (80 / $data['jumlah_kolom_anak_asuh']);
        // tampilan data untuk pmks
        $data['rs_pmks_anak_asuh'] = $this->m_kab_stat_anak_asuh->get_anak_asuh_by_pmks();
        $data['list_pmks_anak_asuh'] = $this->m_kab_stat_anak_asuh->get_list_pmks_anak_asuh();
        // menentukan width untuk tabel statistik pmks
        $total_kabupaten = $this->m_kab_stat_anak_asuh->get_jumlah_kabupaten_kota();
        $data['jumlah_kabupaten'] = ($total_kabupaten * 2) + 2;
        $data['width_kabupaten'] = (80 / $data['jumlah_kabupaten']);
        // tampilan data untuk status sosial
        $data['rs_sosial_anak_asuh'] = $this->m_kab_stat_anak_asuh->get_sosial_by_kabupaten();
        $data['list_sosial_anak_asuh'] = $this->m_kab_stat_anak_asuh->get_list_sosial_anak_asuh();
        // menentukan width untuk tabel statistik pmks
        $total_sosial = $this->m_kab_stat_anak_asuh->get_jumlah_sosial();
        $data['jumlah_sosial'] = ($total_sosial * 2) + 2;
        $data['width_sosial'] = (80 / $data['jumlah_sosial']);
        // tampilkan notifikasi
        $data['title'] = 'Anak Asuh Kabupaten';
        $data['notifikasi'] = $this->lnotifikasi->tampilkan_notifikasi();
        $data['template'] = 'logged/kab_stat/kab_stat_anak_asuh/view_kab_stat_anak_asuh';
        $this->display($data);
    }

    // Proses untuk se-kabupaten
    public function anak_asuh_kabupaten($kabupaten_id){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        $data['load_js'] = $this->load_javascript("resource/js/highchart/js/highcharts.js");
        $data['load_js'] = $this->load_javascript("resource/js/highchart/js/highcharts-more.js");
        // identifikasi apakah ada kabupaten yang dipilih
        if (!($this->m_kab_stat_anak_asuh->get_detail_kabupaten_by_id(array($kabupaten_id)))){
            redirect(base_url().'logged/kab_stat/kab_stat_anak_asuh');
        }
        // list kabupaten
        $data['kabupaten'] = $this->m_kab_stat_anak_asuh->get_detail_kabupaten_by_id(array($kabupaten_id));
        $data['rs_panti'] = $this->m_kab_stat_anak_asuh->get_list_panti_by_kabupaten(array($kabupaten_id));
        $data['rs_anak_asuh'] = $this->m_kab_stat_anak_asuh->get_anak_asuh_jenis_kelamin_by_kabupaten(array($kabupaten_id));
        // tampilkan data by pendidikan
        $data['rs_pendidikan_anak_asuh'] = $this->m_kab_stat_anak_asuh->get_anak_asuh_pendidikan_by_kabupaten(array($kabupaten_id));
        $data['list_pendidikan_anak_asuh'] = $this->m_kab_stat_anak_asuh->get_list_pendidikan_anak_asuh_by_kabupaten(array($kabupaten_id));
        // menentukan width untuk tabel
        $total_pendidikan_anak_asuh = $this->m_kab_stat_anak_asuh->get_jumlah_pendidikan_anak_asuh_by_kabupaten(array($kabupaten_id));
        $data['jumlah_kolom_anak_asuh'] = ($total_pendidikan_anak_asuh * 2) + 2;
        $data['width_anak_asuh'] = (80 / $data['jumlah_kolom_anak_asuh']);
        // tampilan data untuk pmks
        $data['rs_pmks_anak_asuh'] = $this->m_kab_stat_anak_asuh->get_anak_asuh_pmks_by_panti();
        $data['list_pmks_anak_asuh'] = $this->m_kab_stat_anak_asuh->get_list_pmks_anak_asuh();
        // menentukan width untuk tabel statistik pmks
        $total_panti = $this->m_kab_stat_anak_asuh->get_total_panti_by_kabupaten(array($kabupaten_id));
        $data['jumlah_panti'] = ($total_panti * 2);
        $data['width_panti'] = (90 / $data['jumlah_panti']);
        // tampilan data untuk status sosial
        $data['rs_sosial_anak_asuh'] = $this->m_kab_stat_anak_asuh->get_sosial_by_panti();
        $data['list_sosial_anak_asuh'] = $this->m_kab_stat_anak_asuh->get_list_sosial_anak_asuh_by_kabupaten(array($kabupaten_id));
        // menentukan width untuk tabel statistik pmks
        $total_sosial = $this->m_kab_stat_anak_asuh->get_jumlah_sosial_by_kabupaten(array($kabupaten_id));
        $data['jumlah_sosial'] = ($total_sosial * 2) + 2;
        $data['width_sosial'] = (80 / $data['jumlah_sosial']);
        // tampilkan notifikasi
        $data['title'] = 'Anak Asuh Kabupaten';
        $data['notifikasi'] = $this->lnotifikasi->tampilkan_notifikasi();
        $data['template'] = 'logged/kab_stat/kab_stat_anak_asuh/view_kab_stat_anak_asuh_kabupaten';
        $this->display($data);
    }

    // data statistik jumlah anak asuh panti untuk tiap kabupaten
    public function get_data_statistik_anak_asuh() {
        // List Kabupaten
        $rs_kabupaten = $this->m_kab_stat_anak_asuh->get_list_kabupaten();
        $category = array();
        foreach ($rs_kabupaten as $data) {
            $category[] = $data['nama_kabupaten'];
        }
        $series1 = array();
        $series1['name'] = 'Jumlah Anak Asuh';
        foreach ($rs_kabupaten as $data) {
            $result = $this->m_kab_stat_anak_asuh->get_jumlah_anak_asuh_by_kabupaten(array($data['kabupaten_id']));
            $series1['data'][] = is_null($result['total_anak_asuh'])? 0 : $result['total_anak_asuh'];
        }
        $result = array();
        array_push($result,$category);
        array_push($result,$series1);
        echo json_encode($result, JSON_NUMERIC_CHECK);
    }

    // data statistik jumlah anak asuh panti untuk tiap panti di kabupaten yang dipilih
    public function get_data_statistik_anak_asuh_kabupaten($kabupaten_id) {
        // List Kabupaten
        $rs_panti = $this->m_kab_stat_anak_asuh->get_list_panti_by_kabupaten(array($kabupaten_id));
        $category = array();
        foreach ($rs_panti as $data) {
            $category[] = $data['nama_panti'];
        }
        $series1 = array();
        $series1['name'] = 'Jumlah Anak Asuh';
        foreach ($rs_panti as $data) {
            $total_anak_asuh = $this->m_kab_stat_anak_asuh->get_total_anak_asuh_by_panti(array($data['panti_id']));
            $series1['data'][] = is_null($total_anak_asuh)? 0 : $total_anak_asuh;
        }
        $result = array();
        array_push($result,$category);
        array_push($result,$series1);
        echo json_encode($result, JSON_NUMERIC_CHECK);
    }
}