<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Dashboard_muktamar extends LoggedBase{

    public $sesi;

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        $this->access_right(array(1,2,3));
        $this->load->model('logged/m_dashboard_muktamar');
        $this->sesi = $this->get_user_detail();
    }

	public function index(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // tag open
        $data['rs_ketum'] = $this->m_dashboard_muktamar->get_all_ketum();
        // tampilkan notifikasi
        $data['title'] = 'Pemilihan Ketum PP Pemuda Muhammadiyah 2018-2022';
        $data['template'] = 'logged/dashboard/view_dashboard_muktamar';
        $this->display($data);
	}

    // public function
    public function index_admin(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        $data['load_js'] = $this->load_javascript("resource/js/highchart/js/highcharts.js");
        $data['load_js'] = $this->load_javascript("resource/js/highchart/js/highcharts-more.js");
        // mendapatkan data jumlah panti
        $data['jumlah_panti'] = $this->m_dashboard->get_total_panti();
        // mendapatkan data jumlah pengasuh
        $data['jumlah_pengasuh'] = $this->m_dashboard->get_total_pengasuh();
        // mendapatkan data jumlah pengasuh
        $data['jumlah_anak_asuh'] = $this->m_dashboard->get_total_anak_asuh();
        // data statistik panti
        $stat_panti = $this->get_data_statistik_jumlah_panti();
        $data['chart1_nama_kabupaten'] = $stat_panti['nama_kabupaten'];
        $data['chart1_total_panti'] = $stat_panti['total_panti'];
        $data['rs_stat_panti'] = $this->m_dashboard->get_jumlah_panti_per_kabupaten();
        // data statistik panti by jenis kelamin pengasuh
        $stat_jk_pengasuh = $this->get_data_statistik_jk_pengasuh();
        $data['chart2_jk_pengasuh'] = $stat_jk_pengasuh;
        $data['rs_stat_jk'] = $this->m_dashboard->get_list_jk_pengasuh();
        // data statistik panti by jenis kelamin anak asuh
        $stat_jk_anak_asuh = $this->get_data_statistik_jk_anak_asuh();
        $data['chart3_jk_anak_asuh'] = $stat_jk_anak_asuh;
        $data['rs_stat_anak_asuh'] = $this->m_dashboard->get_list_jk_anak_asuh();
        // data statistik pie chart pengasuh
        $stat_pie_pengasuh = $this->get_pie_pengasuh();
        $data['chart4_pie_pengasuh'] = $stat_pie_pengasuh;
        // data statistik pie chart anak asuh
        $stat_pie_anak_asuh = $this->get_pie_anak_asuh();
        $data['chart5_pie_anak_asuh'] = $stat_pie_anak_asuh;
        // tampilkan notifikasi
        $data['title'] = 'Dashboard';
        $data['notifikasi'] = $this->lnotifikasi->tampilkan_notifikasi();
        $data['template'] = 'logged/dashboard/view_dashboard_muktamar';
        $this->display($data);
    }

    public function index_operator(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        $data['load_js'] = $this->load_javascript("resource/js/highchart/js/highcharts.js");
        $data['load_js'] = $this->load_javascript("resource/js/highchart/js/highcharts-more.js");
        //
        // print_r($this->session->userdata('mpspwmdiy_system')); die('DGFDSG'); 
        $panti_id = $this->sesi['panti_id'];
        // mendapatkan data jumlah pengasuh
        $data['jumlah_pengasuh'] = $this->m_dashboard->get_total_pengasuh_by_panti(array($panti_id));
        // mendapatkan data jumlah pengasuh
        $data['jumlah_anak_asuh'] = $this->m_dashboard->get_total_anak_asuh_by_panti(array($panti_id));
        // data statistik pie chart pengasuh
        $stat_pie_pengasuh_jk = $this->get_pie_pengasuh_jk($panti_id);
        $data['chart1_pie_pengasuh'] = $stat_pie_pengasuh_jk;
        // data statistik pie chart anak asuh
        $stat_pie_anak_asuh_jk = $this->get_pie_anak_asuh_jk($panti_id);
        $data['chart2_pie_anak_asuh'] = $stat_pie_anak_asuh_jk;
        // data statistik pie chart pengasuh
        $stat_pie_pengasuh_pendidikan = $this->get_pie_pengasuh_pendidikan($panti_id);
        $data['chart4_pie_pengasuh'] = $stat_pie_pengasuh_pendidikan;
        // data statistik pie chart anak asuh
        $stat_pie_anak_asuh_pendidikan = $this->get_pie_anak_asuh_pendidikan($panti_id);
        $data['chart5_pie_anak_asuh'] = $stat_pie_anak_asuh_pendidikan;
        // tampilkan notifikasi
        $data['title'] = 'Dashboard';
        $data['notifikasi'] = $this->lnotifikasi->tampilkan_notifikasi();
        $data['template'] = 'logged/dashboard/view_dashboard_operator';
        $this->display($data);
    }

    // data statistik jumlah panti untuk tiap kabupaten
    public function get_data_statistik_jumlah_panti() {
        // header("content-type: application/json");
        $rs_jumlah = $this->m_dashboard->get_jumlah_panti_per_kabupaten();
        $nama_kabupaten = '';
        $total_panti = '';
        foreach ($rs_jumlah as $result) {
            $nama_kabupaten .= '"' . $result['nama_kabupaten'] . '",';
            $total_panti .= $result['total_panti'] . ', ';
        }
        // assign data
        $data['nama_kabupaten'] = $nama_kabupaten;
        $data['total_panti'] = $total_panti;
        // output
        return $data;
    }

    // data statistik jumlah pengasuh panti untuk tiap kabupaten
    public function get_data_statistik_jk_pengasuh() {
        // List Kabupaten
        $rs_kabupaten = $this->m_dashboard->get_list_kabupaten();
        // list kabupaten kota untuk sumbu X
        $list_kabupaten = '"Kota Yogyakarta","Kabupaten Sleman","Kabupaten Bantul","Kabupaten Kulon Progo","Kabupaten Gunungkidul",';
        // foreach ($rs_kabupaten as $result){} {
        //     $list_kabupaten .= '"' . $result['nama_kabupaten'] . '",';
        // }
        // list jumlah penduduk untuk sumbu Y
        $rs_kelamin = array('L' => 'Laki-Laki', 'P' => 'Perempuan');
        foreach ($rs_kelamin as $key => $value) {
            $list_data .= "{ name: '" . $value . "',";
            $list_data .= 'data: [';
            foreach ($rs_kabupaten as $result){
                $data = $this->m_dashboard->get_jumlah_pengasuh_jk(array($result['kabupaten_id']));
                $data['data'][$result['kabupaten_id']][$key] = empty($data['data'][$result['kabupaten_id']][$key])? 0 : $data['data'][$result['kabupaten_id']][$key];
                $list_data .= $data['data'][$result['kabupaten_id']][$key] . ',';
            }
            $list_data .= ']},';
        }
        // output
        return array(
            'list_data' => $list_data,
            'list_kabupaten' => $list_kabupaten,
        );
    }

    // data statistik jumlah anak asuh panti untuk tiap kabupaten
    public function get_data_statistik_jk_anak_asuh() {
        // List Kabupaten
        $rs_kabupaten = $this->m_dashboard->get_list_kabupaten();
        // list kabupaten kota untuk sumbu X
        $list_kabupaten = '"Kota Yogyakarta","Kabupaten Sleman","Kabupaten Bantul","Kabupaten Kulon Progo","Kabupaten Gunungkidul",';
        // foreach ($rs_kabupaten as $result){} {
        //     $list_kabupaten .= '"' . $result['nama_kabupaten'] . '",';
        // }
        // list jumlah penduduk untuk sumbu Y
        $rs_kelamin = array('L' => 'Laki-Laki', 'P' => 'Perempuan');
        foreach ($rs_kelamin as $key => $value) {
            $list_data .= "{ name: '" . $value . "',";
            $list_data .= 'data: [';
            foreach ($rs_kabupaten as $result){
                $data = $this->m_dashboard->get_jumlah_anak_asuh_jk(array($result['kabupaten_id']));
                $data['data'][$result['kabupaten_id']][$key] = empty($data['data'][$result['kabupaten_id']][$key])? 0 : $data['data'][$result['kabupaten_id']][$key];
                $list_data .= $data['data'][$result['kabupaten_id']][$key] . ',';
            }
            $list_data .= ']},';
        }
        // output
        return array(
            'list_data' => $list_data,
            'list_kabupaten' => $list_kabupaten,
        );
    }

    // mendapatkan data untuk graik piechart pengasuh
    public function get_pie_pengasuh(){
        $rs_jenjang_pendidikan = array('SD', 'SMP', 'SMA/SMK', 'S1', 'S2', 'S3');
        $list_data = '';
        foreach ($rs_jenjang_pendidikan as $result) {
            $data = $this->m_dashboard->get_jumlah_pengasuh_by_jenjang_pendidikan(array($result));
            $list_data .= '{name: "' . $result . '", y: ' . $data['total_pengasuh'] . '}, ';
        }
        return $list_data;
    }

    // mendapatkan data untuk graik piechart pengasuh by panti
    public function get_pie_pengasuh_pendidikan($panti_id){
        $rs_jenjang_pendidikan = array('SD', 'SMP', 'SMA/SMK', 'S1', 'S2', 'S3');
        $list_data = '';
        foreach ($rs_jenjang_pendidikan as $result) {
            $data = $this->m_dashboard->get_jumlah_pengasuh_by_jenjang_pendidikan_params(array($panti_id, $result));
            $list_data .= '{name: "' . $result . '", y: ' . $data['total_pengasuh'] . '}, ';
        }
        return $list_data;
    }

    // mendapatkan data untuk graik piechart pengasuh
    public function get_pie_pengasuh_jk($panti_id){
        $rs_jenis_kelamin = array('L' => 'Laki-Laki', 'P' => 'Perempuan');
        $list_data = '';
        foreach ($rs_jenis_kelamin as $key => $result) {
            $data = $this->m_dashboard->get_jumlah_pengasuh_by_jenis_kelamin_params(array($panti_id, $key));
            $list_data .= '{name: "' . $result . '", y: ' . $data['total_pengasuh'] . '}, ';
        }
        return $list_data;
    }

    // mendapatkan data untuk graik piechart anak asuh
    public function get_pie_anak_asuh(){
        $rs_jenjang_pendidikan = array('SD', 'SMP', 'SMA/SMK', 'S1', 'S2', 'S3');
        $list_data = '';
        foreach ($rs_jenjang_pendidikan as $result) {
            $data = $this->m_dashboard->get_jumlah_anak_asuh_by_jenjang_pendidikan(array($result));
            $list_data .= '{name: "' . $result . '", y: ' . $data['total_anak_asuh'] . '}, ';
        }
        return $list_data;
    }

    // mendapatkan data untuk graik piechart anak asuh
    public function get_pie_anak_asuh_pendidikan($panti_id){
        $rs_jenjang_pendidikan = array('SD', 'SMP', 'SMA/SMK', 'S1', 'S2', 'S3');
        $list_data = '';
        foreach ($rs_jenjang_pendidikan as $result) {
            $data = $this->m_dashboard->get_jumlah_anak_asuh_by_jenjang_pendidikan_params(array($panti_id, $result));
            $list_data .= '{name: "' . $result . '", y: ' . $data['total_anak_asuh'] . '}, ';
        }
        return $list_data;
    }

    // mendapatkan data untuk graik piechart anak asuh
    public function get_pie_anak_asuh_jk($panti_id){
        $rs_jenis_kelamin = array('L' => 'Laki-Laki', 'P' => 'Perempuan');
        $list_data = '';
        foreach ($rs_jenis_kelamin as $key => $result) {
            $data = $this->m_dashboard->get_jumlah_anak_asuh_by_jenjang_pendidikan_params(array($panti_id, $key));
            $list_data .= '{name: "' . $result . '", y: ' . $data['total_anak_asuh'] . '}, ';
        }
        return $list_data;
    }
}