<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Cetak extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/m_cetak');
        // load library
        $this->load->library('m_pdf');
    }

	public function index(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // search
        $session = $this->get_user_detail();
        $search = $this->session->userdata('search_cetak');
        $data['search'] = $search;
        $panti_id = (empty($search['panti_id']))? '%' : $search['panti_id'];
        if (($session['hak_akses'] == 1) OR ($session['hak_akses'] == 2)) {
            $data['rs_panti'] = $this->m_cetak->get_list_panti();
        } else {
            $data['panti'] = $this->m_cetak->get_detail_panti_by_id(array($session['panti_id']));
        }
        // tampilkan notifikasi
        $data['title'] = 'Print';
        $data['template'] = 'logged/print/view_print';
		$this->display($data);
	}

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "panti_id" => $this->input->post('panti_id', TRUE)
            );
            // set session
            $this->session->set_userdata("search_cetak", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_cetak");
        }
        // redirect
        redirect(base_url() . "logged/cetak");
    }

    public function detail_panti($panti_id){
        $data = $this->m_cetak->get_panti_by_id(array($panti_id));
        return $data;
    }

    // print pdf pengasuh
    public function print_pdf_pengasuh(){
        // search
        $search = $this->session->userdata('search_cetak');
        $data['search'] = $search;
        // deteksi panti dahulu dengan memanfaatkan hak akses
        if (($this->user_detail['hak_akses'] == 1) OR ($this->user_detail['hak_akses'] == 2)){
            if ($search['panti_id'] == NULL) {
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Panti Harus dipilih terlebih dahulu'; 
                $this->session->set_userdata('notifikasi',$notifikasi);
                redirect(base_url().'logged/cetak/');
            }
        }
        // seleksi terlebih dahulu berdasarkan hak akses
        if (($this->user_detail['hak_akses'] == 1) OR ($this->user_detail['hak_akses'] == 2)){
            $panti_id = (empty($search['panti_id']))? '%' : $search['panti_id'];
        }else{
            $panti_id = $this->user_detail['panti_id'];
        }
        // catat ke log tbl panti
        $param_panti_id = (empty($this->session_detail['panti_id']))? $panti_id :$this->session_detail['panti_id'];
        // update tabel panti
        $params2 = array(
            'aktivitas_terakhir' => 'Mencetak data pengasuh reguler',
            'waktu_eksekusi' => date("Y-m-d H:i:s"),
            'edited_by' => $this->session_detail['username']
        );
        $where2 = array(
            'panti_id' => $param_panti_id
        );
        $this->m_cetak->update_modifikasi($params2, $where2);
        // search khusus hak akses panti
        $data['nama_panti'] = $detail_panti['nama_panti'];
        $data['det_panti'] = $this->detail_panti($panti_id);
        $data['dtm'] = $this->datemanipulation;
        // list data
        $no = 1;
        // get list data yang akan diekspor
        $nama_anak_asuh = '%' ;
        $data['rs_id'] = $this->m_cetak->get_exported_data_pengasuh(array($nama_anak_asuh, $panti_id));
        $this->load->view('logged/print/cetak_reguler_pengasuh', $data);
        $sumber = $this->load->view('logged/print/cetak_reguler_pengasuh', $data, TRUE);
        $html = $sumber;
        $pdfFilePath = "hasilreport_pengasuh.pdf";
        $pdf = $this->m_pdf->load();
        $pdf->AddPage('L');
        $pdf->WriteHTML($html);
        $pdf->Output($pdfFilePath, "D");
        exit();
    }

    // print pdf pengasuh
    public function print_pdf_anak_asuh(){
        // search
        $search = $this->session->userdata('search_cetak');
        $data['search'] = $search;
        // deteksi panti dahulu dengan memanfaatkan hak akses
        if (($this->user_detail['hak_akses'] == 1) OR ($this->user_detail['hak_akses'] == 2)){
            if ($search['panti_id'] == NULL) {
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Panti Harus dipilih terlebih dahulu'; 
                $this->session->set_userdata('notifikasi',$notifikasi);
                redirect(base_url().'logged/cetak/');
            }
        }
        // seleksi terlebih dahulu berdasarkan hak akses
        if (($this->user_detail['hak_akses'] == 1) OR ($this->user_detail['hak_akses'] == 2)){
            $panti_id = (empty($search['panti_id']))? '%' : $search['panti_id'];
        }else{
            $panti_id = $this->user_detail['panti_id'];
        }
        // catat ke log tbl panti
        $param_panti_id = (empty($this->session_detail['panti_id']))? $panti_id :$this->session_detail['panti_id'];
        // update tabel panti
        $params2 = array(
            'aktivitas_terakhir' => 'Mencetak data anak asuh reguler',
            'waktu_eksekusi' => date("Y-m-d H:i:s"),
            'edited_by' => $this->session_detail['username']
        );
        $where2 = array(
            'panti_id' => $param_panti_id
        );
        $this->m_cetak->update_modifikasi($params2, $where2);
        // search khusus hak akses panti
        $data['det_panti'] = $this->detail_panti($panti_id);
        $data['dtm'] = $this->datemanipulation;
        // list data
        $no = 1;
        // get list data yang akan diekspor
        $nama_anak_asuh = '%' ;
        $data['rs_id'] = $this->m_cetak->get_exported_data(array($nama_anak_asuh, $panti_id));
        $this->load->view('logged/print/cetak_reguler_anak_asuh', $data);
        $sumber = $this->load->view('logged/print/cetak_reguler_anak_asuh', $data, TRUE);
        $html = $sumber;
        $pdfFilePath = "hasilreport_anak_asuh.pdf";
        $pdf = $this->m_pdf->load();
        $pdf->AddPage('L');
        $pdf->WriteHTML($html);
        $pdf->Output($pdfFilePath, "D");
        exit();
    }

    // print pdf pengasuh
    public function ajax_print_pdf_anak_asuh_proposal(){
        if ($this->session->userdata('search_cetak')){
            $params1 = $this->session->userdata('search_cetak');
            // params
            $params2 = array(
                "tanda_tangan" => $this->input->post('tanda_tangan', TRUE),
                "tanggal" => $this->input->post('tanggal', TRUE)
            );
            $params = array_merge($params1, $params2);
            $actions = $this->session->set_userdata("search_cetak", $params);
        } else {
            // params
            $params = array(
                "tanda_tangan" => $this->input->post('tanda_tangan', TRUE),
                "tanggal" => $this->input->post('tanggal', TRUE)
            );
            $actions = $this->session->set_userdata("search_cetak", $params);
        }
        // memebrikan sembarang nilai
        if (($this->input->post('tanggal', TRUE) != NULL) && ($this->input->post('tanda_tangan', TRUE) != NULL)){
            $value = array(
                'status' => 'success'
            );
        }else{
            $value = array(
                'status' => 'error',
                'note' => '
                    <div class="alert alert-danger" role="alert">
                        <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                        <strong>KESALAHAN
                        </strong><br />
                        Tanggal dan Tanda Tangan Tidak Boleh Kosong !
                    </div>
                '
            );
        }
        echo json_encode($value);
        exit();
    }

    // print pdf pengasuh
    public function ajax_print_pdf_anak_asuh_proposal_excel(){
        if ($this->session->userdata('search_cetak')){
            $params1 = $this->session->userdata('search_cetak');
            // params
            $params2 = array(
                "tanda_tangan" => $this->input->post('tanda_tangan_excel', TRUE),
                "tanggal" => $this->input->post('tanggal_excel', TRUE)
            );
            $params = array_merge($params1, $params2);
            $actions = $this->session->set_userdata("search_cetak", $params);
        } else {
            // params
            $params = array(
                "tanda_tangan" => $this->input->post('tanda_tangan_excel', TRUE),
                "tanggal" => $this->input->post('tanggal_excel', TRUE)
            );
            $actions = $this->session->set_userdata("search_cetak", $params);
        }
        // memebrikan sembarang nilai
        if (($this->input->post('tanggal_excel', TRUE) != NULL) && ($this->input->post('tanda_tangan_excel', TRUE) != NULL)){
            $value = array(
                'status' => 'success'
            );
        }else{
            $value = array(
                'status' => 'error',
                'note' => '
                    <div class="alert alert-danger" role="alert">
                        <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                        <strong>KESALAHAN
                        </strong><br />
                        Tanggal dan Tanda Tangan Tidak Boleh Kosong !
                    </div>
                '
            );
        }
        echo json_encode($value);
        exit();
    }

    // print pdf pengasuh
    public function ajax_print_pdf_pengasuh_proposal_excel(){
        if ($this->session->userdata('search_cetak')){
            $params1 = $this->session->userdata('search_cetak');
            // params
            $params2 = array(
                "tanda_tangan" => $this->input->post('tanda_tangan_pengasuh_excel', TRUE),
                "tanggal" => $this->input->post('tanggal_pengasuh_excel', TRUE)
            );
            $params = array_merge($params1, $params2);
            $actions = $this->session->set_userdata("search_cetak", $params);
        } else {
            // params
            $params = array(
                "tanda_tangan" => $this->input->post('tanda_tangan_pengasuh_excel', TRUE),
                "tanggal" => $this->input->post('tanggal_pengasuh_excel', TRUE)
            );
            $actions = $this->session->set_userdata("search_cetak", $params);
        }
        // memebrikan sembarang nilai
        if (($this->input->post('tanda_tangan_pengasuh_excel', TRUE) != NULL) && ($this->input->post('tanggal_pengasuh_excel', TRUE) != NULL)){
            $value = array(
                'status' => 'success'
            );
        }else{
            $value = array(
                'status' => 'error',
                'note' => '
                    <div class="alert alert-danger" role="alert">
                        <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                        <strong>KESALAHAN
                        </strong><br />
                        Tanggal dan Tanda Tangan Tidak Boleh Kosong !
                    </div>
                '
            );
        }
        echo json_encode($value);
        exit();
    }

    // print pdf pengasuh
    public function ajax_print_pdf_pengasuh_proposal(){ 
        if ($this->session->userdata('search_cetak')){
            $params1 = $this->session->userdata('search_cetak');
            // params
            $params2 = array(
                "pengasuh_proposal_tanda_tangan" => $this->input->post('pengasuh_proposal_tanda_tangan', TRUE),
                "pengasuh_proposal_tanggal" => $this->input->post('pengasuh_proposal_tanggal', TRUE)
            );
            $params = array_merge($params1, $params2);
            $actions = $this->session->set_userdata("search_cetak", $params);
        } else {
            $params = array(
                "pengasuh_proposal_tanda_tangan" => $this->input->post('pengasuh_proposal_tanda_tangan', TRUE),
                "pengasuh_proposal_tanggal" => $this->input->post('pengasuh_proposal_tanggal', TRUE)
            );
            $actions = $this->session->set_userdata("search_cetak", $params);
        }
        // memebrikan sembarang nilai
        if (($this->input->post('pengasuh_proposal_tanda_tangan', TRUE) != NULL) && ($this->input->post('pengasuh_proposal_tanggal', TRUE) != NULL)){
            $value = array(
                'status' => 'success'
            );
        }else{
            $value = array(
                'status' => 'error',
                'note' => '
                    <div class="alert alert-danger" role="alert">
                        <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                        <strong>KESALAHAN
                        </strong><br />
                        Tanggal dan Tanda Tangan Tidak Boleh Kosong !
                    </div>
                '
            );
        }

        echo json_encode($value);
        exit();
    }

    // print pdf proposal
    public function print_pdf_anak_asuh_proposal(){
        // search
        $search = $this->session->userdata('search_cetak');
        $data['search'] = $search;
        // deteksi panti dahulu dengan memanfaatkan hak akses
        if (($this->user_detail['hak_akses'] == 1) OR ($this->user_detail['hak_akses'] == 2)){
            if ($search['panti_id'] == NULL) {
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Panti Harus dipilih terlebih dahulu'; 
                $this->session->set_userdata('notifikasi',$notifikasi);
                redirect(base_url().'logged/cetak/');
            }
        }
        // seleksi terlebih dahulu berdasarkan hak akses
        if (($this->user_detail['hak_akses'] == 1) OR ($this->user_detail['hak_akses'] == 2)){
            $panti_id = (empty($search['panti_id']))? '%' : $search['panti_id'];
        }else{
            $panti_id = $this->user_detail['panti_id'];
        }
        // catat ke log tbl panti
        $param_panti_id = (empty($this->session_detail['panti_id']))? $panti_id :$this->session_detail['panti_id'];
        // update tabel panti
        $params2 = array(
            'aktivitas_terakhir' => 'Mencetak data anak asuh proposal',
            'waktu_eksekusi' => date("Y-m-d H:i:s"),
            'edited_by' => $this->session_detail['username']
        );
        $where2 = array(
            'panti_id' => $param_panti_id
        );
        $this->m_cetak->update_modifikasi($params2, $where2);
        // search khusus hak akses panti
        $data['det_panti'] = $this->detail_panti($panti_id);
        $data['dtm'] = $this->datemanipulation;
        // list data
        $no = 1;
        // get list data yang akan diekspor
        $nama_anak_asuh = '%' ;
        $data['rs_id'] = $this->m_cetak->get_data_anak_asuh_proposal(array($panti_id));
        $this->load->view('logged/print/cetak_reguler_anak_asuh_proposal', $data);
        $sumber = $this->load->view('logged/print/cetak_reguler_anak_asuh_proposal', $data, TRUE);
        $html = $sumber;
        $pdfFilePath = "report_anak_asuh_proposal_".$data['det_panti']['nama_panti'].".pdf";
        $pdf = $this->m_pdf->load();
        $pdf->AddPage('L');
        $pdf->WriteHTML($html);
        $pdf->Output($pdfFilePath, "D");
        exit();
    }

    public function export_proposal_anak_asuh(){
        // load library
        $this->load->library('phpexcel');
        // create excel berdasarkan template yang didesain
        $filepath = "resource/doc/templates/excel/anak_asuh_proposal.xlsx";
        // ---
        $objReader = PHPExcel_IOFactory::createReader('Excel2007');
        $this->phpexcel = $objReader->load($filepath);
        // create border for all data in excel
        $style_border = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN
                )
            ),
            'font' => array(
                'bold' => true,
                'name' => 'Calibri',
                'size' => '11'
            )
        );
        // set active sheet
        $objWorksheet = $this->phpexcel->setActiveSheetIndex(0);
        /*
         * GET DATA
         */
        // tahun
        // Judul
        $search = $this->session->userdata('search_cetak');
        $data['search'] = $search;
        // deteksi panti dahulu dengan memanfaatkan hak akses
        if (($this->user_detail['hak_akses'] == 1) OR ($this->user_detail['hak_akses'] == 2)){
            if ($search['panti_id'] == NULL) {
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Panti Harus dipilih terlebih dahulu'; 
                $this->session->set_userdata('notifikasi',$notifikasi);
                redirect(base_url().'logged/cetak/');
            }
        }
        // seleksi terlebih dahulu berdasarkan hak akses
        if (($this->user_detail['hak_akses'] == 1) OR ($this->user_detail['hak_akses'] == 2)){
            $panti_id = (empty($search['panti_id']))? '%' : $search['panti_id'];
        }else{
            $panti_id = $this->user_detail['panti_id'];
        }
        // catat ke log tbl panti
        $param_panti_id = (empty($this->session_detail['panti_id']))? $panti_id :$this->session_detail['panti_id'];
        // update tabel panti
        $params2 = array(
            'aktivitas_terakhir' => 'Mencetak data anak asuh proposal excel',
            'waktu_eksekusi' => date("Y-m-d H:i:s"),
            'edited_by' => $this->session_detail['username']
        );
        $where2 = array(
            'panti_id' => $param_panti_id
        );
        $this->m_cetak->update_modifikasi($params2, $where2);
        // search khusus hak akses panti
        $det_panti = $this->detail_panti($panti_id);
        $data['dtm'] = $this->datemanipulation;
        // get data
        $objWorksheet->getStyle('B1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true);
        $objWorksheet->setCellValue('B1', strtoupper($det_panti["nama_panti"]));
        $objWorksheet->getStyle('B2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true);
        $objWorksheet->setCellValue('B2', strtoupper($det_panti["alamat_panti"]))->mergeCells('B2:AF2');
        // get list data yang akan diekspor
        $nama_anak_asuh = '%' ;
        $data['rs_id'] = $this->m_cetak->get_data_anak_asuh_proposal_excel(array($panti_id));
        /*
         * ASSIGN TO CELLS
         */
        // list data
        $row = 11;
        $no = 1;
        // loop
        foreach ($data['rs_id'] as $data) {
            // Set cell alignment and number format
            $objWorksheet->getStyle('B' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('C' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT)->setWrapText(true); 
            $objWorksheet->getStyle('D' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT)->setWrapText(true); 
            $objWorksheet->getStyle('E' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('F' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('G' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('H' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('I' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('J' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('K' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('L' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('M' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('N' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT)->setWrapText(true); 
            $objWorksheet->getStyle('O' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('P' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('Q' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('R' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('S' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('T' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('U' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('V' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('W' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('X' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('Y' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('Z' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('AA' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('AB' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('AC' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('AD' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('AE' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('AF' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->setCellValue('B' . ($row), strtoupper($no));
            $objWorksheet->setCellValue('C' . ($row), strtoupper("DIY"));
            $objWorksheet->setCellValue('D' . ($row), strtoupper($data['nama_kabupaten']));
            $objWorksheet->setCellValue('E' . ($row), strtoupper($data['nama_panti']));
            $objWorksheet->setCellValue('F' . ($row), strtoupper("-"));
            $objWorksheet->setCellValue('G' . ($row), strtoupper("-"));
            $objWorksheet->setCellValue('H' . ($row), strtoupper($data['desa_kelurahan']));
            $objWorksheet->setCellValue('I' . ($row), strtoupper($data['kecamatan']));
            $objWorksheet->setCellValue('J' . ($row), strtoupper("-"));
            $objWorksheet->setCellValue('K' . ($row), strtoupper(" ".$data['no_telepon_panti']));
            $objWorksheet->setCellValue('L' . ($row), strtoupper("-"));
            $objWorksheet->setCellValue('M' . ($row), strtoupper($data['kontak_person_admin']));
            $objWorksheet->setCellValue('N' . ($row), strtoupper($data['nama_anak_asuh']));
            $objWorksheet->setCellValue('O' . ($row), strtoupper(" " . $data['nik']));
            $objWorksheet->setCellValue('P' . ($row), strtoupper($data['jenis_kelamin']));
            $objWorksheet->setCellValue('Q' . ($row), strtoupper($data['tempat_lahir']));
            $objWorksheet->setCellValue('R' . ($row), strtoupper($this->datemanipulation->date_to_tanggal_idn($data['tanggal_lahir'])));
            $objWorksheet->setCellValue('S' . ($row), strtoupper(hitung_umur($data['tanggal_lahir'])));
            $objWorksheet->setCellValue('T' . ($row), strtoupper($data['nama_ibu']));
            $objWorksheet->setCellValue('U' . ($row), strtoupper($data['nama_ayah']));
            $objWorksheet->setCellValue('V' . ($row), strtoupper($data['nomor_jenis_masalah']));
            $objWorksheet->setCellValue('W' . ($row), strtoupper($data['nomor_agama']));
            $objWorksheet->setCellValue('X' . ($row), strtoupper($data['nomor_pendidikan']));
            $objWorksheet->setCellValue('Y' . ($row), strtoupper($data['nama_pendamping_bansos']));
            $objWorksheet->setCellValue('Z' . ($row), strtoupper($data['nomor_status_bansos']));
            $objWorksheet->setCellValue('AA' . ($row), strtoupper($data['nomor_keadaan_ortu']));
            $objWorksheet->setCellValue('AB' . ($row), strtoupper($data['nomor_deskripsi_akta']));
            $objWorksheet->setCellValue('AC' . ($row), strtoupper($data['nomor_anak_asuh_tinggal']));
            $objWorksheet->setCellValue('AD' . ($row), strtoupper($data['nomor_yang_mengasuh']));
            $objWorksheet->setCellValue('AE' . ($row), strtoupper($data['nomor_alasan_masuk_panti']));
            $objWorksheet->setCellValue('AF' . ($row), strtoupper($data['alamat_orang_tua']));
            // create line border for all exported data
            $objWorksheet->getStyle('B' . ($row) . ':AF' . ($row))->applyFromArray($style_border);
            // rows and numbers increment
            $row++;
            $no++;
        }
        $objWorksheet->setCellValue('AD' . ($row+2), strtoupper($search['tanda_tangan'] . ', ' . $this->datemanipulation->IndonesianDate($search['tanggal'])));
        $objWorksheet->setCellValue('AD' . ($row+3), strtoupper("KEPALA LKSA"));
        $objWorksheet->setCellValue('AD' . ($row+7), strtoupper($det_panti["nama_admin"]));
        // set print area
        $objWorksheet->getPageSetup()->setPrintArea('B2:AF' . ($row+10));
        $objWorksheet->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        $objWorksheet->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
        $objWorksheet->getPageSetup()->setFitToPage(true);
        $objWorksheet->getPageSetup()->setFitToWidth(1);
        $objWorksheet->getPageSetup()->setFitToHeight(0);
        // output file
        $file_name = 'PROPOSAL_ANAK_ASUH_PANTI_'.$det_panti["nama_panti"];
        //--
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename=' . strtoupper($file_name) . '.xlsx');
        header('Cache-Control: max-age=0');
        // output
        $obj_writer = PHPExcel_IOFactory::createWriter($this->phpexcel, 'Excel2007');
        $obj_writer->save('php://output');
    }

    public function export_proposal_pengasuh(){
        // load library
        $this->load->library('phpexcel');
        // create excel berdasarkan template yang didesain
        $filepath = "resource/doc/templates/excel/pengasuh_proposal.xlsx";
        // ---
        $objReader = PHPExcel_IOFactory::createReader('Excel2007');
        $this->phpexcel = $objReader->load($filepath);
        // create border for all data in excel
        $style_border = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN
                )
            ),
            'font' => array(
                'bold' => true,
                'name' => 'Calibri',
                'size' => '11'
            )
        );
        // set active sheet
        $objWorksheet = $this->phpexcel->setActiveSheetIndex(0);
        /*
         * GET DATA
         */
        // tahun
        // Judul
        $search = $this->session->userdata('search_cetak');
        $data['search'] = $search;
        // deteksi panti dahulu dengan memanfaatkan hak akses
        if (($this->user_detail['hak_akses'] == 1) OR ($this->user_detail['hak_akses'] == 2)){
            if ($search['panti_id'] == NULL) {
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Panti Harus dipilih terlebih dahulu'; 
                $this->session->set_userdata('notifikasi',$notifikasi);
                redirect(base_url().'logged/cetak/');
            }
        }
        // seleksi terlebih dahulu berdasarkan hak akses
        if (($this->user_detail['hak_akses'] == 1) OR ($this->user_detail['hak_akses'] == 2)){
            $panti_id = (empty($search['panti_id']))? '%' : $search['panti_id'];
        }else{
            $panti_id = $this->user_detail['panti_id'];
        }
        // catat ke log tbl panti
        $param_panti_id = (empty($this->session_detail['panti_id']))? $panti_id :$this->session_detail['panti_id'];
        // update tabel panti
        $params2 = array(
            'aktivitas_terakhir' => 'Mencetak data pengasuh proposal excel',
            'waktu_eksekusi' => date("Y-m-d H:i:s"),
            'edited_by' => $this->session_detail['username']
        );
        $where2 = array(
            'panti_id' => $param_panti_id
        );
        $this->m_cetak->update_modifikasi($params2, $where2);
        // search khusus hak akses panti
        $det_panti = $this->detail_panti($panti_id);
        $data['dtm'] = $this->datemanipulation;
        // get data
        $objWorksheet->getStyle('B2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true);
        $objWorksheet->setCellValue('B2', strtoupper($det_panti["nama_panti"]));
        $objWorksheet->getStyle('B3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true);
        $objWorksheet->setCellValue('B3', strtoupper($det_panti["alamat_panti"]))->mergeCells('B3:L3');
        // get list data yang akan diekspor
        $nama_anak_asuh = '%' ;
        $data['rs_id'] = $this->m_cetak->get_data_pengasuh_proposal_excel(array($panti_id));
        /*
         * ASSIGN TO CELLS
         */
        // list data
        $row = 9;
        $no = 1;
        // loop
        foreach ($data['rs_id'] as $data) {
            // Set cell alignment and number format
            $objWorksheet->getStyle('B' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('C' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT)->setWrapText(true); 
            $objWorksheet->getStyle('D' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT)->setWrapText(true); 
            $objWorksheet->getStyle('E' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('F' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('G' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('H' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('I' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('J' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->getStyle('K' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true); 
            $objWorksheet->setCellValue('B' . ($row), strtoupper($no));
            $objWorksheet->setCellValue('C' . ($row), strtoupper($data['nama_pengasuh']));
            $objWorksheet->setCellValue('D' . ($row), strtoupper(" " . $data['nik']));
            $objWorksheet->setCellValue('E' . ($row), strtoupper($data['jenis_kelamin']));
            $objWorksheet->setCellValue('F' . ($row), strtoupper($data['tempat_lahir']));
            $objWorksheet->setCellValue('G' . ($row), strtoupper($this->datemanipulation->date_to_tanggal_idn($data['tanggal_lahir'])));
            $objWorksheet->setCellValue('H' . ($row), strtoupper($data['mulai_bekerja_di_panti']));
            $objWorksheet->setCellValue('I' . ($row), strtoupper($data['nomor_status_kepegawaian']));
            $objWorksheet->setCellValue('J' . ($row), strtoupper($data['jenjang_pendidikan']));
            $objWorksheet->setCellValue('K' . ($row), strtoupper("-"));
            $q_pelatihan = $this->m_cetak->get_list_pelatihan_by_pengasuh(array($data['pengasuh_id']));
            $total_pelatihan = $this->m_cetak->get_total_pelatihan_by_pengasuh(array($data['pengasuh_id']));
            if ($q_pelatihan){
                $index = 1;
                foreach($q_pelatihan as $result){
                    $objWorksheet->getStyle('L' . ($row))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT)->setWrapText(true); 
                    $objWorksheet->setCellValue('L' . ($row), strtoupper(" ". $result['deskripsi_pelatihan']));
                    // create line border for all exported data
                    $objWorksheet->getStyle('B' . ($row) . ':L' . ($row))->applyFromArray($style_border);
                    if ($index == $total_pelatihan){
                        break;
                    }else{
                        $index++;
                        $row++;
                    }
                }
            }
            // create line border for all exported data
            $objWorksheet->getStyle('B' . ($row) . ':L' . ($row))->applyFromArray($style_border);
            // rows and numbers increment
            $row++;
            $no++;
        }
        $objWorksheet->setCellValue('J' . ($row+2), strtoupper($search['tanda_tangan'] . ', ' . $this->datemanipulation->IndonesianDate($search['tanggal'])));
        $objWorksheet->setCellValue('J' . ($row+3), strtoupper("KEPALA LKSA"));
        $objWorksheet->setCellValue('J' . ($row+7), strtoupper($det_panti["nama_admin"]));
        // set print area
        $objWorksheet->getPageSetup()->setPrintArea('B2:AF' . ($row+10));
        $objWorksheet->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        $objWorksheet->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
        $objWorksheet->getPageSetup()->setFitToPage(true);
        $objWorksheet->getPageSetup()->setFitToWidth(1);
        $objWorksheet->getPageSetup()->setFitToHeight(0);
        // output file
        $file_name = 'PROPOSAL_ANAK_ASUH_PANTI_'.$det_panti["nama_panti"];
        //--
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename=' . strtoupper($file_name) . '.xlsx');
        header('Cache-Control: max-age=0');
        // output
        $obj_writer = PHPExcel_IOFactory::createWriter($this->phpexcel, 'Excel2007');
        $obj_writer->save('php://output');
    }

    // print pdf proposal
    public function print_pdf_pengasuh_proposal(){
        // search
        $search = $this->session->userdata('search_cetak');
        $data['search'] = $search;
        // deteksi panti dahulu dengan memanfaatkan hak akses
        if (($this->user_detail['hak_akses'] == 1) OR ($this->user_detail['hak_akses'] == 2)){
            if ($search['panti_id'] == NULL) {
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_message'] = 'Panti Harus dipilih terlebih dahulu'; 
                $this->session->set_userdata('notifikasi',$notifikasi);
                redirect(base_url().'logged/cetak/');
            }
        }
        // seleksi terlebih dahulu berdasarkan hak akses
        if (($this->user_detail['hak_akses'] == 1) OR ($this->user_detail['hak_akses'] == 2)){
            $panti_id = (empty($search['panti_id']))? '%' : $search['panti_id'];
        }else{
            $panti_id = $this->user_detail['panti_id'];
        }
        // catat ke log tbl panti
        $param_panti_id = (empty($this->session_detail['panti_id']))? $panti_id :$this->session_detail['panti_id'];
        // update tabel panti
        $params2 = array(
            'aktivitas_terakhir' => 'Mencetak data pengasuh proposal',
            'waktu_eksekusi' => date("Y-m-d H:i:s"),
            'edited_by' => $this->session_detail['username']
        );
        $where2 = array(
            'panti_id' => $param_panti_id
        );
        $this->m_cetak->update_modifikasi($params2, $where2);
        // search khusus hak akses panti
        $data['det_panti'] = $this->detail_panti($panti_id);
        $data['dtm'] = $this->datemanipulation;
        // list data
        $no = 1;
        // get list data yang akan diekspor
        $nama_anak_asuh = '%' ;
        $data['rs_id'] = $this->get_data_pengasuh_proposal($panti_id);
        $this->load->view('logged/print/cetak_reguler_pengasuh_proposal', $data);
        $sumber = $this->load->view('logged/print/cetak_reguler_pengasuh_proposal', $data, TRUE);
        $html = $sumber;
        $pdfFilePath = "report_pengasuh_proposal_".$data['det_panti']['nama_panti'].".pdf";
        $pdf = $this->m_pdf->load();
        $pdf->AddPage('L');
        $pdf->WriteHTML($html);
        $pdf->Output($pdfFilePath, "D");
        exit();
    }

    function get_data_pengasuh_proposal($panti_id){
        $tabel = '';
        $query = $this->m_cetak->get_data_pengasuh_proposal(array($panti_id));
        $no = 1;
        foreach ($query as $result) {
            $tabel .= '
            <tr>
                <td>'.$no.'</td>
                <td>'.$result['nama_pengasuh'].'</td>
                <td>'.$result['jenis_kelamin'].'</td>
                <td>'.$result['tempat_lahir'].'</td>
                <td>'.$result['tanggal_lahir'].'</td>
            ';
            $index = 1;
            $q_pelatihan = $this->m_cetak->get_list_pelatihan_by_pengasuh(array($result['pengasuh_id']));
            if ($q_pelatihan){
                foreach($q_pelatihan as $result){
                    if ($index == 1){
                        $tabel .= '
                        <td>'.$result['deskripsi_pelatihan'].'</td></tr>
                        ';
                    }else{
                        $tabel .= '
                        <tr><td></td><td></td><td></td><td></td><td></td><td>'.$result['deskripsi_pelatihan'].'</td></tr>
                        ';
                    }
                    $index++;
                }
            }else{
                    $tabel .= '<td></td></tr>';
            }
            $no++;
        }
        return $tabel;
    }
}