<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Barang extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/m_barang');
        // load library
        $this->load->library('pagination');
    }

    function load_js(){
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/select2/select2.js");
        return $data['load_js'];
    }

    function load_css(){
        $this->load_style("resource/themes/js/plugins/select2/select2.css");
        return $data['load_css'];
    }

    public function index(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // search
        $search = $this->session->userdata('search_barang');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        $data['panti'] = $this->m_barang->get_detail_panti_by_id(array($session['panti_id']));
        // get nama panti dari detail
        $searched_panti = (empty($search['searched_panti']))? '%%' : $search['searched_panti'] ;
        $searched_nama_barang = (empty($search['searched_nama_barang']))? '%%' : '%' . $search['searched_nama_barang'] . '%' ;
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/barang/index/';
        $config['total_rows'] = $this->m_barang->get_total_barang(array($searched_panti, $searched_nama_barang));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_barang'] = $this->m_barang->get_list_barang(array($searched_panti, $searched_nama_barang, ($start - 1), $config['per_page']));
        $data['rs_panti'] = $this->m_barang->get_list_panti();
        // tampilkan notifikasi
        $data['title'] = 'Ruang';
        $data['template'] = 'barang/view_barang';
        $this->display($data);
    }

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "searched_panti" => $this->input->post('searched_panti', TRUE),
                "searched_nama_barang" => $this->input->post('searched_nama_barang', TRUE)
            );
            // set session
            $this->session->set_userdata("search_barang", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_barang");
        }
        // redirect
        redirect(base_url() . "logged/barang");
    }

    public function barang_add(){
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // source
        $data['rs_panti'] = $this->m_barang->get_list_panti();
        $data['rs_jenis_barang'] = $this->m_barang->get_list_jenis_barang();
        $data['rs_kondisi_barang'] = $this->m_barang->get_list_kondisi_barang();
        $data['rs_perolehan_barang'] = $this->m_barang->get_list_perolehan_barang();
        // validasi
        if ($this->input->post()) {
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('nama', 'Nama Kendaraan', 'strip_tags|max_length[50]');
            $this->form_validation->set_rules('merek', 'Merek Kendaraan', 'strip_tags|max_length[20]');
            $this->form_validation->set_rules('kode_aset', 'Kode Aset', 'strip_tags|max_length[50]');
            $this->form_validation->set_rules('perolehan_harga', 'Perolehan Harga', 'strip_tags|numeric');
            $this->form_validation->set_rules('perolehan_tanggal', 'Tanggal Perolehan', 'strip_tags|valid_date');
            $this->form_validation->set_rules('taksir_harga', 'Taksir Harga', 'strip_tags|numeric');
            $this->form_validation->set_rules('taksir_tahun', 'Taksir Tahun', 'strip_tags|numeric|max_length[4]');
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'panti_id' => ($this->input->post('panti_id', TRUE) != null)?$this->input->post('panti_id', TRUE):null,
                    'ruang_id' => ($this->input->post('bangunan_id', TRUE) != null)?$this->input->post('bangunan_id', TRUE):null,
                    'ruang_id' => ($this->input->post('ruang_id', TRUE) != null)?$this->input->post('ruang_id', TRUE):null,
                    'jenis_id' => ($this->input->post('jenis_id', TRUE) != null)?$this->input->post('jenis_id', TRUE):null,
                    'kondisi_id' => ($this->input->post('kondisi_id', TRUE) != null)?$this->input->post('kondisi_id', TRUE):null,
                    'perolehan_id' => ($this->input->post('perolehan_id', TRUE) != null)?$this->input->post('perolehan_id', TRUE):null,
                    'nama' => ($this->input->post('nama', TRUE) != null)?$this->input->post('nama', TRUE):null,
                    'merek' => ($this->input->post('merek', TRUE) != null)?$this->input->post('merek', TRUE):null,
                    'kode_aset' => ($this->input->post('kode_aset', TRUE) != null)?$this->input->post('kode_aset', TRUE):null,
                    'perolehan_harga' => ($this->input->post('perolehan_harga', TRUE) != null)?$this->input->post('perolehan_harga', TRUE):null,
                    'perolehan_tanggal' => ($this->input->post('perolehan_tanggal', TRUE) != null)?$this->input->post('perolehan_tanggal', TRUE):null,
                    'taksir_harga' => ($this->input->post('taksir_harga', TRUE) != null)?$this->input->post('taksir_harga', TRUE):null,
                    'taksir_tahun' => ($this->input->post('taksir_tahun', TRUE) != null)?$this->input->post('taksir_tahun', TRUE):null,
                    'keterangan' => ($this->input->post('keterangan', TRUE) != null)?$this->input->post('keterangan', TRUE):null
                );
                // selection jika lolos
                if($this->m_barang->insert_barang($params)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/barang');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Barang';
        $data['result'] = $this->input->post();
        $data['template'] = 'barang/view_barang_add';
        $this->display($data);
    }

    public function barang_edit($params_id = ''){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // source
        $data['rs_panti'] = $this->m_barang->get_list_panti();
        $data['rs_jenis_barang'] = $this->m_barang->get_list_jenis_barang();
        $data['rs_kondisi_barang'] = $this->m_barang->get_list_kondisi_barang();
        $data['rs_perolehan_barang'] = $this->m_barang->get_list_perolehan_barang();
        // LOAD DATA
        $data['params_id'] = de($params_id);
        $result = ($this->input->post())?$this->input->post():$this->m_barang->get_barang_by_id(array($data['params_id']));
        $data['rs_bangunan'] = $this->m_barang->get_list_bangunan_by_panti($result['panti_id']);
        $data['rs_ruang'] = $this->m_barang->get_list_ruang_by_bangunan($result['bangunan_id']);
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/barang');
        }
        if ($this->input->post()) {
            // notifikasi selection
            $this->form_validation->set_rules('barang_id', 'ID', 'trim|required|max_length[100]');
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('nama', 'Nama Kendaraan', 'strip_tags|max_length[50]');
            $this->form_validation->set_rules('merek', 'Merek Kendaraan', 'strip_tags|max_length[20]');
            $this->form_validation->set_rules('kode_aset', 'Kode Aset', 'strip_tags|max_length[50]');
            $this->form_validation->set_rules('perolehan_harga', 'Perolehan Harga', 'strip_tags|numeric');
            $this->form_validation->set_rules('perolehan_tanggal', 'Tanggal Perolehan', 'strip_tags|valid_date');
            $this->form_validation->set_rules('taksir_harga', 'Taksir Harga', 'strip_tags|numeric');
            $this->form_validation->set_rules('taksir_tahun', 'Taksir Tahun', 'strip_tags|numeric|max_length[4]');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $barang_id = de($this->input->post('barang_id', TRUE));
                $params = array(
                    'panti_id' => ($this->input->post('panti_id', TRUE) != null)?$this->input->post('panti_id', TRUE):null,
                    'bangunan_id' => ($this->input->post('bangunan_id', TRUE) != null)?$this->input->post('bangunan_id', TRUE):null,
                    'ruang_id' => ($this->input->post('ruang_id', TRUE) != null)?$this->input->post('ruang_id', TRUE):null,
                    'jenis_id' => ($this->input->post('jenis_id', TRUE) != null)?$this->input->post('jenis_id', TRUE):null,
                    'kondisi_id' => ($this->input->post('kondisi_id', TRUE) != null)?$this->input->post('kondisi_id', TRUE):null,
                    'perolehan_id' => ($this->input->post('perolehan_id', TRUE) != null)?$this->input->post('perolehan_id', TRUE):null,
                    'nama' => ($this->input->post('nama', TRUE) != null)?$this->input->post('nama', TRUE):null,
                    'merek' => ($this->input->post('merek', TRUE) != null)?$this->input->post('merek', TRUE):null,
                    'kode_aset' => ($this->input->post('kode_aset', TRUE) != null)?$this->input->post('kode_aset', TRUE):null,
                    'perolehan_harga' => ($this->input->post('perolehan_harga', TRUE) != null)?$this->input->post('perolehan_harga', TRUE):null,
                    'perolehan_tanggal' => ($this->input->post('perolehan_tanggal', TRUE) != null)?$this->input->post('perolehan_tanggal', TRUE):null,
                    'taksir_harga' => ($this->input->post('taksir_harga', TRUE) != null)?$this->input->post('taksir_harga', TRUE):null,
                    'taksir_tahun' => ($this->input->post('taksir_tahun', TRUE) != null)?$this->input->post('taksir_tahun', TRUE):null,
                    'keterangan' => ($this->input->post('keterangan', TRUE) != null)?$this->input->post('keterangan', TRUE):null
                );
                $where = array(
                    'barang_id' => $barang_id
                );
                // selection jika lolos
                if($this->m_barang->update_barang($params, $where)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/barang');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Ruang';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'barang/view_barang_edit';
        $this->display($data);
    }

    public function ajax_barang_delete($id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/barang/barang_delete_process/' . $id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function barang_delete_process($id){
        // declare params
        $where = array(
            'barang_id' => de($id)
        );
        if ($this->m_barang->delete_barang($where)){
            $this->lnotifikasi->kirim_notification('success', 'Data berhasil dihapus');
            redirect(base_url().'logged/barang');           
        }
    }

    public function get_bangunan_by_panti($panti_id){
        $rs_bangunan = $this->m_barang->get_list_bangunan_by_panti(array($panti_id));

        $html ='';
        $html .='<option value="">-- PILIH --</option>';
        foreach ($rs_bangunan as $key => $value) {
          $html .='<option value="'.$value['bangunan_id'].'">'.$value['bangunan_id'].' - '.$value['nama'].'</option>';
        }

        echo $html;
    }

    public function get_ruang_by_bangunan($bangunan_id){
        $rs_bangunan = $this->m_barang->get_list_ruang_by_bangunan(array($bangunan_id));

        $html ='';
        $html .='<option value="">-- PILIH --</option>';
        foreach ($rs_bangunan as $key => $value) {
          $html .='<option value="'.$value['ruang_id'].'">'.$value['ruang_id'].' - '.$value['nama'].'</option>';
        }

        echo $html;
    }
}