<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Donatur extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/bantuan/m_donatur');
        // load library
        $this->load->library('pagination');
    }

    function load_js(){
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/select2/select2.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js"); 
        return $data['load_js'];
    }

    function load_css(){
        $data['load_css'] = $this->load_style("resource/themes/js/plugins/select2/select2.css");
        return $data['load_css'];
    }

    public function index(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // search
        $search = $this->session->userdata('search_donatur');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        // get nama panti dari detail
        $searched_post = (empty($search['searched_post']))? '%%' : '%' . $search['searched_post'] . '%' ;
        $searched_panti = (empty($search['searched_panti']))? null : $search['searched_panti'];
        // detail panti untuk yg login sebagai panti
        $data['det_panti'] = $this->m_donatur->get_detail_panti(array($this->session_detail['panti_id']));
        // list panti
        $data['rs_panti'] = $this->m_donatur->get_list_panti();
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/bantuan/donatur/index/';
        $config['total_rows'] = $this->m_donatur->get_total_donatur(array($searched_post, $searched_panti));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_donatur'] = $this->m_donatur->get_list_donatur(array($searched_post, $searched_panti, ($start - 1), $config['per_page']));
        // tampilkan notifikasi
        $data['title'] = 'Master - Donatur';
        $data['template'] = 'logged/bantuan/donatur/view_donatur';
        $this->display($data);
    }

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "searched_post" => $this->input->post('searched_post', TRUE),
                "searched_panti" => $this->input->post('searched_panti', TRUE)
            );
            // set session
            $this->session->set_userdata("search_donatur", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_donatur");
        }
        // redirect
        redirect(base_url() . "logged/bantuan/donatur");
    }

    public function donatur_add(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // list panti
        $data['rs_panti'] = $this->m_donatur->get_list_panti();
        // detail panti
        $data['det_panti'] = $this->m_donatur->get_detail_panti(array($this->session_detail['panti_id']));
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Donatur';
        $data['template'] = 'logged/bantuan/donatur/view_donatur_add';
        $this->display($data);
    }

    // TE Bajingan
    public function donatur_add_process(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // list panti
        $data['rs_panti'] = $this->m_donatur->get_list_panti();
        // detail panti
        $data['det_panti'] = $this->m_donatur->get_detail_panti(array($this->session_detail['panti_id']));
        // validasi
        $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
        $this->form_validation->set_rules('nama_donatur', 'Nama Donatur', 'strip_tags|required|max_length[100]');
        $this->form_validation->set_rules('alamat', 'Alamat', 'strip_tags|required');
        $this->form_validation->set_rules('telepon', 'Telepon', 'strip_tags|required|max_length[20]');
        $this->form_validation->set_rules('keterangan', 'Keterangan', 'strip_tags|required');
        // selectiion
        if ($this->form_validation->run() !== FALSE){
            // harus kode perkiraan yang berbeda
                $params = array(
                    'panti_id' => $this->input->post('panti_id', TRUE),
                    'nama_donatur' => $this->input->post('nama_donatur', TRUE),
                    'alamat' => $this->input->post('alamat', TRUE),
                    'telepon' => $this->input->post('telepon', TRUE),
                    'keterangan' => $this->input->post('keterangan', TRUE)
                );
                // selection jika lolos
                if($this->m_donatur->insert_donatur($params)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/bantuan/donatur');
                }
        }else{
            // validasi error
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_error'] = validation_errors();
            $this->session->set_userdata('notifikasi',$notifikasi);
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Donatur';
        $data['result'] = $this->input->post();
        $data['template'] = 'logged/bantuan/donatur/view_donatur_add';
        $this->display($data);
    }

    public function donatur_edit($id = ''){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // list panti
        $data['rs_panti'] = $this->m_donatur->get_list_panti();
        // detail panti
        $data['det_panti'] = $this->m_donatur->get_detail_panti(array($this->session_detail['panti_id']));
        // LOAD DATA
        $param_id = de($id);
        $result = $this->m_donatur->get_donatur_by_id(array($param_id));
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/bantuan/donatur');
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Donatur';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'logged/bantuan/donatur/view_donatur_edit';
        $this->display($data);
    }

    public function donatur_edit_process($id = null){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // list panti
        $data['rs_panti'] = $this->m_donatur->get_list_panti();
        // detail panti
        $data['det_panti'] = $this->m_donatur->get_detail_panti(array($this->session_detail['panti_id']));
        $param_id = de($id);
        $result = $this->m_donatur->get_donatur_by_id(array($param_id));
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/bantuan/donatur');
        }
        // notifikasi selection
        $this->form_validation->set_rules('donatur_id', 'Donatur', 'strip_tags|required');
        $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
        $this->form_validation->set_rules('nama_donatur', 'Nama Donatur', 'strip_tags|required|max_length[100]');
        $this->form_validation->set_rules('alamat', 'Alamat', 'strip_tags|required');
        $this->form_validation->set_rules('telepon', 'Telepon', 'strip_tags|required|max_length[20]');
        $this->form_validation->set_rules('keterangan', 'Keterangan', 'strip_tags|required');
        // selectiion
        if ($this->form_validation->run() !== FALSE){
            $donatur_id = de($this->input->post('donatur_id', TRUE));
            $params = array(
                'panti_id' => $this->input->post('panti_id', TRUE),
                'nama_donatur' => $this->input->post('nama_donatur', TRUE),
                'alamat' => $this->input->post('alamat', TRUE),
                'telepon' => $this->input->post('telepon', TRUE),
                'keterangan' => $this->input->post('keterangan', TRUE)
            );
            $where = array(
                'donatur_id' => $this->input->post('donatur_id', TRUE)
            );
            // selection jika lolos
            if($this->m_donatur->update_donatur($params, $where)){
                $notifikasi['notification_header'] = 'success';
                $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                $this->session->set_userdata('notifikasi',$notifikasi);
                redirect(base_url().'logged/bantuan/donatur');
            }
        }else{
            // validasi error
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_error'] = validation_errors();
            $this->session->set_userdata('notifikasi',$notifikasi);
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Donatur';
        $data['result'] = $this->input->post();
        $data['data'] = $result;
        $data['template'] = 'logged/bantuan/donatur/view_donatur_edit';
        $this->display($data);
    }

    public function ajax_donatur_delete($id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/bantuan/donatur/donatur_delete_process/' . $id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function donatur_delete_process($id){
        // declare params
        $where = array(
            'donatur_id' => de($id)
        );
        if ($this->m_donatur->delete_donatur($where)){
            $notifikasi['notification_header'] = 'success';
            $notifikasi['notification_message'] = 'Data Berhasil Dihapus';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/bantuan/donatur');           
        }
    }
}