<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class aktiva_tetap extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // pengaturan hak akses
        $this->access_right(array(1,2));
        // load library
        $this->load->model('logged/bantuan/m_aktiva_tetap');
        // load library
        $this->load->library('pagination');
        $this->load->library('m_pdf');
    }

    function load_js(){
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/select2/select2.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/typeahead/typeahead.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js"); 
        return $data['load_js'];
    }

    function load_css(){
        $data['load_css'] = $this->load_style("resource/themes/js/plugins/select2/select2.css");
        return $data['load_css'];
    }

    public function index(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // search
        $search = $this->session->userdata('search_aktiva_tetap');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        // get nama panti dari detail
        $searched_panti = (empty($search['searched_panti']))? null : $search['searched_panti'];
        $searched_tanggal_penerimaan = (empty($search['searched_tanggal_penerimaan']))? '%%' : $search['searched_tanggal_penerimaan'];
        $searched_post = (empty($search['searched_post']))? '%%' : '%%' . $search['searched_post'] . '%' ;
        // detail panti untuk yg login sebagai panti
        $data['det_panti'] = $this->m_aktiva_tetap->get_detail_panti(array($this->session_detail['panti_id']));
        // list panti
        $data['rs_panti'] = $this->m_aktiva_tetap->get_list_panti();
        // total bantuan berdasarkan pilihan panti
        $data['total_bantuan'] = $this->m_aktiva_tetap->get_total_bantuan(array($searched_panti, $searched_tanggal_penerimaan, $searched_post));
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/bantuan/aktiva_tetap/index/';
        $config['total_rows'] = $this->m_aktiva_tetap->get_total_aktiva_tetap(array($searched_panti, $searched_tanggal_penerimaan, $searched_post));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_aktiva_tetap'] = $this->m_aktiva_tetap->get_list_aktiva_tetap(array($searched_panti, $searched_tanggal_penerimaan, $searched_post, ($start - 1), $config['per_page']));
        // tampilkan notifikasi
        $data['title'] = 'Master - Aktiva Tetap';
        $data['template'] = 'logged/bantuan/aktiva_tetap/view_aktiva_tetap';
        $this->display($data);
    }

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "searched_post" => $this->input->post('searched_post', TRUE),
                "searched_panti" => $this->input->post('searched_panti', TRUE),
                "searched_tanggal_penerimaan" => $this->input->post('searched_tanggal_penerimaan', TRUE)
            );
            // set session
            $this->session->set_userdata("search_aktiva_tetap", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_aktiva_tetap");
        }
        // redirect
        redirect(base_url() . "logged/bantuan/aktiva_tetap");
    }

    // TE Bajingan
    public function aktiva_tetap_add(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // list panti
        $data['rs_panti'] = $this->m_aktiva_tetap->get_list_panti();
        // detail panti
        $data['det_panti'] = $this->m_aktiva_tetap->get_detail_panti(array($this->session_detail['panti_id']));
        $result = $this->input->post();
        // list donatur
        $data['rs_donatur'] = $this->m_aktiva_tetap->get_list_donatur(array($result['panti_id']));
        // list aktiva
        $data['rs_aktiva'] = $this->m_aktiva_tetap->get_list_aktiva();
        // execution
        if ($this->input->post()){
            // validasi
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            if ($this->input->post('donatur', TRUE) == 'lain'){
                $this->form_validation->set_rules('nama_donatur', 'Donatur', 'strip_tags|required|max_length[100]');
            }else{
                $this->form_validation->set_rules('donatur', 'Donatur', 'strip_tags|required');
            }
            $this->form_validation->set_rules('no_voucher', 'Nomor Voucher', 'strip_tags|required|max_length[30]');
            $this->form_validation->set_rules('tanggal_penerimaan', 'Tanggal Penerimaan', 'strip_tags|required|max_length[20]');
            $this->form_validation->set_rules('aktiva_id', 'Aktiva', 'strip_tags|required');
            $this->form_validation->set_rules('jumlah', 'Jumlah', 'strip_tags|required');
            $this->form_validation->set_rules('keterangan', 'Keterangan', 'strip_tags|required');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                // inser data donatur baru
                if ($this->input->post('donatur', TRUE) == 'lain') {
                    $params = array(
                        'nama_donatur' => $this->input->post('nama_donatur', TRUE),
                        'panti_id' => $this->input->post('panti_id', TRUE)
                    );
                    // selection jika lolos
                    $this->m_aktiva_tetap->insert_donatur($params);
                    $donatur_id = $this->db->insert_id();              
                }else{
                    $donatur_id = $this->input->post('donatur', TRUE);
                }
                // harus kode perkiraan yang berbeda
                $params = array(
                    'panti_id' => $this->input->post('panti_id', TRUE),
                    'no_voucher' => $this->input->post('no_voucher', TRUE),
                    'tanggal_penerimaan' => $this->input->post('tanggal_penerimaan', TRUE),
                    'donatur_id' => $donatur_id,
                    'aktiva_id' => $this->input->post('aktiva_id', TRUE),
                    'jumlah' => input_uang($this->input->post('jumlah', TRUE)),
                    'keterangan' => $this->input->post('keterangan', TRUE)
                );
                // selection jika lolos
                if($this->m_aktiva_tetap->insert_aktiva_tetap($params)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/bantuan/aktiva_tetap');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Aktiva Tetap';
        $data['result'] = @$result;
        $data['template'] = 'logged/bantuan/aktiva_tetap/view_aktiva_tetap_add';
        $this->display($data);
    }

    public function aktiva_tetap_edit($id = ''){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // list panti
        $data['rs_panti'] = $this->m_aktiva_tetap->get_list_panti();
        // detail panti
        $data['det_panti'] = $this->m_aktiva_tetap->get_detail_panti(array($this->session_detail['panti_id']));
        // list aktiva
        $data['rs_aktiva'] = $this->m_aktiva_tetap->get_list_aktiva();
        // LOAD DATA
        $param_id = de($id);
        $result = ($this->input->post())?$this->input->post():$this->m_aktiva_tetap->get_aktiva_tetap_by_id(array($param_id));
        // list donatur
        $data['rs_donatur'] = $this->m_aktiva_tetap->get_list_donatur(array($result['panti_id']));
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/bantuan/aktiva_tetap');
        }
        if ($this->input->post()){
            // validasi
            $this->form_validation->set_rules('aktiva_tetap_id', 'Aktiva Tetap ID', 'strip_tags|required');
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            if ($this->input->post('donatur', TRUE) == 'lain'){
                $this->form_validation->set_rules('nama_donatur', 'Donatur', 'strip_tags|required|max_length[100]');
            }else{
                $this->form_validation->set_rules('donatur', 'Donatur', 'strip_tags|required');
            }
            $this->form_validation->set_rules('no_voucher', 'Nomor Voucher', 'strip_tags|required|max_length[30]');
            $this->form_validation->set_rules('tanggal_penerimaan', 'Tanggal Penerimaan', 'strip_tags|required|max_length[20]');
            $this->form_validation->set_rules('aktiva_id', 'Aktiva', 'strip_tags|required');
            $this->form_validation->set_rules('jumlah', 'Jumlah', 'strip_tags|required');
            $this->form_validation->set_rules('keterangan', 'Keterangan', 'strip_tags|required');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                // inser data donatur baru
                if ($this->input->post('donatur', TRUE) == 'lain') {
                    $params = array(
                        'nama_donatur' => $this->input->post('nama_donatur', TRUE),
                        'panti_id' => $this->input->post('panti_id', TRUE)
                    );
                    // selection jika lolos
                    $this->m_aktiva_tetap->insert_donatur($params);
                    $donatur_id = $this->db->insert_id();              
                }else{
                    $donatur_id = $this->input->post('donatur', TRUE);
                }
                // harus kode perkiraan yang berbeda
                $params = array(
                    'panti_id' => $this->input->post('panti_id', TRUE),
                    'no_voucher' => $this->input->post('no_voucher', TRUE),
                    'tanggal_penerimaan' => $this->input->post('tanggal_penerimaan', TRUE),
                    'donatur_id' => $donatur_id,
                    'aktiva_id' => $this->input->post('aktiva_id', TRUE),
                    'jumlah' => input_uang($this->input->post('jumlah', TRUE)),
                    'keterangan' => $this->input->post('keterangan', TRUE)
                );
                $where = array(
                    'aktiva_tetap_id' => $this->input->post('aktiva_tetap_id', TRUE)
                );
                // selection jika lolos
                if($this->m_aktiva_tetap->update_aktiva_tetap($params, $where)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/bantuan/aktiva_tetap');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Aktiva Tetap';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'logged/bantuan/aktiva_tetap/view_aktiva_tetap_edit';
        $this->display($data);
    }

    public function aktiva_tetap_edit_process($id = null){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // list panti
        $data['rs_panti'] = $this->m_aktiva_tetap->get_list_panti();
        // detail panti
        $data['det_panti'] = $this->m_aktiva_tetap->get_detail_panti(array($this->session_detail['panti_id']));
        // LOAD DATA
        $param_id = de($id);
        // list donatur
        $data['rs_donatur'] = $this->m_aktiva_tetap->get_list_donatur(array($result['panti_id']));
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/bantuan/aktiva_tetap');
        }

        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Aktiva Tetap';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'logged/bantuan/aktiva_tetap/view_aktiva_tetap_edit';
        $this->display($data);
    }

    public function ajax_aktiva_tetap_delete($id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/bantuan/aktiva_tetap/aktiva_tetap_delete_process/' . $id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function aktiva_tetap_delete_process($id){
        // declare params
        $where = array(
            'aktiva_tetap_id' => de($id)
        );
        if ($this->m_aktiva_tetap->delete_aktiva_tetap($where)){
            $notifikasi['notification_header'] = 'success';
            $notifikasi['notification_message'] = 'Data Berhasil Dihapus';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/bantuan/aktiva_tetap');           
        }
    }

// getter

    public function get_list_donatur($panti_id = null){
        $params = array($panti_id);
        $result = $this->m_aktiva_tetap->get_list_donatur($params);
        $data .= '<option value="">-- PILIH DONATUR --</option>';
        foreach ($result as $donatur) {
            $data .= '<option value="'.$donatur['donatur_id'].'">'.$donatur['nama_donatur'].'</option>';
        }
        $data .= '<option value="lain">DONATUR LAIN</option>';
        echo $data;
    }
}