<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Bangunan extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/m_bangunan');
        // load library
        $this->load->library('pagination');
    }

    function load_js(){
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/select2/select2.js");
        return $data['load_js'];
    }

    function load_css(){
        $this->load_style("resource/themes/js/plugins/select2/select2.css");
        return $data['load_css'];
    }

    public function index(){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // search
        $search = $this->session->userdata('search_bangunan');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        $data['panti'] = $this->m_bangunan->get_detail_panti_by_id(array($session['panti_id']));
        // get nama panti dari detail
        $searched_panti = (empty($search['searched_panti']))? '%%' : $search['searched_panti'] ;
        $searched_nama_bangunan = (empty($search['searched_nama_bangunan']))? '%%' : '%' . $search['searched_nama_bangunan'] . '%' ;
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/bangunan/index/';
        $config['total_rows'] = $this->m_bangunan->get_total_bangunan(array($searched_panti, $searched_nama_bangunan));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_bangunan'] = $this->m_bangunan->get_list_bangunan(array($searched_panti, $searched_nama_bangunan, ($start - 1), $config['per_page']));
        $data['rs_panti'] = $this->m_bangunan->get_list_panti();
        // tampilkan notifikasi
        $data['title'] = 'Bangunan';
        $data['template'] = 'bangunan/view_bangunan';
        $this->display($data);
    }

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "searched_panti" => $this->input->post('searched_panti', TRUE),
                "searched_nama_bangunan" => $this->input->post('searched_nama_bangunan', TRUE)
            );
            // set session
            $this->session->set_userdata("search_bangunan", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_bangunan");
        }
        // redirect
        redirect(base_url() . "logged/bangunan");
    }

    public function bangunan_add(){
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // source
        $data['rs_panti'] = $this->m_bangunan->get_list_panti();
        $data['rs_kategori'] = $this->m_bangunan->get_bangunan_kategori();
        // validasi
        if ($this->input->post()) {
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('tanah_id', 'Nomor Sertifikat', 'strip_tags|required');
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'kategori_id' => ($this->input->post('kategori_id', TRUE) != null)?$this->input->post('kategori_id', TRUE):null,
                    'panti_id' => ($this->input->post('panti_id', TRUE) != null)?$this->input->post('panti_id', TRUE):null,
                    'kode_aset' => ($this->input->post('kode_aset', TRUE) != null)?$this->input->post('kode_aset', TRUE):null,
                    'nama' => ($this->input->post('nama', TRUE) != null)?$this->input->post('nama', TRUE):null,
                    'pengelola' => ($this->input->post('pengelola', TRUE) != null)?$this->input->post('pengelola', TRUE):null,
                    'luas' => ($this->input->post('luas', TRUE) != null)?$this->input->post('luas', TRUE):null,
                    'bangun_harga' => ($this->input->post('bangun_harga', TRUE) != null)?$this->input->post('bangun_harga', TRUE):null,
                    'bangun_tanggal' => ($this->input->post('bangun_tanggal', TRUE) != null)?$this->input->post('bangun_tanggal', TRUE):null
                );
                // selection jika lolos
                if($this->m_bangunan->insert_bangunan($params)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Disimpan';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/bangunan');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Bangunan';
        $data['result'] = $this->input->post();
        $data['template'] = 'bangunan/view_bangunan_add';
        $this->display($data);
    }

    public function bangunan_edit($params_id = ''){
        // load js
        $data['load_js'] = $this->load_js();
        $data['load_css'] = $this->load_css();
        // source
        // $data['rs_jenis_sertifikat'] = $this->m_bangunan->get_jenis_sertifikat();
        // $data['rs_bangunan_status'] = $this->m_bangunan->get_bangunan_status();
        $data['rs_panti'] = $this->m_bangunan->get_list_panti();
        // $data['rs_bangunan_perolehan'] = $this->m_bangunan->get_bangunan_perolehan();
        // $data['rs_kategori'] = $this->m_bangunan->get_bangunan_kategori();
        // LOAD DATA
        $data['params_id'] = de($params_id);
        $result = ($this->input->post())?$this->input->post():$this->m_bangunan->get_bangunan_by_id(array($data['params_id']));
        $data['rs_tanah'] = $this->m_bangunan->get_list_tanah_by_panti($result['panti_id']);
        if (!$result) {
            $notifikasi['notification_header'] = 'error';
            $notifikasi['notification_message'] = 'Data Tidak Ditemukan';
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/bangunan');
        }
        if ($this->input->post()) {
            // notifikasi selection
            $this->form_validation->set_rules('bangunan_id', 'ID', 'trim|required|max_length[100]');
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('tanah_id', 'Nomor Sertifikat', 'strip_tags|required');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $bangunan_id = de($this->input->post('bangunan_id', TRUE));
                $params = array(
                    'kategori_id' => ($this->input->post('kategori_id', TRUE) != null)?$this->input->post('kategori_id', TRUE):null,
                    'panti_id' => ($this->input->post('panti_id', TRUE) != null)?$this->input->post('panti_id', TRUE):null,
                    'kode_aset' => ($this->input->post('kode_aset', TRUE) != null)?$this->input->post('kode_aset', TRUE):null,
                    'nama' => ($this->input->post('nama', TRUE) != null)?$this->input->post('nama', TRUE):null,
                    'pengelola' => ($this->input->post('pengelola', TRUE) != null)?$this->input->post('pengelola', TRUE):null,
                    'luas' => ($this->input->post('luas', TRUE) != null)?$this->input->post('luas', TRUE):null,
                    'bangun_harga' => ($this->input->post('bangun_harga', TRUE) != null)?$this->input->post('bangun_harga', TRUE):null,
                    'bangun_tanggal' => ($this->input->post('bangun_tanggal', TRUE) != null)?$this->input->post('bangun_tanggal', TRUE):null
                );
                $where = array(
                    'bangunan_id' => $bangunan_id
                );
                // selection jika lolos
                if($this->m_bangunan->update_bangunan($params, $where)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Diubah';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/bangunan');
                }
            }else{
                // validasi error
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Bangunan';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'bangunan/view_bangunan_edit';
        $this->display($data);
    }

    public function ajax_bangunan_delete($id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/bangunan/bangunan_delete_process/' . $id . '" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function bangunan_delete_process($id){
        // declare params
        $where = array(
            'bangunan_id' => de($id)
        );
        if ($this->m_bangunan->delete_bangunan($where)){
            $this->lnotifikasi->kirim_notification('success', 'Data berhasil dihapus');
            redirect(base_url().'logged/bangunan');           
        }
    }

    public function get_tanah_by_panti($panti_id){
        $rs_tanah = $this->m_bangunan->get_list_tanah_by_panti($panti_id);

        $html ='';
        $html .='<option value="">-- PILIH --</option>';
        foreach ($rs_tanah as $key => $value) {
          $html .='<option value="'.$value['tanah_id'].'">'.$value['tanah_id'].' - '.$value['nomor_sertifikat'].'</option>';
        }

        echo $html;
    }
}