<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Anak_asuh extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->load->model('logged/m_anak_asuh');
        // load library
        $this->load->library('pagination');
    }

	public function index(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/datatables/jquery.dataTables.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // search
        $search = $this->session->userdata('search_anak_asuh');
        $data['search'] = $search;
        // mempertimbangkan session panti_id untuk nama pantinya
        $session = $this->get_user_detail();
        // get nama panti dari detail
        $data['panti'] = $this->m_anak_asuh->get_detail_panti_by_id(array($session['panti_id']));
        $nama_anak_asuh = (empty($search['nama_anak_asuh']))? '%' : '%' . $search['nama_anak_asuh'] . '%' ;
        if (($session['hak_akses'] == 1) OR ($session['hak_akses'] == 2)){
            $panti_id = (empty($search['panti_id']))? '%' : $search['panti_id'];
        }else{
            $panti_id = $session['panti_id'];
        }
        // pagination
        $this->load->library('pagination'); 
        $config['base_url'] = base_url().'logged/anak_asuh/index/';
        $config['total_rows'] = $this->m_anak_asuh->get_total_anak_asuh(array($nama_anak_asuh, $panti_id));
        $config['uri_segment'] = 4;
        $config['per_page'] = 10;
        // tag open
        $config['full_tag_open'] = '<ul class="pagination pagination-sm pull-right">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['halaman'] = $this->pagination->create_links();
        // pagination attribute
        $start = $this->uri->segment(4, 0) + 1;
        $end = $this->uri->segment(4, 0) + $config['per_page'];
        $end = (($end > $config['total_rows']) ? $config['total_rows'] : $end);
        $data['start'] = ($config['total_rows'] == 0) ? 0 : $start;
        $data['end'] = $end;
        $data['total'] = $config['total_rows'];
        // data list panti
        $data['rs_anak_asuh'] = $this->m_anak_asuh->get_all_anak_asuh(array($nama_anak_asuh, $panti_id, ($start - 1), $config['per_page']));
        // list all kabupaten
        $data['rs_panti'] = $this->m_anak_asuh->get_list_panti();
        // tampilkan notifikasi
        $data['title'] = 'Anak Asuh';
        $data['template'] = 'anak_asuh/view_anak_asuh';
		$this->display($data);
	}

    public function pencarian(){
        // session
        if ($this->input->post('cari') == "search") {
            // params
            $params = array(
                "nama_anak_asuh" => $this->input->post('nama_anak_asuh', TRUE),
                "panti_id" => $this->input->post('panti_id', TRUE)
            );
            // set session
            $this->session->set_userdata("search_anak_asuh", $params);
        } else {
            // unset session
            $this->session->unset_userdata("search_anak_asuh");
        }
        // redirect
        redirect(base_url() . "logged/anak_asuh");
    }

    public function anak_asuh_add(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/select2/select2.js");
        // load css
        $data['load_css'] = $this->load_style("resource/themes/js/plugins/select2/select2.css");
        // LOAD DATA
        $data['rs_panti'] = $this->m_anak_asuh->get_list_panti();
        $data['rs_jenis_masalah'] = $this->m_anak_asuh->get_list_jenis_masalah();
        $data['rs_agama'] = $this->m_anak_asuh->get_list_agama();
        $data['rs_keadaan_ortu'] = $this->m_anak_asuh->get_list_keadaan_ortu();
        $data['rs_deskripsi_akta'] = $this->m_anak_asuh->get_list_deskripsi_akta();
        $data['rs_alasan_masuk_panti'] = $this->m_anak_asuh->get_list_alasan_masuk_panti();
        $data['rs_anak_asuh_tinggal'] = $this->m_anak_asuh->get_list_anak_asuh_tinggal();
        $data['rs_yang_mengasuh'] = $this->m_anak_asuh->get_list_yang_mengasuh();
        $session = $this->get_user_detail();
        $data['panti'] = $this->m_anak_asuh->get_detail_panti_by_id(array($session['panti_id']));
        // list all pmks
        $data['rs_pmks'] = $this->m_anak_asuh->get_all_pmks();
        // validation
        if ($this->input->post()) {
            // notifikasi selection
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('nama_anak_asuh', 'Nama Anak Asuh', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('nik', 'NIK', 'strip_tags|required|max_length[18]|callback_cek_nik');
            $this->form_validation->set_rules('jenis_kelamin', 'Jenis Kelamin', 'strip_tags|required');
            $this->form_validation->set_rules('tempat_lahir', 'Tempat Lahir', 'strip_tags|requiremax_length[100]');
            $this->form_validation->set_rules('tanggal_lahir', 'Tanggal Lahir', 'strip_tags|required');
            $this->form_validation->set_rules('jenjang_pendidikan', 'Jenjang Pendidikan', 'strip_tags|required');
            $this->form_validation->set_rules('nama_ibu', 'Nama Ibu', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('nama_ayah', 'Nama Ayah', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('alamat_orang_tua', 'Alamat Orang Tua', 'strip_tags|required');
            $this->form_validation->set_rules('agama_id', 'Agama', 'strip_tags|required');
            $this->form_validation->set_rules('status_bansos', 'Status Bansos', 'strip_tags|required');
            $this->form_validation->set_rules('nama_pendamping_bansos', 'Nama Pendamping Pencairan Bansos', 'strip_tags|required|max_length[255]');
            $this->form_validation->set_rules('anak_asuh_tinggal_id', 'Anak Asuh Tinggal', 'strip_tags|required');
            $this->form_validation->set_rules('jenis_masalah_id', ' Jenis Masalah Anak Asuh?', 'strip_tags|required');
            $this->form_validation->set_rules('keadaan_ortu_id', 'Keadaan Orang Tua', 'strip_tags|required');
            $this->form_validation->set_rules('deskripsi_akta_id', 'Memiliki Akta, apakah kami boleh melihatnya?', 'strip_tags|required');
            $this->form_validation->set_rules('alasan_masuk_panti_id', 'Alasan Masuk Panti?', 'strip_tags|required');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                // get li
                $params = array(
                    'nik' => $this->input->post('nik', TRUE),
                    'nama_anak_asuh' => $this->input->post('nama_anak_asuh', TRUE),
                    'jenis_kelamin' => $this->input->post('jenis_kelamin', TRUE),
                    'tempat_lahir' => $this->input->post('tempat_lahir', TRUE),
                    'tanggal_lahir' => $this->input->post('tanggal_lahir', TRUE),
                    'panti_id' => $this->input->post('panti_id', TRUE),
                    'jenjang_pendidikan' => $this->input->post('jenjang_pendidikan', TRUE),
                    'nama_ibu' => $this->input->post('nama_ibu', TRUE),
                    'nama_ayah' => $this->input->post('nama_ayah', TRUE),
                    'agama_id' => $this->input->post('agama_id', TRUE),
                    'alamat_orang_tua' => $this->input->post('alamat_orang_tua', TRUE),
                    'status_bansos' => $this->input->post('status_bansos', TRUE),
                    'nama_pendamping_bansos' => $this->input->post('nama_pendamping_bansos', TRUE),
                    'jenis_masalah_id' => $this->input->post('jenis_masalah_id', TRUE),
                    'keadaan_ortu_id' => $this->input->post('keadaan_ortu_id', TRUE),
                    'anak_asuh_tinggal_id' => $this->input->post('anak_asuh_tinggal_id', TRUE),
                    'deskripsi_akta_id' => $this->input->post('deskripsi_akta_id', TRUE),
                    'alasan_masuk_panti_id' => $this->input->post('alasan_masuk_panti_id', TRUE)
                );
                // selection jika lolos
                if($this->m_anak_asuh->insert_anak_asuh($params)){
                    $panti_id = (empty($session['panti_id']))? $this->input->post('panti_id', TRUE) :$session['panti_id'];
                    // update tabel panti
                    $params2 = array(
                        'aktivitas_terakhir' => 'Menambah data anak asuh',
                        'waktu_eksekusi' => date("Y-m-d H:i:s"),
                        'edited_by' => $this->session_detail['username']
                    );
                    $where2 = array(
                        'panti_id' => $panti_id
                    );
                    $this->m_anak_asuh->update_modifikasi($params2, $where2);
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasil Disimpan'; 
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/anak_asuh');
                }
            }else{
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors(); 
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }        
        // tampilkan notifikasi
        $data['title'] = 'Tambah Data Anak Asuh';
        $data['result'] = @$this->input->post();
        $data['template'] = 'anak_asuh/view_anak_asuh_add';
        $this->display($data);
    }


    public function anak_asuh_edit($anak_asuh_id = ''){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/select2/select2.js");
        // load css
        $data['load_css'] = $this->load_style("resource/themes/js/plugins/select2/select2.css");
        // LOAD DATA
        $result = $this->m_anak_asuh->get_anak_asuh_by_id(array(de($anak_asuh_id)));
        $data['rs_panti'] = $this->m_anak_asuh->get_list_panti();
        $data['rs_jenis_masalah'] = $this->m_anak_asuh->get_list_jenis_masalah();
        $data['rs_agama'] = $this->m_anak_asuh->get_list_agama();
        $data['rs_keadaan_ortu'] = $this->m_anak_asuh->get_list_keadaan_ortu();
        $data['rs_deskripsi_akta'] = $this->m_anak_asuh->get_list_deskripsi_akta();
        $data['rs_alasan_masuk_panti'] = $this->m_anak_asuh->get_list_alasan_masuk_panti();
        $data['rs_anak_asuh_tinggal'] = $this->m_anak_asuh->get_list_anak_asuh_tinggal();
        $data['rs_yang_mengasuh'] = $this->m_anak_asuh->get_list_yang_mengasuh();
        // list all pmks
        $data['rs_pmks'] = $this->m_anak_asuh->get_all_pmks();
        $data['anak_asuh_id'] = de($anak_asuh_id);
        $session = $this->get_user_detail();
        $data['panti'] = $this->m_anak_asuh->get_detail_panti_by_id(array($session['panti_id']));
        // validasi
        if ($this->input->post()) {
            // notifikasi selection
            $this->form_validation->set_rules('anak_asuh_id', 'Anak Ahus ID', 'strip_tags|required');
            $this->form_validation->set_rules('panti_id', 'Panti', 'strip_tags|required');
            $this->form_validation->set_rules('nama_anak_asuh', 'Nama Anak Asuh', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('nik', 'NIK', 'strip_tags|required|max_length[18]|callback_cek_nik');
            $this->form_validation->set_rules('jenis_kelamin', 'Jenis Kelamin', 'strip_tags|required');
            $this->form_validation->set_rules('tempat_lahir', 'Tempat Lahir', 'strip_tags|requiremax_length[100]');
            $this->form_validation->set_rules('tanggal_lahir', 'Tanggal Lahir', 'strip_tags|required');
            $this->form_validation->set_rules('jenjang_pendidikan', 'Jenjang Pendidikan', 'strip_tags|required');
            $this->form_validation->set_rules('nama_ibu', 'Nama Ibu', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('nama_ayah', 'Nama Ayah', 'strip_tags|required|max_length[100]');
            $this->form_validation->set_rules('alamat_orang_tua', 'Alamat Orang Tua', 'strip_tags|required');
            $this->form_validation->set_rules('agama_id', 'Agama', 'strip_tags|required');
            $this->form_validation->set_rules('status_bansos', 'Status Bansos', 'strip_tags|required');
            $this->form_validation->set_rules('nama_pendamping_bansos', 'Nama Pendamping Pencairan Bansos', 'strip_tags|required|max_length[255]');
            $this->form_validation->set_rules('anak_asuh_tinggal_id', 'Anak Asuh Tinggal', 'strip_tags|required');
            $this->form_validation->set_rules('jenis_masalah_id', ' Jenis Masalah Anak Asuh?', 'strip_tags|required');
            $this->form_validation->set_rules('keadaan_ortu_id', 'Keadaan Orang Tua', 'strip_tags|required');
            $this->form_validation->set_rules('deskripsi_akta_id', 'Memiliki Akta, apakah kami boleh melihatnya?', 'strip_tags|required');
            $this->form_validation->set_rules('alasan_masuk_panti_id', 'Alasan Masuk Panti?', 'strip_tags|required');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                $params = array(
                    'nik' => $this->input->post('nik', TRUE),
                    'nama_anak_asuh' => $this->input->post('nama_anak_asuh', TRUE),
                    'jenis_kelamin' => $this->input->post('jenis_kelamin', TRUE),
                    'tempat_lahir' => $this->input->post('tempat_lahir', TRUE),
                    'tanggal_lahir' => $this->input->post('tanggal_lahir', TRUE),
                    'panti_id' => $this->input->post('panti_id', TRUE),
                    'jenjang_pendidikan' => $this->input->post('jenjang_pendidikan', TRUE),
                    'nama_ibu' => $this->input->post('nama_ibu', TRUE),
                    'nama_ayah' => $this->input->post('nama_ayah', TRUE),
                    'agama_id' => $this->input->post('agama_id', TRUE),
                    'alamat_orang_tua' => $this->input->post('alamat_orang_tua', TRUE),
                    'status_bansos' => $this->input->post('status_bansos', TRUE),
                    'nama_pendamping_bansos' => $this->input->post('nama_pendamping_bansos', TRUE),
                    'jenis_masalah_id' => $this->input->post('jenis_masalah_id', TRUE),
                    'keadaan_ortu_id' => $this->input->post('keadaan_ortu_id', TRUE),
                    'anak_asuh_tinggal_id' => $this->input->post('anak_asuh_tinggal_id', TRUE),
                    'deskripsi_akta_id' => $this->input->post('deskripsi_akta_id', TRUE),
                    'alasan_masuk_panti_id' => $this->input->post('alasan_masuk_panti_id', TRUE)
                );
                $where = array(
                    'anak_asuh_id' => de($this->input->post('anak_asuh_id', TRUE))
                );
                // selection jika lolos
                if($this->m_anak_asuh->update_anak_asuh($params, $where)){
                    $panti_id = (empty($session['panti_id']))? $this->input->post('panti_id', TRUE) :$session['panti_id'];
                    // update tabel panti
                    $params2 = array(
                        'aktivitas_terakhir' => 'Mengubah data anak asuh',
                        'waktu_eksekusi' => date("Y-m-d H:i:s"),
                        'edited_by' => $this->session_detail['username']
                    );
                    $where2 = array(
                        'panti_id' => $panti_id
                    );
                    $this->m_anak_asuh->update_modifikasi($params2, $where2);
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data Berhasi Disimpan'; 
                    $this->session->set_userdata('notifikasi',$notifikasi);
                    redirect(base_url().'logged/anak_asuh/');
                }
            }else{
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors(); 
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // tampilkan notifikasi
        $data['title'] = 'Ubah Data Anak Asuh';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'anak_asuh/view_anak_asuh_edit';
        $this->display($data);
    }

    public function ajax_anak_asuh_delete($anak_asuh_id = '', $panti_id = ''){
        // header
        header('Content-Type: application/json');
        $data = array(
            'link_delete' => '<a href="' . base_url() . 'logged/anak_asuh/anak_asuh_delete_process/' . $anak_asuh_id . '/'.$panti_id.'" class="btn btn-success btn-lg">Yes</a>'
        );
        $return = json_encode($data);
        echo $return;
    }

    public function anak_asuh_delete_process($anak_asuh_id, $param_panti_id){
        // declare params
        $where = array(
            'anak_asuh_id' => de($anak_asuh_id)
        );
        if ($this->m_anak_asuh->delete_anak_asuh($where)){
            $panti_id = (empty($session['panti_id']))? de($param_panti_id) :$session['panti_id'];
            // update tabel panti
            $params2 = array(
                'aktivitas_terakhir' => 'Menghapus data anak asuh',
                'waktu_eksekusi' => date("Y-m-d H:i:s"),
                'edited_by' => $this->session_detail['username']
            );
            $where2 = array(
                'panti_id' => $panti_id
            );
            $this->m_anak_asuh->update_modifikasi($params2, $where2);
            $notifikasi['notification_header'] = 'success';
            $notifikasi['notification_message'] = 'Data Berhasi Dihapus'; 
            $this->session->set_userdata('notifikasi',$notifikasi);
            redirect(base_url().'logged/anak_asuh');           
        }
    }

    public function cek_nik(){
        $result = $this->m_anak_asuh->get_anak_asuh_by_id(array($this->input->post('nik', TRUE)));
        if ($result) {
            $this->form_validation->set_message('cek_nik', 'Data NIK telah terdaftar!');
            return FALSE;
        }else{
            return TRUE;
        }
    }
}