<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
// load base class if needed
require_once( APPPATH . 'controllers/AdminBase/AppLoggedBase.php' );

class Account extends LoggedBase{

    // constructor
    public function __construct() {
        // parent constructor
        parent::__construct();
        // load library
        $this->access_right(array(1,2,3));
        $this->load->model('login/m_account');
        $this->load->library('form_validation');
        // set title
    }

	public function index(){
        // load js
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/icheck/icheck.min.js");  
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-datepicker.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-file-input.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/bootstrap/bootstrap-select.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins/tagsinput/jquery.tagsinput.min.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/settings.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/plugins.js");
        $data['load_js'] = $this->load_javascript("resource/themes/js/actions.js");
        // data akun
        // notifikasi selection
        if ($this->input->post()) {
            $this->form_validation->set_rules('id', 'ID', 'strip_tags|required|max_length[60]');
            $this->form_validation->set_rules('nama', 'Nama Lengkap', 'strip_tags|required|max_length[60]|callback_check_existing_username');
            $this->form_validation->set_rules('username', 'Username', 'strip_tags|required|max_length[60]');
            $this->form_validation->set_rules('password', 'Password', 'strip_tags|max_length[60]|callback_check_password');
            $this->form_validation->set_rules('re_password', 'Ulangi Password', 'strip_tags|max_length[60]');
            $this->form_validation->set_rules('alamat', 'Alamat', 'strip_tags|required');
            $this->form_validation->set_rules('email', 'E-mail', 'strip_tags|required|valid_email');
            // selectiion
            if ($this->form_validation->run() !== FALSE){
                // pemrosesan password
                $password = $this->input->post('password', TRUE);
                $re_password = $this->input->post('re_password', TRUE);
                if (($password != NULL) AND ($re_password != NULL)) {
                    $params = array(
                        'username' => $this->input->post('username', TRUE),
                        'nama' => $this->input->post('nama', TRUE),
                        'password' => md5($password),
                        'alamat' => $this->input->post('alamat', TRUE),
                        'email' => $this->input->post('email', TRUE)
                    );
                }else{
                    $params = array(
                        'username' => $this->input->post('username', TRUE),
                        'nama' => $this->input->post('nama', TRUE),
                        'alamat' => $this->input->post('alamat', TRUE),
                        'email' => $this->input->post('email', TRUE)
                    );
                }
                $where = array(
                    'id' => $this->input->post('id', TRUE)
                );
                // selection jika lolos
                if($this->m_account->update_account($params, $where)){
                    $notifikasi['notification_header'] = 'success';
                    $notifikasi['notification_message'] = 'Data berhasil disimpan';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                }else{
                    $notifikasi['notification_header'] = 'error';
                    $notifikasi['notification_message'] = 'Data gagal disimpan';
                    $this->session->set_userdata('notifikasi',$notifikasi);
                }
            }else{
                $notifikasi['notification_header'] = 'error';
                $notifikasi['notification_error'] = validation_errors();
                $this->session->set_userdata('notifikasi',$notifikasi);
            }
        }
        // data akun
        $sess = $this->get_user_detail();
        $params = $sess['id'];
        $data_user = $this->m_account->get_user_detail(array($params));
        $result = ($this->input->post() == NULL)?$data_user:$this->input->post();
        // tampilkan notifikasi
        $data['title'] = 'Account';
        $data['result'] = $result;
        $data['data'] = $result;
        $data['template'] = 'admin/account';
        $this->display($data);
	}

    // for form validation
    public function check_existing_username(){
        $username = $this->input->post('username', TRUE);
        $data = $this->m_account->get_existing_username_by_input(array($username));
        if (($data) AND ($data['username'] != $this->user_detail['username'])){
            $this->form_validation->set_message('check_existing_username', 'Data Username telah terdaftar!');
            return FALSE;
        }else{
            return TRUE;
        }
    }

    public function check_password(){
        if(($this->input->post('password') != $this->input->post('re_password'))){
            $this->form_validation->set_message('check_password', 'Isian Password dan Ulangi Password harus diisi dengan isian yang sama!');
            return FALSE;
        }else{
            return TRUE;
        }
    }
}