<?php

class LoginBase extends CI_Controller{

    protected $set_portal;
    protected $set_user;

    public function __construct() {
        // load basic controller
        parent::__construct();
        // load app data
        // $this->base_load_app();
        // view app data
        // $this->base_view_app();
        $this->load->library('lnotifikasi');
        $this->output->set_header('Last-Modified: ' . gmdate("D, d M Y H:i:s") . ' GMT');('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
        $this->output->set_header('Pragma: no-cache');
        $this->output->set_header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    }

    public function base_load_app(){
        // load javascript
        // $this->load_javascript("resource/themes/default/plugins/js/jquery-2.2.4.min.js");
        // $this->load_javascript("resource/themes/default/plugins/js/bootstrap.min.js");
        // $this->load_javascript("resource/themes/default/plugins/js/nifty.js");
    }

    public function base_view_app(){
    	
    }

    public function display($template = '', $data){
        // MERGE MORE THAN ONE ARRAY
        // $params = array_merge($data);
    	$this->load->view($template, $data);
    }

    public function load_javascript($path) {
        if(is_file($path)) {
            $this->javascript .= '<script type="text/javascript" src="' . base_url() . $path . '"></script>';
            $this->javascript .= "\n";
            // assign
            return $this->javascript;
        }else {
            $msg = "File berikut ini tidak ditemukan : " . base_url() . $path;
            show_error($msg, 404);
        }
    }

    public function load_style($css_file, $media = "all") {
        // assign
        if(is_file($css_file)) {
            $this->style .= '<link rel="stylesheet" type="text/css" href="' . base_url() . $css_file . '" media="' . $media . '" />';
            $this->style .= "\n";
            // assign
            return $this->style;
        }else {
            $msg = "File berikut ini tidak ditemukan : " . base_url() . $css_file;
            show_error($msg, 404);
        }
    }
}