<?php

class LoggedBase extends CI_Controller{

    protected $set_portal;
    protected $set_user;
    public $user_detail;

    public function __construct() {
        // load basic controller
        parent::__construct();
        // load library
        $this->load->library('session');
        $this->load->library('keamanan');
        $this->load->library('lnotifikasi');
        $this->load->library('form_validation');
        $this->load->library('datemanipulation');
        // load app data
        $this->session_check();
        $this->session_detail = $this->get_user_detail();
        // cek sessionnya FALSE
        $this->ses_enable = $this->session->userdata('mpspwmdiy_system');
    }

    public function session_check(){
        $this->user_detail = $this->get_user_detail();
        // cek sessionnya FALSE
        $ses_enable = $this->session->userdata('mpspwmdiy_system');
        if ($ses_enable['logged'] != TRUE){
            // redirect ke halaman login
            $this->logout();
            redirect(base_url().'login/login');
        }
    }

    public function access_right($params = null){
        if (!in_array($this->ses_enable['hak_akses'], $params)) {
            // redirect ke halaman login
            $this->logout();
            redirect(base_url().'login/login');
        }
    }

    public function side_bar(){
    	// array untuk data main
        // pengaturan menu untuk hak akses super admin
        if ($this->user_detail['hak_akses'] == 1) {
            $main = array(
                'dashboard' => array(
                    'link' => base_url().'logged/dashboard',
                    'awesome' => 'fa-desktop',
                    'title' => 'Dashboard'
                ),
                'account' => array(
                    'link' => base_url().'logged/account',
                    'awesome' => 'fa-user',
                    'title' => 'Account'
                ),
                'manage_account' => array(
                    'link' => base_url().'logged/manage_account',
                    'awesome' => 'fa-users',
                    'title' => 'Manage Account'
                )
            );
            $panti = array(
                'master' => array(
                    'link' => '#',
                    'awesome' => 'fa-table',
                    'title' => 'Master Data Panti',
                    'sub' => array(
                        'alasan_masuk_panti' => array(
                            'link' => base_url().'logged/master/alasan_masuk_panti',
                            'awesome' => '',
                            'title' => 'Alasan Masuk Panti',
                            'sub' => NULL
                        ),
                        'anak_asuh_tinggal' => array(
                            'link' => base_url().'logged/master/anak_asuh_tinggal',
                            'awesome' => '',
                            'title' => 'Anak Asuh Tinggal',
                            'sub' => NULL
                        ),
                        'deskripsi_akta' => array(
                            'link' => base_url().'logged/master/deskripsi_akta',
                            'awesome' => '',
                            'title' => 'Deskripsi Akta',
                            'sub' => NULL
                        ),
                        'keadaan_ortu' => array(
                            'link' => base_url().'logged/master/keadaan_ortu',
                            'awesome' => '',
                            'title' => 'Keadaan Orang Tua',
                            'sub' => NULL
                        ),
                        'yang_mengasuh' => array(
                            'link' => base_url().'logged/master/yang_mengasuh',
                            'awesome' => '',
                            'title' => 'Yang Mengasuh',
                            'sub' => NULL
                        ),
                        'jenis_masalah' => array(
                            'link' => base_url().'logged/master/jenis_masalah',
                            'awesome' => '',
                            'title' => 'Jenis Masalah',
                            'sub' => NULL
                        ),
                        'pendidikan' => array(
                            'link' => base_url().'logged/master/pendidikan',
                            'awesome' => '',
                            'title' => 'Pendidikan',
                            'sub' => NULL
                        ),
                        'agama' => array(
                            'link' => base_url().'logged/master/agama',
                            'awesome' => '',
                            'title' => 'Agama',
                            'sub' => NULL
                        ),
                        'status_kepegawaian' => array(
                            'link' => base_url().'logged/master/status_kepegawaian',
                            'awesome' => '',
                            'title' => 'Status Kepegawaian',
                            'sub' => NULL
                        ),
                        'jenis_sertifikat' => array(
                            'link' => base_url().'logged/master/jenis_sertifikat',
                            'awesome' => '',
                            'title' => 'Jenis Sertifikat',
                            'sub' => NULL
                        ),
                        'bangunan_bidang' => array(
                            'link' => base_url().'logged/master/bangunan_bidang',
                            'awesome' => '',
                            'title' => 'Bidang Bangunan',
                            'sub' => NULL
                        ),
                        'bangunan_kategori' => array(
                            'link' => base_url().'logged/master/bangunan_kategori',
                            'awesome' => '',
                            'title' => 'Kategori Bangunan',
                            'sub' => NULL
                        ),
                        'tanah_perolehan' => array(
                            'link' => base_url().'logged/master/tanah_perolehan',
                            'awesome' => '',
                            'title' => 'Perolehan Tanah',
                            'sub' => NULL
                        ),
                        'tanah_status' => array(
                            'link' => base_url().'logged/master/tanah_status',
                            'awesome' => '',
                            'title' => 'Status Tanah',
                            'sub' => NULL
                        ),
                        'jenis_barang' => array(
                            'link' => base_url().'logged/master/jenis_barang',
                            'awesome' => '',
                            'title' => 'Jenis Barang',
                            'sub' => NULL
                        ),
                        'kondisi_barang' => array(
                            'link' => base_url().'logged/master/kondisi_barang',
                            'awesome' => '',
                            'title' => 'Kondisi Barang',
                            'sub' => NULL
                        ),
                        'perolehan_barang' => array(
                            'link' => base_url().'logged/master/perolehan_barang',
                            'awesome' => '',
                            'title' => 'Perolehan Barang',
                            'sub' => NULL
                        )       
                    )
                ),
                'panti' => array(
                    'link' => base_url().'logged/panti',
                    'awesome' => 'fa-home',
                    'title' => 'Panti',
                    'sub' => NULL
                ),
                'pengasuh' => array(
                    'link' => base_url().'logged/pengasuh',
                    'awesome' => 'fa-user',
                    'title' => 'Pengasuh',
                    'sub' => NULL
                ),
                'anak_asuh' => array(
                    'link' => base_url().'logged/anak_asuh',
                    'awesome' => 'fa-group',
                    'title' => 'Anak Asuh',
                    'sub' => NULL
                ),
                'asset' => array(
                    'link' => '#',
                    'awesome' => 'fa-table',
                    'title' => 'Asset',
                    'sub' => array(
                        'asset_tanah' => array(
                            'link' => base_url().'logged/tanah',
                            'awesome' => '',
                            'title' => 'Tanah',
                            'sub' => NULL
                        ),
                        'asset_bangunan' => array(
                            'link' => base_url().'logged/bangunan',
                            'awesome' => '',
                            'title' => 'Bangunan',
                            'sub' => NULL
                        ),
                        'asset_ruang' => array(
                            'link' => base_url().'logged/ruang',
                            'awesome' => '',
                            'title' => 'Ruang',
                            'sub' => NULL
                        ),
                        'asset_barang' => array(
                            'link' => base_url().'logged/barang',
                            'awesome' => '',
                            'title' => 'Barang',
                            'sub' => NULL
                        ),
                        'asset_kendaraan' => array(
                            'link' => base_url().'logged/kendaraan',
                            'awesome' => '',
                            'title' => 'Kendaraan',
                            'sub' => NULL
                        )  
                    )
                ),
                'kab_stat' => array(
                    'link' => '#',
                    'awesome' => 'fa-table',
                    'title' => 'Statistik',
                    'sub' => array(
                        'kab_stat_panti' => array(
                            'link' => base_url().'logged/kab_stat/kab_stat_panti',
                            'awesome' => '',
                            'title' => 'Statistik Panti Se-DIY',
                            'sub' => NULL
                        ),
                        'kab_stat_anak_asuh' => array(
                            'link' => base_url().'logged/kab_stat/kab_stat_anak_asuh',
                            'awesome' => '',
                            'title' => 'Statistik Anak Asuh Se-DIY',
                            'sub' => NULL
                        )  
                    )
                ),
                'cetak' => array(
                    'link' => base_url().'logged/cetak',
                    'awesome' => 'fa-print',
                    'title' => 'Cetak'
                )   
            );
            // array untuk data master
            // $master = array(
            //     'master' => array(
            //         'link' => '#',
            //         'awesome' => 'fa-table',
            //         'title' => 'Master Data Keuangan',
            //         'sub' => array(
            //             'saldo_awal_rekening' => array(
            //                 'link' => base_url().'logged/master/saldo_awal_rekening',
            //                 'awesome' => '',
            //                 'title' => 'Saldo Awal Rekening',
            //                 'sub' => NULL
            //             ),
            //             'rekening_kas_bank' => array(
            //                 'link' => base_url().'logged/master/rekening_kas_bank',
            //                 'awesome' => '',
            //                 'title' => 'Rekening Kas Bank',
            //                 'sub' => NULL
            //             ),
            //             'pola_jurnal' => array(
            //                 'link' => base_url().'logged/master/pola_jurnal',
            //                 'awesome' => '',
            //                 'title' => 'Pola Jurnal',
            //                 'sub' => NULL
            //             ),
            //             'aktiva' => array(
            //                 'link' => base_url().'logged/master/aktiva',
            //                 'awesome' => '',
            //                 'title' => 'Aktiva',
            //                 'sub' => NULL
            //             ),
            //             'akumulasi_penyusutan' => array(
            //                 'link' => base_url().'logged/master/akumulasi_penyusutan',
            //                 'awesome' => '',
            //                 'title' => 'Akun Akum. Penyusutan',
            //                 'sub' => NULL
            //             ),
            //             'biaya_penyusutan' => array(
            //                 'link' => base_url().'logged/master/biaya_penyusutan',
            //                 'awesome' => '',
            //                 'title' => 'Akun Biaya Penyusutan',
            //                 'sub' => NULL
            //             )    
            //         )
            //     ),
            //     'bantuan' => array(
            //         'link' => '#',
            //         'awesome' => 'fa-sign-out',
            //         'title' => 'Bantuan',
            //         'sub' => array(
            //             'donatur' => array(
            //                 'link' => base_url().'logged/bantuan/donatur',
            //                 'awesome' => '',
            //                 'title' => 'Donatur',
            //                 'sub' => NULL
            //             ),
            //             'bantuan_uang' => array(
            //                 'link' => base_url().'logged/bantuan/bantuan_uang',
            //                 'awesome' => '',
            //                 'title' => 'Bantuan Uang',
            //                 'sub' => NULL
            //             ),
            //             'barang_persediaan' => array(
            //                 'link' => base_url().'logged/bantuan/barang_persediaan',
            //                 'awesome' => '',
            //                 'title' => 'Barang Persediaan',
            //                 'sub' => NULL
            //             ),
            //             'aktiva_tetap' => array(
            //                 'link' => base_url().'logged/bantuan/aktiva_tetap',
            //                 'awesome' => '',
            //                 'title' => 'Aktiva Tetap',
            //                 'sub' => NULL
            //             ) 
            //         )
            //     ),
            //     'transaksi' => array(
            //         'link' => '#',
            //         'awesome' => 'fa-exchange',
            //         'title' => 'Transaksi',
            //         'sub' => array(
            //             'donatur' => array(
            //                 'link' => base_url().'logged/transaksi/pegawai',
            //                 'awesome' => '',
            //                 'title' => 'Pegawai',
            //                 'sub' => NULL
            //             ),
            //             'penerimaan' => array(
            //                 'link' => base_url().'logged/transaksi/penerimaan',
            //                 'awesome' => '',
            //                 'title' => 'Penerimaan',
            //                 'sub' => NULL
            //             ),
            //             'pengeluaran' => array(
            //                 'link' => base_url().'logged/transaksi/pengeluaran',
            //                 'awesome' => '',
            //                 'title' => 'Pengeluaran',
            //                 'sub' => NULL
            //             ),
            //             'uang_muka' => array(
            //                 'link' => base_url().'logged/transaksi/uang_muka',
            //                 'awesome' => '',
            //                 'title' => 'Uang Muka',
            //                 'sub' => NULL
            //             ),
            //             'pertanggungjawaban_uang_muka' => array(
            //                 'link' => base_url().'logged/transaksi/pertanggungjawaban_uang_muka',
            //                 'awesome' => '',
            //                 'title' => 'PJ. Uang Muka',
            //                 'sub' => NULL
            //             ) 
            //         )
            //     )                 
            // );
        }
        if ($this->user_detail['hak_akses'] == 2) {
            $main = array(
                'dashboard' => array(
                    'link' => base_url().'logged/dashboard',
                    'awesome' => 'fa-desktop',
                    'title' => 'Dashboard'
                ),
                'account' => array(
                    'link' => base_url().'logged/account',
                    'awesome' => 'fa-user',
                    'title' => 'Account'
                )
            );
            $panti = array(
                'master' => array(
                    'link' => '#',
                    'awesome' => 'fa-table',
                    'title' => 'Master Data Panti',
                    'sub' => array(
                        'alasan_masuk_panti' => array(
                            'link' => base_url().'logged/master/alasan_masuk_panti',
                            'awesome' => '',
                            'title' => 'Alasan Masuk Panti',
                            'sub' => NULL
                        ),
                        'anak_asuh_tinggal' => array(
                            'link' => base_url().'logged/master/anak_asuh_tinggal',
                            'awesome' => '',
                            'title' => 'Anak Asuh Tinggal',
                            'sub' => NULL
                        ),
                        'deskripsi_akta' => array(
                            'link' => base_url().'logged/master/deskripsi_akta',
                            'awesome' => '',
                            'title' => 'Deskripsi Akta',
                            'sub' => NULL
                        ),
                        'keadaan_ortu' => array(
                            'link' => base_url().'logged/master/keadaan_ortu',
                            'awesome' => '',
                            'title' => 'Keadaan Orang Tua',
                            'sub' => NULL
                        ),
                        'yang_mengasuh' => array(
                            'link' => base_url().'logged/master/yang_mengasuh',
                            'awesome' => '',
                            'title' => 'Yang Mengasuh',
                            'sub' => NULL
                        ),
                        'jenis_masalah' => array(
                            'link' => base_url().'logged/master/jenis_masalah',
                            'awesome' => '',
                            'title' => 'Jenis Masalah',
                            'sub' => NULL
                        ),
                        'pendidikan' => array(
                            'link' => base_url().'logged/master/pendidikan',
                            'awesome' => '',
                            'title' => 'Pendidikan',
                            'sub' => NULL
                        ),
                        'agama' => array(
                            'link' => base_url().'logged/master/agama',
                            'awesome' => '',
                            'title' => 'Agama',
                            'sub' => NULL
                        ),
                        'status_kepegawaian' => array(
                            'link' => base_url().'logged/master/status_kepegawaian',
                            'awesome' => '',
                            'title' => 'Status Kepegawaian',
                            'sub' => NULL
                        ),
                        'jenis_sertifikat' => array(
                            'link' => base_url().'logged/master/jenis_sertifikat',
                            'awesome' => '',
                            'title' => 'Jenis Sertifikat',
                            'sub' => NULL
                        ),
                        'bangunan_bidang' => array(
                            'link' => base_url().'logged/master/bangunan_bidang',
                            'awesome' => '',
                            'title' => 'Bidang Bangunan',
                            'sub' => NULL
                        ),
                        'bangunan_kategori' => array(
                            'link' => base_url().'logged/master/bangunan_kategori',
                            'awesome' => '',
                            'title' => 'Kategori Bangunan',
                            'sub' => NULL
                        ),
                        'tanah_perolehan' => array(
                            'link' => base_url().'logged/master/tanah_perolehan',
                            'awesome' => '',
                            'title' => 'Perolehan Tanah',
                            'sub' => NULL
                        ),
                        'tanah_status' => array(
                            'link' => base_url().'logged/master/tanah_status',
                            'awesome' => '',
                            'title' => 'Status Tanah',
                            'sub' => NULL
                        ),
                        'jenis_barang' => array(
                            'link' => base_url().'logged/master/jenis_barang',
                            'awesome' => '',
                            'title' => 'Jenis Barang',
                            'sub' => NULL
                        ),
                        'kondisi_barang' => array(
                            'link' => base_url().'logged/master/kondisi_barang',
                            'awesome' => '',
                            'title' => 'Kondisi Barang',
                            'sub' => NULL
                        ),
                        'perolehan_barang' => array(
                            'link' => base_url().'logged/master/perolehan_barang',
                            'awesome' => '',
                            'title' => 'Perolehan Barang',
                            'sub' => NULL
                        )      
                    )
                ),
                'panti' => array(
                    'link' => base_url().'logged/panti',
                    'awesome' => 'fa-home',
                    'title' => 'Panti',
                    'sub' => NULL
                ),
                'pengasuh' => array(
                    'link' => base_url().'logged/pengasuh',
                    'awesome' => 'fa-user',
                    'title' => 'Pengasuh',
                    'sub' => NULL
                ),
                'anak_asuh' => array(
                    'link' => base_url().'logged/anak_asuh',
                    'awesome' => 'fa-group',
                    'title' => 'Anak Asuh',
                    'sub' => NULL
                ),
                'asset' => array(
                    'link' => '#',
                    'awesome' => 'fa-table',
                    'title' => 'Asset',
                    'sub' => array(
                        'asset_tanah' => array(
                            'link' => base_url().'logged/tanah',
                            'awesome' => '',
                            'title' => 'Tanah',
                            'sub' => NULL
                        ),
                        'asset_bangunan' => array(
                            'link' => base_url().'logged/bangunan',
                            'awesome' => '',
                            'title' => 'Bangunan',
                            'sub' => NULL
                        ),
                        'asset_ruang' => array(
                            'link' => base_url().'logged/ruang',
                            'awesome' => '',
                            'title' => 'Ruang',
                            'sub' => NULL
                        ),
                        'asset_barang' => array(
                            'link' => base_url().'logged/barang',
                            'awesome' => '',
                            'title' => 'Barang',
                            'sub' => NULL
                        ),
                        'asset_kendaraan' => array(
                            'link' => base_url().'logged/kendaraan',
                            'awesome' => '',
                            'title' => 'Kendaraan',
                            'sub' => NULL
                        ) 
                    )
                ),
                'kab_stat' => array(
                    'link' => '#',
                    'awesome' => 'fa-table',
                    'title' => 'Statistik',
                    'sub' => array(
                        'kab_stat_panti' => array(
                            'link' => base_url().'logged/kab_stat/kab_stat_panti',
                            'awesome' => '',
                            'title' => 'Statistik Panti',
                            'sub' => NULL
                        ),
                        'kab_stat_anak_asuh' => array(
                            'link' => base_url().'logged/kab_stat/kab_stat_anak_asuh',
                            'awesome' => '',
                            'title' => 'Statistik Anak Asuh',
                            'sub' => NULL
                        )  
                    )
                ),
                'cetak' => array(
                    'link' => base_url().'logged/cetak',
                    'awesome' => 'fa-print',
                    'title' => 'Cetak'
                )   
            );
            // array untuk data master
            // $master = array(
            //     'master' => array(
            //         'link' => '#',
            //         'awesome' => 'fa-table',
            //         'title' => 'Master Data Keuangan',
            //         'sub' => array(
            //             'saldo_awal_rekening' => array(
            //                 'link' => base_url().'logged/master/saldo_awal_rekening',
            //                 'awesome' => '',
            //                 'title' => 'Saldo Awal Rekening',
            //                 'sub' => NULL
            //             ),
            //             'rekening_kas_bank' => array(
            //                 'link' => base_url().'logged/master/rekening_kas_bank',
            //                 'awesome' => '',
            //                 'title' => 'Rekening Kas Bank',
            //                 'sub' => NULL
            //             ),
            //             'pola_jurnal' => array(
            //                 'link' => base_url().'logged/master/pola_jurnal',
            //                 'awesome' => '',
            //                 'title' => 'Pola Jurnal',
            //                 'sub' => NULL
            //             ),
            //             'aktiva' => array(
            //                 'link' => base_url().'logged/master/aktiva',
            //                 'awesome' => '',
            //                 'title' => 'Aktiva',
            //                 'sub' => NULL
            //             ),
            //             'akumulasi_penyusutan' => array(
            //                 'link' => base_url().'logged/master/akumulasi_penyusutan',
            //                 'awesome' => '',
            //                 'title' => 'Akun Akum. Penyusutan',
            //                 'sub' => NULL
            //             ),
            //             'biaya_penyusutan' => array(
            //                 'link' => base_url().'logged/master/biaya_penyusutan',
            //                 'awesome' => '',
            //                 'title' => 'Akun Biaya Penyusutan',
            //                 'sub' => NULL
            //             )    
            //         )
            //     ),
            //     'bantuan' => array(
            //         'link' => '#',
            //         'awesome' => 'fa-sign-out',
            //         'title' => 'Bantuan',
            //         'sub' => array(
            //             'donatur' => array(
            //                 'link' => base_url().'logged/bantuan/donatur',
            //                 'awesome' => '',
            //                 'title' => 'Donatur',
            //                 'sub' => NULL
            //             ),
            //             'bantuan_uang' => array(
            //                 'link' => base_url().'logged/bantuan/bantuan_uang',
            //                 'awesome' => '',
            //                 'title' => 'Bantuan Uang',
            //                 'sub' => NULL
            //             ),
            //             'barang_persediaan' => array(
            //                 'link' => base_url().'logged/bantuan/barang_persediaan',
            //                 'awesome' => '',
            //                 'title' => 'Barang Persediaan',
            //                 'sub' => NULL
            //             ),
            //             'aktiva_tetap' => array(
            //                 'link' => base_url().'logged/bantuan/aktiva_tetap',
            //                 'awesome' => '',
            //                 'title' => 'Aktiva Tetap',
            //                 'sub' => NULL
            //             ) 
            //         )
            //     ),
            //     'transaksi' => array(
            //         'link' => '#',
            //         'awesome' => 'fa-exchange',
            //         'title' => 'Transaksi',
            //         'sub' => array(
            //             'donatur' => array(
            //                 'link' => base_url().'logged/transaksi/pegawai',
            //                 'awesome' => '',
            //                 'title' => 'Pegawai',
            //                 'sub' => NULL
            //             ),
            //             'penerimaan' => array(
            //                 'link' => base_url().'logged/transaksi/penerimaan',
            //                 'awesome' => '',
            //                 'title' => 'Penerimaan',
            //                 'sub' => NULL
            //             ),
            //             'pengeluaran' => array(
            //                 'link' => base_url().'logged/transaksi/pengeluaran',
            //                 'awesome' => '',
            //                 'title' => 'Pengeluaran',
            //                 'sub' => NULL
            //             ),
            //             'uang_muka' => array(
            //                 'link' => base_url().'logged/transaksi/uang_muka',
            //                 'awesome' => '',
            //                 'title' => 'Uang Muka',
            //                 'sub' => NULL
            //             ),
            //             'pertanggungjawaban_uang_muka' => array(
            //                 'link' => base_url().'logged/transaksi/pertanggungjawaban_uang_muka',
            //                 'awesome' => '',
            //                 'title' => 'PJ. Uang Muka',
            //                 'sub' => NULL
            //             ) 
            //         )
            //     )                 
            // );
        }
        if ($this->user_detail['hak_akses'] == 3) {
            $main = array(
                'dashboard' => array(
                    'link' => base_url().'logged/dashboard',
                    'awesome' => 'fa-desktop',
                    'title' => 'Dashboard'
                ),
                'account' => array(
                    'link' => base_url().'logged/account',
                    'awesome' => 'fa-user',
                    'title' => 'Account'
                ) 
            );
            $panti = array(
                'panti' => array(
                    'link' => base_url().'logged/panti',
                    'awesome' => 'fa-home',
                    'title' => 'Panti',
                    'sub' => NULL
                ),
                'pengasuh' => array(
                    'link' => base_url().'logged/pengasuh',
                    'awesome' => 'fa-user',
                    'title' => 'Pengasuh',
                    'sub' => NULL
                ),
                'anak_asuh' => array(
                    'link' => base_url().'logged/anak_asuh',
                    'awesome' => 'fa-group',
                    'title' => 'Anak Asuh',
                    'sub' => NULL
                ),
                'kab_stat' => array(
                    'link' => '#',
                    'awesome' => 'fa-table',
                    'title' => 'Statistik',
                    'sub' => array(
                        'stat_panti' => array(
                            'link' => base_url().'logged/kab_stat/stat_panti',
                            'awesome' => '',
                            'title' => 'Statistik Panti',
                            'sub' => NULL
                        ) 
                    )
                ),                
                'cetak' => array(
                    'link' => base_url().'logged/cetak',
                    'awesome' => 'fa-print',
                    'title' => 'Cetak'
                )                 
            );
            // array untuk data master
            // $master = array(
            //     'bantuan' => array(
            //         'link' => '#',
            //         'awesome' => 'fa-sign-out',
            //         'title' => 'Bantuan',
            //         'sub' => array(
            //             'donatur' => array(
            //                 'link' => base_url().'logged/bantuan/donatur',
            //                 'awesome' => '',
            //                 'title' => 'Donatur',
            //                 'sub' => NULL
            //             ),
            //             'bantuan_uang' => array(
            //                 'link' => base_url().'logged/bantuan/bantuan_uang',
            //                 'awesome' => '',
            //                 'title' => 'Bantuan Uang',
            //                 'sub' => NULL
            //             ),
            //             'barang_persediaan' => array(
            //                 'link' => base_url().'logged/bantuan/barang_persediaan',
            //                 'awesome' => '',
            //                 'title' => 'Barang Persediaan',
            //                 'sub' => NULL
            //             ),
            //             'aktiva_tetap' => array(
            //                 'link' => base_url().'logged/bantuan/aktiva_tetap',
            //                 'awesome' => '',
            //                 'title' => 'Aktiva Tetap',
            //                 'sub' => NULL
            //             ) 
            //         )
            //     ),
            //     'transaksi' => array(
            //         'link' => '#',
            //         'awesome' => 'fa-exchange',
            //         'title' => 'Transaksi',
            //         'sub' => array(
            //             'donatur' => array(
            //                 'link' => base_url().'logged/transaksi/pegawai',
            //                 'awesome' => '',
            //                 'title' => 'Pegawai',
            //                 'sub' => NULL
            //             ),
            //             'penerimaan' => array(
            //                 'link' => base_url().'logged/transaksi/penerimaan',
            //                 'awesome' => '',
            //                 'title' => 'Penerimaan',
            //                 'sub' => NULL
            //             ),
            //             'pengeluaran' => array(
            //                 'link' => base_url().'logged/transaksi/pengeluaran',
            //                 'awesome' => '',
            //                 'title' => 'Pengeluaran',
            //                 'sub' => NULL
            //             ),
            //             'uang_muka' => array(
            //                 'link' => base_url().'logged/transaksi/uang_muka',
            //                 'awesome' => '',
            //                 'title' => 'Uang Muka',
            //                 'sub' => NULL
            //             ),
            //             'pertanggungjawaban_uang_muka' => array(
            //                 'link' => base_url().'logged/transaksi/pertanggungjawaban_uang_muka',
            //                 'awesome' => '',
            //                 'title' => 'PJ. Uang Muka',
            //                 'sub' => NULL
            //             ) 
            //         )
            //     )                 
            // );
        }
        $panti_stat = array(
            'panti_stat_pengasuh' => array(
                'link' => base_url().'logged/panti_stat_pengasuh',
                'awesome' => 'fa-user',
                'title' => 'Stat. Pengasuh Panti',
                'sub' => NULL
            ),
            'panti_stat_stat_anak_asuh' => array(
                'link' => base_url().'logged/panti_stat_anak_asuh',
                'awesome' => 'fa-group',
                'title' => 'Stat. Anak Asuh Panti',
                'sub' => NULL
            )  
        );
        // return variable
        $return = array(
            'main' => $main,
            'panti' => $panti,
            'master' => $master,
            'print' => $print,
            'kab_stat' => $kab_stat,
            'panti_stat' => $panti_stat
        );
        return $return;
    }

    public function display($data){
        // load base css
        $data['load_style'] = $this->load_style('resource/themes/css/theme-default.css');
        // load session
        $data['session'] =$this->session->userdata('mpspwmdiy_system'); 
        // side menu management
        $side_menu = $this->side_bar();
        $data['main_menu'] = $side_menu['main'];
        $data['panti_menu'] = $side_menu['panti'];
        $data['master_menu'] = $side_menu['master'];
        $data['cetak_menu'] = $side_menu['print'];
        $data['kab_stat'] = $side_menu['kab_stat'];
        $data['panti_stat'] = $side_menu['panti_stat'];
        $data['side_view'] = 'logged/side';
        // library management
        $data['datemanipulation'] = $this->datemanipulation;
    	$this->load->view('logged/general_view', $data);
    }

    public function load_javascript($path) {
        if(is_file($path)) {
            $this->javascript .= '<script type="text/javascript" src="' . base_url() . $path . '"></script>';
            $this->javascript .= "\n";
            // assign
            return $this->javascript;
        }else {
            $msg = "File berikut ini tidak ditemukan : " . base_url() . $path;
            show_error($msg, 404);
        }
    }

    public function load_style($css_file, $media = "all") {
        // assign
        if(is_file($css_file)) {
            $this->style .= '<link rel="stylesheet" type="text/css" href="' . base_url() . $css_file . '" media="' . $media . '" />';
            $this->style .= "\n";
            // assign
            return $this->style;
        }else {
            $msg = "File berikut ini tidak ditemukan : " . base_url() . $css_file;
            show_error($msg, 404);
        }
    }

    public function get_user_detail(){
        // define the session
        $sess = $this->session->userdata('mpspwmdiy_system');
        return $sess;
    }

    // melakukan logout
    public function logout(){
        $newdata = ($this->session->all_userdata());
        $this->session->unset_userdata($newdata);
        $this->session->sess_destroy();
        redirect('default_controller','refresh');
    }

    // security
    function encrypt_decrypt($action, $string) {
        $output = false;
        $encrypt_method = "AES-256-CBC";
        $secret_key = 'This is my secret key';
        $secret_iv = 'This is my secret iv';
        $key = hash('sha256', $secret_key);
        $iv = substr(hash('sha256', $secret_iv), 0, 16);
        if ( $action == 'encrypt' ) {
            $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
            $output = base64_encode($output);
        } else if( $action == 'decrypt' ) {
            $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
        }
        return $output;
    }
}